/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.OrgRoleDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgRoleManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgRole;
import com.artfess.uc.model.Role;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgRoleManagerImpl
extends BaseManagerImpl<OrgRoleDao, OrgRole>
implements OrgRoleManager {
    @Override
    @Transactional
    public void addOrgRole(String orgId, Role role, int isInherit) throws SQLException {
        OrgRole or = ((OrgRoleDao)this.baseMapper).getByOrgIdAndRoleId(orgId, role.getId());
        if (BeanUtils.isNotEmpty((Object)or)) {
            or.setIsDelete("0");
            or.setIsInherit(isInherit);
            or.setOrgId(orgId);
            or.setRoleName(role.getName());
            or.setRoleId(role.getId());
            this.update((Model)or);
        } else {
            or = new OrgRole();
            or.setId(UniqueIdUtil.getSuid());
            or.setIsInherit(isInherit);
            or.setOrgId(orgId);
            or.setRoleId(role.getId());
            or.setRoleName(role.getName());
            or.setVersion(1);
            this.create((Model)or);
        }
    }

    @Override
    @Transactional
    public void delByOrgIdAndRoleId(String orgId, String roleId) {
        ((OrgRoleDao)this.baseMapper).delByOrgIdAndRoleId(orgId, roleId, LocalDateTime.now());
    }

    @Transactional(readOnly=true)
    public PageList<OrgRole> query(QueryFilter<OrgRole> queryFilter) {
        Map<String, Object> queryFilterParams = this.getInitParams(queryFilter);
        if (BeanUtils.isNotEmpty(queryFilterParams) && queryFilterParams.containsKey("orgId")) {
            String orgId = (String)queryFilterParams.get("orgId");
            OrgManager orgService = (OrgManager)AppUtil.getBean(OrgManager.class);
            Org org = (Org)orgService.get((Serializable)((Object)orgId));
            if (BeanUtils.isNotEmpty((Object)org)) {
                queryFilter.addParams("path", (Object)org.getPath());
            }
        }
        PageBean pageBean = queryFilter.getPageBean();
        IPage<OrgRole> result = ((OrgRoleDao)this.baseMapper).query((IPage<OrgRole>)this.convert2IPage(pageBean), (Wrapper<OrgRole>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    public Map<String, Object> getInitParams(QueryFilter queryFilter) {
        List querys = queryFilter.getQuerys();
        LinkedHashMap<String, Object> initParams = new LinkedHashMap<String, Object>();
        if (BeanUtils.isEmpty((Object)querys)) {
            return initParams;
        }
        for (QueryField element : querys) {
            QueryField queryField = element;
            QueryOP operation = queryField.getOperation();
            if (QueryOP.IS_NULL.equals((Object)operation) || QueryOP.NOTNULL.equals((Object)operation) || QueryOP.IN.equals((Object)operation)) continue;
            String property = queryField.getProperty();
            if (property.indexOf(".") > -1) {
                property = property.substring(property.indexOf(".") + 1);
            }
            Object value = queryField.getValue();
            initParams.put(property, value);
        }
        initParams.putAll(queryFilter.getParams());
        return initParams;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgRoleDao)this.baseMapper).removePhysical();
    }
}

