/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.persistence.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.application.model.MessageConfig;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.model.RemindConfig;
import com.artfess.application.persistence.dao.RemindConfigDao;
import com.artfess.application.persistence.manager.MessageConfigManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.persistence.manager.RemindConfigManager;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.job.persistence.manager.SchedulerService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RemindConfigManagerImpl
extends BaseManagerImpl<RemindConfigDao, RemindConfig>
implements RemindConfigManager {
    @Autowired
    SchedulerService schedulerService;
    @Autowired
    Scheduler scheduler;
    @Autowired
    private MessageConfigManager messageConfigManager;
    @Autowired
    private MsgTemplateManager msgTemplateManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BaseContext baseContext;

    @Override
    public PageList<RemindConfig> findByPage(QueryFilter<RemindConfig> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage result = ((RemindConfigDao)this.baseMapper).selectPage(this.convert2IPage(pageBean), (Wrapper)this.convert2Wrapper(queryFilter, currentModelClass));
        result.getRecords().forEach(remindConfig -> {
            try {
                String jobName = remindConfig.getName() + ":" + remindConfig.getCode() + ":" + this.scheduler.getSchedulerName();
                TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
                Trigger.TriggerState state = this.scheduler.getTriggerState(key);
                remindConfig.setTaskStatus(state.name());
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        });
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateInfo(RemindConfig remindConfig) throws Exception {
        Assert.hasText((String)remindConfig.getTplKey(), (String)"\u8bf7\u9009\u62e9\u77ed\u4fe1\u6a21\u677f");
        if (this.checkSameCode(remindConfig.getCode(), remindConfig.getId())) {
            throw new RequiredException("\u6dfb\u52a0\u5de5\u4f5c\u63d0\u9192\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u4efb\u52a1\u3010" + remindConfig.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        String jobName = remindConfig.getName() + ":" + remindConfig.getCode() + ":" + this.scheduler.getSchedulerName();
        boolean jobExists = this.schedulerService.isJobExists(jobName);
        boolean isSuccess = true;
        if (!jobExists) {
            String className = remindConfig.getPlanClass();
            String description = remindConfig.getDescription();
            HashMap parameter = Maps.newHashMap();
            parameter.put("msgId", remindConfig.getMsgId());
            CommonResult result = this.schedulerService.addJob(jobName, className, (Map)parameter, description);
            isSuccess = result.getState();
        }
        if (isSuccess) {
            boolean b = this.saveOrUpdate((Object)remindConfig);
            if (b) {
                this.processMessageConfig(remindConfig);
            }
            return b;
        }
        return isSuccess;
    }

    private void processMessageConfig(RemindConfig remindConfig) throws IOException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TPL_KEY_", (Object)remindConfig.getTplKey());
        List messageConfigs = this.messageConfigManager.list((Wrapper)queryWrapper);
        MessageConfig messageConfig = new MessageConfig();
        if (!messageConfigs.isEmpty()) {
            messageConfig = (MessageConfig)((Object)messageConfigs.get(0));
        }
        messageConfig.setTplKey(remindConfig.getTplKey());
        messageConfig.setCode(remindConfig.getCode());
        messageConfig.setName(remindConfig.getName());
        messageConfig.setNotifyType(remindConfig.getNotifyType());
        messageConfig.setUserStr(remindConfig.getUserStr());
        messageConfig.setUserConfigType(remindConfig.getUserConfigType());
        String userStr = remindConfig.getUserStr();
        Assert.hasText((String)userStr, (String)"\u8bf7\u9009\u62e9\u63a5\u6536\u4eba");
        List list = (List)JsonUtil.toBean((String)userStr, List.class);
        String userId = "";
        String orgId = "";
        for (Map m : list) {
            String codes;
            String type = String.valueOf(m.get("type"));
            if ("user".equalsIgnoreCase(type)) {
                codes = String.valueOf(m.get("codes"));
                if (StringUtils.isBlank((CharSequence)codes)) continue;
                ArrayNode userByAccounts = this.ucFeignService.getUserByAccounts(codes);
                for (JsonNode userByAccount : userByAccounts) {
                    String id = userByAccount.get("id").toString();
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    userId = id.replace("\"", "").replace("\"", "") + ",";
                }
            }
            if ("org".equalsIgnoreCase(type)) {
                codes = String.valueOf(m.get("codes"));
                if (StringUtils.isBlank((CharSequence)codes)) continue;
                ArrayNode orgList = this.ucFeignService.getOrgListByCodes(codes);
                for (JsonNode org : orgList) {
                    orgId = org.get("id").toString() + ",";
                }
            }
            if (!StringUtil.isEmpty((String)orgId)) {
                messageConfig.setOrgId(orgId.substring(0, orgId.lastIndexOf(",")));
            }
            if (!StringUtil.isEmpty((String)userId)) {
                messageConfig.setUserId(userId.substring(0, userId.lastIndexOf(",")));
            }
            this.messageConfigManager.saveOrUpdate((Object)messageConfig);
        }
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u5de5\u4f5c\u63d0\u9192\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)code);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((RemindConfigDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteRemindConfigById(String id) throws SchedulerException {
        boolean isExist;
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de5\u4f5c\u63d0\u9192");
        RemindConfig remindConfig = (RemindConfig)((Object)((RemindConfigDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)remindConfig), (String)"\u5de5\u4f5c\u63d0\u9192\u4e0d\u5b58\u5728");
        boolean deleteStatus = this.removeById((Serializable)((Object)id));
        if (!deleteStatus) {
            return deleteStatus;
        }
        String jobName = remindConfig.getName() + ":" + remindConfig.getCode() + ":" + this.scheduler.getSchedulerName();
        boolean rtn = this.schedulerService.isTriggerExists(jobName);
        if (rtn) {
            this.schedulerService.delTrigger(jobName);
        }
        if (isExist = this.schedulerService.isJobExists(jobName)) {
            this.schedulerService.delJob(jobName);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean toggleTriggerRun(String id) throws Exception {
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de5\u4f5c\u63d0\u9192");
        RemindConfig remindConfig = (RemindConfig)((Object)((RemindConfigDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)remindConfig), (String)"\u5de5\u4f5c\u63d0\u9192\u4e0d\u5b58\u5728");
        String jobName = remindConfig.getName() + ":" + remindConfig.getCode() + ":" + this.scheduler.getSchedulerName();
        TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        boolean rtn = this.schedulerService.isTriggerExists(jobName);
        if (!rtn) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)remindConfig.getPlanType());
            jsonObject.put("timeInterval", (Object)remindConfig.getPlanInterval());
            this.schedulerService.addTrigger(jobName, jobName, JSON.toJSONString((Object)jsonObject));
        } else if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
        } else if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean executeJob(String id) throws SchedulerException {
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de5\u4f5c\u63d0\u9192");
        RemindConfig remindConfig = (RemindConfig)((Object)((RemindConfigDao)this.baseMapper).selectById((Serializable)((Object)id)));
        String jobName = remindConfig.getName() + ":" + remindConfig.getCode() + ":" + this.scheduler.getSchedulerName();
        JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
        this.scheduler.triggerJob(key);
        return true;
    }

    @Override
    public RemindConfig findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de5\u4f5c\u63d0\u9192");
        RemindConfig remindConfig = (RemindConfig)((Object)((RemindConfigDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)remindConfig), (String)"\u5de5\u4f5c\u63d0\u9192\u4e0d\u5b58\u5728");
        MsgTemplate msgTemplate = (MsgTemplate)this.msgTemplateManager.get((Serializable)((Object)remindConfig.getMsgId()));
        if (null != msgTemplate) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TPL_KEY_", (Object)msgTemplate.getKey());
            List messageConfigs = this.messageConfigManager.list((Wrapper)queryWrapper);
            MessageConfig messageConfig = new MessageConfig();
            if (!messageConfigs.isEmpty()) {
                messageConfig = (MessageConfig)((Object)messageConfigs.get(0));
                remindConfig.setTplKey(messageConfig.getTplKey());
                remindConfig.setNotifyType(messageConfig.getNotifyType());
                remindConfig.setUserStr(messageConfig.getUserStr());
            }
        }
        return remindConfig;
    }
}

