/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    public static String getPrevMonthDate(String dateString, int n) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM").parse(dateString);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - n);
        return new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
    }

    public static String getNowTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        String lastMonth = dft.format(cal.getTime());
        return lastMonth;
    }

    public static boolean isFirstDayOfMonth() {
        boolean flag = false;
        Calendar calendar = Calendar.getInstance();
        int today = calendar.get(5);
        if (1 == today) {
            flag = true;
        }
        return flag;
    }

    public static String getMaxMonthDate() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.getActualMaximum(5));
        return dft.format(calendar.getTime());
    }

    public static String getPerFirstDayOfMonth() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMinimum(5));
        return dft.format(calendar.getTime());
    }

    public static String getLastMaxMonthDate() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        return dft.format(calendar.getTime());
    }

    public static String getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMM");
        String lastMonth = dft.format(cal.getTime());
        return lastMonth;
    }

    public static String getPreMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMM");
        String preMonth = dft.format(cal.getTime());
        return preMonth;
    }

    public static boolean isLastDayOfMonth() {
        boolean flag = false;
        if (StringUtils.isNotBlank((String)DateUtil.getNowTime()) && StringUtils.isNotBlank((String)DateUtil.getMaxMonthDate()) && StringUtils.equals((String)DateUtil.getNowTime(), (String)DateUtil.getMaxMonthDate())) {
            flag = true;
        }
        return flag;
    }

    public static String getPreMonth(String repeatDate) {
        String lastMonth = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMM");
        int year = Integer.parseInt(repeatDate.substring(0, 4));
        String monthsString = repeatDate.substring(4, 6);
        int month = "0".equals(monthsString.substring(0, 1)) ? Integer.parseInt(monthsString.substring(1, 2)) : Integer.parseInt(monthsString.substring(0, 2));
        cal.set(year, month, 5);
        lastMonth = dft.format(cal.getTime());
        return lastMonth;
    }

    public static String getLastMonth(String repeatDate) {
        String lastMonth = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMM");
        int year = Integer.parseInt(repeatDate.substring(0, 4));
        String monthsString = repeatDate.substring(4, 6);
        int month = "0".equals(monthsString.substring(0, 1)) ? Integer.parseInt(monthsString.substring(1, 2)) : Integer.parseInt(monthsString.substring(0, 2));
        cal.set(year, month - 2, 5);
        lastMonth = dft.format(cal.getTime());
        return lastMonth;
    }

    public static String getMaxMonthDate(String repeatDate) {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        try {
            if (StringUtils.isNotBlank((String)repeatDate) && !"{}".equals(repeatDate)) {
                calendar.setTime(dft.parse(repeatDate));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.set(5, calendar.getActualMaximum(5));
        return dft.format(calendar.getTime());
    }

    public static String getMinMonthDate(String repeatDate) {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        try {
            if (StringUtils.isNotBlank((String)repeatDate) && !"{}".equals(repeatDate)) {
                calendar.setTime(dft.parse(repeatDate));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.set(5, calendar.getActualMinimum(5));
        return dft.format(calendar.getTime());
    }

    public static String getModify2DaysAgo(String repeatDate) {
        Calendar cal = Calendar.getInstance();
        String daysAgo = "";
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        if (repeatDate == null || "".equals(repeatDate)) {
            cal.set(5, cal.get(5) - 2);
        } else {
            int year = Integer.parseInt(repeatDate.substring(0, 4));
            String monthsString = repeatDate.substring(4, 6);
            int month = "0".equals(monthsString.substring(0, 1)) ? Integer.parseInt(monthsString.substring(1, 2)) : Integer.parseInt(monthsString.substring(0, 2));
            String dateString = repeatDate.substring(6, 8);
            int date = "0".equals(dateString.subSequence(0, 1)) ? Integer.parseInt(dateString.substring(1, 2)) : Integer.parseInt(dateString.substring(0, 2));
            cal.set(year, month - 1, date - 1);
            System.out.println(dft.format(cal.getTime()));
        }
        daysAgo = dft.format(cal.getTime());
        return daysAgo;
    }

    public static String getModifyNumDaysAgo(String repeatDate, int param) {
        Calendar cal = Calendar.getInstance();
        String daysAgo = "";
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        if (repeatDate == null || "".equals(repeatDate)) {
            cal.set(5, cal.get(5) - param);
        } else {
            int year = Integer.parseInt(repeatDate.substring(0, 4));
            String monthsString = repeatDate.substring(4, 6);
            int month = "0".equals(monthsString.substring(0, 1)) ? Integer.parseInt(monthsString.substring(1, 2)) : Integer.parseInt(monthsString.substring(0, 2));
            String dateString = repeatDate.substring(6, 8);
            int date = "0".equals(dateString.subSequence(0, 1)) ? Integer.parseInt(dateString.substring(1, 2)) : Integer.parseInt(dateString.substring(0, 2));
            cal.set(year, month - 1, date - param + 1);
            System.out.println(dft.format(cal.getTime()));
        }
        daysAgo = dft.format(cal.getTime());
        return daysAgo;
    }
}

