/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.manage.material.manager.CmgtMaterialUsedDetailManager;
import com.artfess.manage.material.model.CmgtMaterialUsedDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u8d44\u7ba1\u7406-\u5e38\u7528\u7269\u8d44"})
@RequestMapping(value={"/manager/material/usedDetail/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialUsedDetailController
extends BaseController<CmgtMaterialUsedDetailManager, CmgtMaterialUsedDetail> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialUsedDetailController.class);
    @Resource
    BaseContext baseContext;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) CmgtMaterialUsedDetail t) {
        boolean save = ((CmgtMaterialUsedDetailManager)this.baseService).save((Object)t);
        if (t.getSn() == null) {
            t.setSn(((CmgtMaterialUsedDetailManager)this.baseService).getNextSequence(null));
        }
        ((CmgtMaterialUsedDetailManager)this.baseService).updateById((Object)t);
        if (!save) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) CmgtMaterialUsedDetail t) {
        boolean b;
        if (t.getSn() == null) {
            t.setSn(((CmgtMaterialUsedDetailManager)this.baseService).getNextSequence(null));
        }
        if (!(b = ((CmgtMaterialUsedDetailManager)this.baseService).updateById((Object)t))) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @RequestMapping(value={"updateSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7", notes="\u6279\u91cf\u4fee\u6539\u6392\u5e8f\u53f7")
    public CommonResult<String> updateSequence(@ApiParam(name="params", value="\u6392\u5e8f\u53c2\u6570\uff1aKey\uff1aID\uff0cValue\uff1a\u6392\u5e8f\u53f7") @RequestBody HashMap<String, Integer> params) throws Exception {
        if (!params.isEmpty()) {
            ((CmgtMaterialUsedDetailManager)this.baseService).updateSequence(params);
        }
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value={"/findByOrgUseDetail"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u8be5\u90e8\u95e8\u5e38\u7528\u7269\u8d44")
    public CommonResult<CmgtMaterialUsedDetail> findByOrgUseDetail(@ApiParam(name="model", value="\u5e38\u7528\u7269\u8d44\u67e5\u8be2\u6761\u4ef6") @RequestBody CmgtMaterialUsedDetail usedDetail) {
        String currentOrgId = this.baseContext.getCurrentOrgId();
        usedDetail.setCreateOrgId(currentOrgId);
        List<CmgtMaterialUsedDetail> list = ((CmgtMaterialUsedDetailManager)this.baseService).findByOrgUseDetail(usedDetail);
        return CommonResult.success(list, null);
    }
}

