/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.material.dao.CmgtMaterialQuantityDao;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u8d44\u7ba1\u7406-\u7269\u8d44\u5e93\u5b58"})
@RequestMapping(value={"/manager/material/quantity/"})
@ApiGroup(group={"manager_biz"})
public class CmgtMaterialQuantityController
extends BaseController<CmgtMaterialQuantityManage, CmgtMaterialQuantity> {
    private static final Logger log = LoggerFactory.getLogger(CmgtMaterialQuantityController.class);
    @Resource
    private CmgtMaterialQuantityDao cmgtMaterialQuantityDao;
    @Resource
    private CmgtMaterialQuantityManage cmgtMaterialQuantityManage;

    @PostMapping(value={"/findAllQuantity"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u5e93\u5b58\u4fe1\u606f")
    public List<Map<String, Object>> findAllUnit(@RequestBody String quantityId) {
        List<Map<String, Object>> list = this.cmgtMaterialQuantityDao.findDetailByquantityId(quantityId);
        return list;
    }

    @PostMapping(value={"/pageQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public PageList<CmgtMaterialQuantity> pageQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CmgtMaterialQuantity> queryFilter) {
        return this.cmgtMaterialQuantityManage.pageQuery(queryFilter);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = this.cmgtMaterialQuantityManage.delete(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

