/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.base;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.manage.base.ManageCommonService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/manager/common/"})
@ApiGroup(group={"manager_biz"})
public class ManageCommonController {
    private static final Logger log = LoggerFactory.getLogger(ManageCommonController.class);
    @Resource
    private ManageCommonService manageCommonService;

    @GetMapping(value={"/select/options"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9009\u62e9\u9009\u9879\u96c6\u5408")
    public List<Object> findSelectOptions(String name, String query) {
        return this.manageCommonService.findSelectOptions(name, query);
    }

    @GetMapping(value={"/select/duty/months"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u52e4\u52a1\u6708\u4efd\u9009\u9879")
    public JSONArray getDutyMonths() {
        JSONArray r = JSONUtil.createArray();
        Date now = new Date();
        int xh = 0;
        for (int i = -6; i < 2; ++i) {
            DateTime newDate = DateUtil.offset((Date)now, (DateField)DateField.MONTH, (int)i);
            r.add((Object)JSONUtil.createObj().putOpt("value", (Object)xh).putOpt("text", (Object)DateUtil.format((Date)newDate, (String)"yyyy\u5e74MM\u6708")).putOpt("wd", (Object)DateUtil.format((Date)DateUtil.beginOfMonth((Date)newDate), (String)"yyyy-MM")).putOpt("min", (Object)DateUtil.format((Date)DateUtil.beginOfMonth((Date)newDate), (String)"yyyy-MM-dd")).putOpt("max", (Object)DateUtil.format((Date)DateUtil.endOfMonth((Date)newDate), (String)"yyyy-MM-dd")));
            ++xh;
        }
        return r;
    }

    @GetMapping(value={"/select/duty/days"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u52e4\u52a1\u6708\u6240\u6709\u65e5\u671f\u9009\u9879")
    public JSONArray getDutyDays(String cdate) {
        JSONArray r = JSONUtil.createArray();
        DateTime beginDate = DateUtil.beginOfMonth((Date)DateUtil.parseDate((CharSequence)cdate));
        DateTime endDate = DateUtil.endOfMonth((Date)DateUtil.parseDate((CharSequence)cdate));
        int xh = 0;
        for (int i = 0; i < 31; ++i) {
            DateTime newDate = DateUtil.offset((Date)beginDate, (DateField)DateField.DAY_OF_MONTH, (int)i);
            r.add((Object)JSONUtil.createObj().putOpt("value", (Object)xh).putOpt("text", (Object)DateUtil.format((Date)newDate, (String)"yyyy-MM-dd")).putOpt("week", (Object)DateUtil.dayOfWeekEnum((Date)newDate).toChinese()).putOpt("week", (Object)DateUtil.dayOfWeekEnum((Date)newDate).toChinese()).putOpt("min", (Object)DateUtil.format((Date)DateUtil.beginOfMonth((Date)newDate), (String)"yyyy-MM-dd")).putOpt("max", (Object)DateUtil.format((Date)DateUtil.endOfMonth((Date)newDate), (String)"yyyy-MM-dd")));
            if (newDate.equals(endDate)) break;
            ++xh;
        }
        return r;
    }

    @GetMapping(value={"/select/org/zgj"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u7efc\u7ba1\u5c40\u7ec4\u7ec7")
    public List<JSONObject> getZgjOrgs() {
        return this.manageCommonService.findZGJOrg().stream().map(o -> JSONUtil.createObj().putOpt("text", (Object)o.getName()).putOpt("value", (Object)o.getId())).collect(Collectors.toList());
    }

    @PostMapping(value={"/upload/excel"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    public ResponseEntity<Object> upload(@RequestParam(value="file") MultipartFile file) throws IOException {
        ExcelReader reader = ExcelUtil.getReader((InputStream)file.getInputStream(), (int)0);
        List rowsList = reader.readAll();
        System.out.println("==========rowsList=========" + rowsList);
        HashMap<String, String> ro = new HashMap<String, String>();
        ro.put("realName", file.getName());
        return new ResponseEntity(ro, HttpStatus.OK);
    }
}

