/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.script;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.community.script.ScriptFactory;
import org.jetlinks.community.script.ScriptFactoryProvider;
import org.jetlinks.community.script.nashorn.NashornScriptFactoryProvider;

public class Scripts {
    private static final List<ScriptFactoryProvider> providers = new CopyOnWriteArrayList<ScriptFactoryProvider>();
    private static final Map<String, ScriptFactory> globals = new ConcurrentHashMap<String, ScriptFactory>();

    private static ScriptFactoryProvider lookup(String lang) {
        for (ScriptFactoryProvider provider : providers) {
            if (!provider.isSupport(lang)) continue;
            return provider;
        }
        throw new UnsupportedOperationException("unsupported script lang:" + lang);
    }

    public static ScriptFactory getFactory(String lang) {
        return globals.computeIfAbsent(lang, Scripts::newFactory);
    }

    public static ScriptFactory newFactory(String lang) {
        return Scripts.lookup(lang).factory();
    }

    static {
        providers.add(new NashornScriptFactoryProvider());
        try {
            for (ScriptFactoryProvider scriptFactoryProvider : ServiceLoader.load(ScriptFactoryProvider.class)) {
                providers.add(scriptFactoryProvider);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

