/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.web.response;

import java.util.List;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.web.response.DimensionInfo;
import org.jetlinks.core.metadata.DataType;
import reactor.core.publisher.Mono;

public class MeasurementInfo {
    private String id;
    private String name;
    private DataType type;
    private List<DimensionInfo> dimensions;

    public static Mono<MeasurementInfo> of(Measurement measurement) {
        return measurement.getDimensions().map(DimensionInfo::of).collectList().map(list -> {
            MeasurementInfo info = new MeasurementInfo();
            info.setId(measurement.getDefinition().getId());
            info.setName(measurement.getDefinition().getName());
            info.setDimensions((List<DimensionInfo>)list);
            return info;
        });
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public List<DimensionInfo> getDimensions() {
        return this.dimensions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public void setDimensions(List<DimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }
}

