/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements.sys;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.jetlinks.community.dashboard.measurements.SystemMonitor;
import org.jetlinks.community.dashboard.measurements.sys.CpuInfo;
import org.jetlinks.community.dashboard.measurements.sys.DiskInfo;
import org.jetlinks.community.dashboard.measurements.sys.MemoryInfo;
import org.jetlinks.community.dashboard.measurements.sys.MonitorUtils;
import org.jetlinks.community.dashboard.measurements.sys.SystemInfo;
import org.jetlinks.community.dashboard.measurements.sys.SystemMonitorService;
import reactor.core.publisher.Mono;

public class SystemMonitorServiceImpl
implements SystemMonitorService {
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final int MB = 0x100000;

    @Override
    public Mono<SystemInfo> system() {
        return Mono.zip(this.cpu(), this.memory(), this.disk()).map(tp3 -> SystemInfo.of((CpuInfo)tp3.getT1(), (MemoryInfo)tp3.getT2(), (DiskInfo)tp3.getT3()));
    }

    @Override
    public Mono<DiskInfo> disk() {
        long total = 0L;
        long usable = 0L;
        for (File file : File.listRoots()) {
            total += file.getTotalSpace();
            usable += file.getUsableSpace();
        }
        DiskInfo diskInfo = new DiskInfo();
        diskInfo.setTotal(total / 0x100000L);
        diskInfo.setFree(usable / 0x100000L);
        return Mono.just((Object)diskInfo);
    }

    @Override
    public Mono<MemoryInfo> memory() {
        MemoryInfo info = new MemoryInfo();
        info.setSystemTotal((long)SystemMonitor.totalSystemMemory.value());
        info.setSystemFree((long)SystemMonitor.freeSystemMemory.value());
        MemoryUsage heap = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = memoryMXBean.getNonHeapMemoryUsage();
        long nonHeapMax = nonHeap.getMax() > 0L ? nonHeap.getMax() / 0x100000L : info.getSystemTotal();
        info.setJvmHeapFree((heap.getMax() - heap.getUsed()) / 0x100000L);
        info.setJvmHeapTotal(heap.getMax() / 0x100000L);
        info.setJvmNonHeapFree(nonHeapMax - nonHeap.getUsed() / 0x100000L);
        info.setJvmNonHeapTotal(nonHeapMax);
        return Mono.just((Object)info);
    }

    @Override
    public Mono<CpuInfo> cpu() {
        CpuInfo info = new CpuInfo();
        info.setSystemUsage(MonitorUtils.round((float)SystemMonitor.systemCpuUsage.value()));
        info.setJvmUsage(MonitorUtils.round((float)SystemMonitor.jvmCpuUsage.value()));
        return Mono.just((Object)info);
    }
}

