package com.artfess.uc.params.role;

import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.model.Role;
import com.artfess.uc.util.OperateLogUtil;
import com.artfess.uc.util.UpdateCompare;
import com.artfess.base.annotation.ExcelColumn;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 角色vo类
 * @author zhangxw
 *
 */
@ApiModel
public class RoleVo implements UpdateCompare {

	@ApiModelProperty(name="name",notes="角色名称",required=true)
	@ExcelColumn(value = "name", col = 0)
	private String name;
	
	@ApiModelProperty(name="code",notes="角色编码",required=true)
	@ExcelColumn(value = "code", col = 1)
	private String code;

	@ApiModelProperty(name="roleType",notes="角色类型（1：系统角色，2：普通角色）",required=true)
	@ExcelColumn(value = "roleType", col = 2)
	private Integer roleType;
	
	@ApiModelProperty(name="enabled",notes="是否禁用 0:禁用；1：正常（默认为正常）")
	@ExcelColumn(value = "enabled", col = 3)
	private Integer enabled;
	
	@ApiModelProperty(name="description",notes="角色描述")
	@ExcelColumn(value = "description", col = 4)
	private String description;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getRoleType() {
		return roleType;
	}

	public void setRoleType(Integer roleType) {
		this.roleType = roleType;
	}

	public Integer getEnabled() {
		return enabled;
	}

	public void setEnabled(Integer enabled) {
		this.enabled = enabled;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public static Role parse(RoleVo roleVo){
		Role role = new Role();
		role.setName(roleVo.getName());
		role.setCode(roleVo.getCode());
		role.setRoleType(BeanUtils.isEmpty(roleVo.getRoleType())?2:roleVo.getRoleType());
		role.setDescription(roleVo.getDescription());
		role.setEnabled(BeanUtils.isEmpty(roleVo.getEnabled())?1:roleVo.getEnabled());
		return role;
	}

	@Override
	public String compare() throws Exception {
	    RoleManager roleService =	AppUtil.getBean(RoleManager.class);
	    Role oldRole=roleService.getByAlias(this.code);
		return OperateLogUtil.compare(this,changeVo(oldRole));
	}


	public RoleVo changeVo(Role role) {
		RoleVo roleVo=new RoleVo();
		if (BeanUtils.isEmpty(role)) return roleVo;
		roleVo.setCode(role.getCode());  
		roleVo.setDescription(role.getDescription());
		roleVo.setEnabled(role.getEnabled());
		roleVo.setName(role.getName());
		roleVo.setRoleType(role.getRoleType());
		return roleVo;
	}
}
