package com.artfess.uc.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* uc_pwd_strategy
* <pre> 
* 描述：uc_pwd_strategy 实体对象
* 构建组：x7
* 作者:tangxin
* 邮箱:tangxin@jee-soft.cn
* 日期:2020-05-19 10:52:36
* 版权：广州宏天软件有限公司
* </pre>
*/
@ApiModel(value = "PwdStrategy",description = "密码策略")
@TableName("uc_pwd_strategy")
public class PwdStrategy extends BaseModel<PwdStrategy>{

	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="ID_")
	@TableId("ID_")
	protected String id;
	
	@ApiModelProperty(value="初始化密码")
	@TableField("INIT_PWD_")
	protected String initPwd;
	
	@ApiModelProperty(value="密码策略")
	@TableField("PWD_RULE_")
	protected Short pwdRule;
	
	@ApiModelProperty(value="密码长度")
	@TableField("PWD_LENGTH_")
	protected Short pwdLength;
	
	@ApiModelProperty(value="密码可用时长")
	@TableField("DURATION_")
	protected Short duration;

	@ApiModelProperty(value="密码错误锁定状态（0：关闭【默认】 1：开启 ）")
	@TableField("LOCK_STATUS_")
	protected Short lockStatus =0;

	@ApiModelProperty(value="密码错误次数")
	@TableField("LOCK_TIMES_")
	protected Short lockTimes;

	@ApiModelProperty(value="锁定后自动解锁时长")
	@TableField("AUTO_UNLOCK_TIME_")
	protected Short autoUnlockTime;

	@ApiModelProperty(value="首次登录是否必须修改密码（0：否  1：是）")
	@TableField("INIT_UPDATE_")
	protected Short initUpdate = 0;
	
	@ApiModelProperty(value="启用策略	0:停用，1:启用")
	@TableField("ENABLE_")
	protected Short enable = 1;

	public PwdStrategy() {
	}

	public PwdStrategy(String initPwd, Short pwdRule, Short pwdLength, Short duration,Short lockStatus,Short lockTimes,Short autoUnlockTime,Short initUpdate, Short enable) {
		this.initPwd = initPwd;
		this.pwdRule = pwdRule;
		this.pwdLength = pwdLength;
		this.duration = duration;
		this.lockStatus = lockStatus;
		this.lockTimes = lockTimes;
		this.autoUnlockTime = autoUnlockTime;
		this.initUpdate = initUpdate;
		this.enable = enable;
	}

	public PwdStrategy(String id, String initPwd, Short pwdRule, Short pwdLength, Short duration,Short lockStatus,Short lockTimes,Short autoUnlockTime,Short initUpdate, Short enable) {
		this.id = id;
		this.initPwd = initPwd;
		this.pwdRule = pwdRule;
		this.pwdLength = pwdLength;
		this.duration = duration;
		this.lockStatus = lockStatus;
		this.lockTimes = lockTimes;
		this.autoUnlockTime = autoUnlockTime;
		this.initUpdate = initUpdate;
		this.enable = enable;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getInitPwd() {
		return initPwd;
	}

	public void setInitPwd(String initPwd) {
		this.initPwd = initPwd;
	}

	public Short getPwdRule() {
		return pwdRule;
	}

	public void setPwdRule(Short pwdRule) {
		this.pwdRule = pwdRule;
	}

	public Short getPwdLength() {
		return pwdLength;
	}

	public void setPwdLength(Short pwdLength) {
		this.pwdLength = pwdLength;
	}

	public Short getDuration() {
		return duration;
	}

	public void setDuration(Short duration) {
		this.duration = duration;
	}

	public Short getEnable() {
		return enable;
	}

	public void setEnable(Short enable) {
		this.enable = enable;
	}

	public Short getLockStatus() {
		return lockStatus;
	}

	public void setLockStatus(Short lockStatus) {
		this.lockStatus = lockStatus;
	}

	public Short getLockTimes() {
		return lockTimes;
	}

	public void setLockTimes(Short lockTimes) {
		this.lockTimes = lockTimes;
	}

	public Short getAutoUnlockTime() {
		return autoUnlockTime;
	}

	public void setAutoUnlockTime(Short autoUnlockTime) {
		this.autoUnlockTime = autoUnlockTime;
	}

	public Short getInitUpdate() {
		return initUpdate;
	}

	public void setInitUpdate(Short initUpdate) {
		this.initUpdate = initUpdate;
	}
}
