package com.artfess.form.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @program: cqgs
 * @Date: 2020/9/26 15:20
 * @Author: ZQF
 * @Description: 元件管理-数据有效性校验配置表
 */
@Data
@ApiModel(value = "ComponentValid对象",description = "元件管理-数据有效性校验配置表")
@TableName("SYS_COMPONENT_VALID")
public class ComponentValidEntity extends BaseModel<ComponentValidEntity> {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name = "id", notes = "主键")
    @TableId("id_")
    protected String id;

    @TableField("VALID_NAME")
    @ApiModelProperty("有效性校验名")
    private String validName;

    @TableField("VALID_MODE")
    @ApiModelProperty("校验方式 （1：函数方法 2：正则表达式 3：框架校验规则）")
    private Integer validMode;

    @TableField("valid_trigger")
    @ApiModelProperty("校验触发事件（1：离开组件时 2：保存数据时）")
    private Integer validTrigger;

    @TableField("VALID_CONTENT")
    @ApiModelProperty("校验内容 （方法名或者正则表达式内容）")
    private String validContent;

    @TableField("valid_type")
    @ApiModelProperty("验证类型（1：值类型 2：范围类型 3：日期类型 4：无类型）")
    private Integer validType;

    @TableField("ERROR_MSG")
    @ApiModelProperty("校验失败提示内容")
    private String errorMsg;

    @TableField("sn_")
    @ApiModelProperty("排序")
    private Integer sn;

}
