package com.artfess.yhxt.tree.model;


import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 树形字典表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-04
 */
@ApiModel(value="BizTreeDictionary对象", description="树形字典表")
@TableName("BIZ_TREE_DICTIONARY")
public class TreeDictionary extends BizNoModel<TreeDictionary> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "父id")
    @TableField("PID_")
    private String pid;

    @ApiModelProperty(value = "父编码")
    @TableField("PCODE_")
    private String pcode;

    @ApiModelProperty(value = "父名称")
    @TableField("PNAME_")
    private String pname;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;


    @JsonIgnore
    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;



    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }
    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }
    public String getPname() {
        return pname;
    }

    public void setPname(String pname) {
        this.pname = pname;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return "TreeDictionary{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", pid='" + pid + '\'' +
                ", pcode='" + pcode + '\'' +
                ", pname='" + pname + '\'' +
                ", companyId='" + companyId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", sn=" + sn +
                ", remark='" + remark + '\'' +
                ", version=" + version +
                '}';
    }
    @Override
    protected Serializable pkVal() {
        return null;
    }

}
