package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.ProjectOverApplyFor;
import com.artfess.yhxt.specialproject.dao.ProjectOverApplyForDao;
import com.artfess.yhxt.specialproject.manager.ProjectOverApplyForManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.ProjectOverApplyForVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.hasor.utils.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.xml.crypto.Data;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 项目交工申请表 服务实现类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-18
 */
@Service
public class ProjectOverApplyForManagerImpl extends BaseManagerImpl<ProjectOverApplyForDao, ProjectOverApplyFor> implements ProjectOverApplyForManager {

    @Resource
    private BaseContext baseContext;
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<ProjectOverApplyFor> queryProjectOverApplyFor(QueryFilter<ProjectOverApplyFor> queryFilter) {
        IPage<ProjectOverApplyFor> result = baseMapper.queryProjectOverApplyFor(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor) {


        projectOverApplyFor.setIsDele("0");
        projectOverApplyFor.setStartupTime(LocalDate.now());
        projectOverApplyFor.setApplyUserId(baseContext.getCurrentUserId());
        projectOverApplyFor.setApplyUserName(baseContext.getCurrentUserName());
        projectOverApplyFor.setApplyUserOrgId(baseContext.getCurrentOrgId());
        projectOverApplyFor.setApplyUserOrg(baseContext.getCurrentOrgName());
        projectOverApplyFor.setConfirmStatus(0);
        this.create(projectOverApplyFor);
    }

    @Override
    public void updateProjectOverApplyFor(ProjectOverApplyFor projectOverApplyFor) {
        this.update(projectOverApplyFor);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerUserAudit(String ids,String ownerDescription ,Integer confirmStatu) {
        if (StringUtils.isNotBlank(ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            UpdateWrapper<ProjectOverApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_", list);
            IGroup currentGroup = ContextUtil.getCurrentGroup();
            updateWrapper.set("OWNER_USER_ID_", baseContext.getCurrentUserId());
            updateWrapper.set("OWNER_USER_NAME_", baseContext.getCurrentUserName());
            updateWrapper.set("OWNER_USER_ORG_ID_", baseContext.getCurrentOrgId());
            updateWrapper.set("OWNER_USER_ORG_", baseContext.getCurrentOrgName());
            //业主审核时间
            updateWrapper.set("OWNER_TIME_", LocalDate.now());
            updateWrapper.set("OWNER_DESCRIPTION_", ownerDescription);
            updateWrapper.set("CONFIRM_STATUS_",confirmStatu);
            this.update(null,updateWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirmUserAudit(String ids,String confirmDescription ,Integer confirmStatus) {
        if (StringUtils.isNotBlank(ids)) {
            List<String> list = Arrays.asList(ids.split(","));
            UpdateWrapper<ProjectOverApplyFor> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("ID_", list);
            updateWrapper.set("CONFIRM_USER_ID_", baseContext.getCurrentUserId());
            updateWrapper.set("CONFIRM_USER_NAME_", baseContext.getCurrentUserName());
            updateWrapper.set("CONFIRM_USER_ORG_ID_", baseContext.getCurrentOrgId());
            updateWrapper.set("CONFIRM_USER_ORG_", baseContext.getCurrentOrgName());

            //业主审核时间
            updateWrapper.set("CONFIRM_TIME_", LocalDate.now());
            updateWrapper.set("OWNER_DESCRIPTION_", confirmDescription);
            updateWrapper.set("CONFIRM_STATUS_",confirmStatus);
            this.update(null,updateWrapper);
        }
    }

    @Override
    public void saveVo(ProjectOverApplyForVo projectOverApplyForVo) {
        ProjectOverApplyFor projectOverApplyFor = projectOverApplyForVo.getProjectOverApplyFor();
        projectOverApplyFor.setIsDele("0");
        projectOverApplyFor.setConfirmStatus(0);
        projectOverApplyFor.setStartupTime(LocalDate.now());
        projectOverApplyFor.setApplyUserId(baseContext.getCurrentUserId());
        projectOverApplyFor.setApplyUserName(baseContext.getCurrentUserName());
        projectOverApplyFor.setApplyUserOrgId(baseContext.getCurrentOrgId());
        projectOverApplyFor.setApplyUserOrg(baseContext.getCurrentOrgName());
        projectOverApplyFor.setConfirmStatus(0);
        this.create(projectOverApplyFor);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectOverApplyForVo.getBizEngineeringAccessoriesList();
        String sourceId = projectOverApplyFor.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(ProjectOverApplyForVo projectOverApplyForVo) {
        ProjectOverApplyFor projectOverApplyFor = projectOverApplyForVo.getProjectOverApplyFor();

        Integer confirmStatus = projectOverApplyFor.getConfirmStatus();
        // 如如果监理方审核 不通过后则修改后重置为待审核状态
        if(null != confirmStatus && confirmStatus == 2){
            projectOverApplyFor.setConfirmStatus(0);
        }
        // 如如果业主方审核 不通过后则修改后重置为待审核状态
        if(null != confirmStatus && confirmStatus == 4){
            projectOverApplyFor.setConfirmStatus(0);
        }
        this.update(projectOverApplyFor);
        String sourceId = projectOverApplyFor.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = projectOverApplyForVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public ProjectOverApplyForVo getVo(String id) {
        ProjectOverApplyForVo projectOverApplyForVo = new ProjectOverApplyForVo();
        ProjectOverApplyFor projectOverApplyFor = this.getById(id);
        projectOverApplyForVo.setProjectOverApplyFor(projectOverApplyFor);
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        projectOverApplyForVo.setBizEngineeringAccessoriesList(bizEngineeringAccessoriesList);
        return projectOverApplyForVo;
    }


}
