package com.artfess.yhxt.open.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.open.base.util.JwtCheckUtils;
import com.artfess.yhxt.statistics.manager.BaseDataStatisticsManager;
import com.artfess.yhxt.statistics.model.PreviewURLsRequest;
import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/9/1
 */
@RestController
@RequestMapping("/server/")
@Api(tags = "基础数据统计对外接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BaseDataStatisticsOpenController {
    @Resource
    private BaseDataStatisticsManager baseDataStatisticsManager;
    @Resource
    private JwtCheckUtils jwtCheckUtils;

    @RequestMapping(value = "countBridgeStatistics", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁统计", httpMethod = "POST")
    public CommonResult<Map> countBridgeStatistics(@ApiParam(name = "map", value = "roadSegmentId:路段id companyId:公司id")
                                                 @RequestBody Map<String, Object> map, @RequestParam String token) {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<Map>(true, "获取桥梁统计成功", this.baseDataStatisticsManager.getBridgeStatistics(map));
        }else {
            return new CommonResult<Map>(false, "Token失效，请重新获取", null);
        }

    }

    @RequestMapping(value = "countTunnelStatistics", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道统计", httpMethod = "POST")
    public CommonResult<Map> countTunnelStatistics(@ApiParam(name = "map", value = "roadSegmentId:路段id companyId:公司id")
                                                 @RequestBody Map<String, Object> map,@RequestParam String token) {

        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<Map>(true, "获取隧道统计成功",  this.baseDataStatisticsManager.getTunnelStatistics(map));
        }else {
            return new CommonResult<Map>(false, "Token失效，请重新获取", null);
        }
    }



    //边坡、沿线、路段
    //桥梁、隧道、涵洞
    @RequestMapping(value = "/countAllStructureCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个结构数量", httpMethod = "POST", notes = "各个结构数量")
    public CommonResult<Map> countAllStructureCount(@ApiParam(name = "map",
            value = "roadSegmentId:路段id companyId:公司id routeId:路线ID")
                                                  @RequestBody Map<String, Object> map,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<Map>(true, "获取各个结构数量成功",  this.baseDataStatisticsManager.getAllStructureCount(map));
        }else {
            return new CommonResult<Map>(false, "Token失效，请重新获取", null);
        }
    }




    @RequestMapping(value = "/countMileage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "里程排行统计", httpMethod = "POST", notes = "里程排行统计")
    public CommonResult<List<MileageVo>> countMileage(@RequestBody BaseDataParamVo baseDataParamVo,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<MileageVo>>(true, "获取里程排行成功",  this.baseDataStatisticsManager.getRoadMileageCount(baseDataParamVo));
        }else {
            return new CommonResult<List<MileageVo>>(false, "Token失效，请重新获取", null);
        }

    }



    @RequestMapping(value = "/countMaintenanceStation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护站个数统计", httpMethod = "POST", notes = "养护站个数统计")
    public CommonResult<List<MaintenanceStationVo>>  countMaintenanceStation(@RequestBody BaseDataParamVo baseDataParamVo,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<MaintenanceStationVo>>(true, "获取养护站个数成功",  this.baseDataStatisticsManager.getMaintenanceStation(baseDataParamVo));
        }else {
            return new CommonResult<List<MaintenanceStationVo>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countUserCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "各个公司人员数查询", httpMethod = "POST", notes = "各个公司人员数查询")
    public CommonResult<List<CompanyUserVo>>  countUserCount(@RequestBody BaseDataParamVo baseDataParamVo,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CompanyUserVo>>(true, "获取各个公司人员数成功",  this.baseDataStatisticsManager.getUserCount(baseDataParamVo));
        }else {
            return new CommonResult<List<CompanyUserVo>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countRoadside", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "沿线设施", httpMethod = "POST", notes = "沿线设施")
    public CommonResult<List<CountRoadsideFacilities>>  countRoadside(@RequestBody BaseDataParamVo baseDataParamVo,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountRoadsideFacilities>>(true, "获取沿线设施成功",  this.baseDataStatisticsManager.countRoadsideFacilities(baseDataParamVo));
        }else {
            return new CommonResult<List<CountRoadsideFacilities>>(false, "Token失效，请重新获取", null);
        }
    }

    @RequestMapping(value = "/countVehicle", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护车辆统计", httpMethod = "POST", notes = "养护车辆统计")
    public CommonResult<List<CountVehicleVo>>  countVehicle(@RequestBody QueryFilter queryFilter,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountVehicleVo>>(true, "获取养护车辆统计成功",  this.baseDataStatisticsManager.countVehicle(queryFilter));
        }else {
            return new CommonResult<List<CountVehicleVo>>(false, "Token失效，请重新获取", null);
        }
    }


    @RequestMapping(value = "/countVehicleQuantity", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取养护车辆数量", httpMethod = "POST", notes = "获取养护车辆数量")
    public CommonResult<List<VehicleQuantityVo>>  countVehicleQuantity(@RequestBody QueryFilter queryFilter,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<VehicleQuantityVo>>(true, "获取养护车辆数量成功",  this.baseDataStatisticsManager.countVehicleQuantity());
        }else {
            return new CommonResult<List<VehicleQuantityVo>>(false, "Token失效，请重新获取", null);
        }
    }
    @RequestMapping(value = "/countAvgMileage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "平均里程养护费用", httpMethod = "POST", notes = "平均里程养护费用")
    public CommonResult<List<CountMileageVo>>  countAvgMileage(@RequestBody QueryFilter queryFilter,@RequestParam String token) throws Exception {
        boolean b = jwtCheckUtils.checkToken(token);
        if (b){
            return new CommonResult<List<CountMileageVo>>(true, "获取平均里程养护费用成功",  this.baseDataStatisticsManager.countAvgMileage(queryFilter));
        }else {
            return new CommonResult<List<CountMileageVo>>(false, "Token失效，请重新获取", null);
        }
    }










/*    @RequestMapping(value = "/getPreviewURLs", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取监控点预览取流URL", httpMethod = "POST", notes = "")
    public CommonResult<String> getPreviewURLs(@RequestBody PreviewURLsRequest previewURLsRequest) throws Exception {
        Map map = this.baseDataStatisticsManager.getPreviewURLs(previewURLsRequest);
        return new CommonResult<String>(true,String.valueOf(map.get("msg")), String.valueOf(map.get("data")));
    }*/

    }
