package com.artfess.yhxt.check.regular.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.vo.CulvertOftenCheckVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 涵洞经常检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-05
 */
public interface CulvertOftenCheckManager extends BaseManager<CulvertOftenCheck> {

    PageList<CulvertOftenCheck> queryCulvertOftenCheck(QueryFilter<CulvertOftenCheck> queryFilter);

    /**
     * 保存涵洞经常检查信息
     * @param vo
     */
    void saveCulvertOftenCheck(CulvertOftenCheckVo vo);

    /**
     * 修改涵洞经常检查信息
     * @param vo
     */
    void updateCulvertOftenCheck(CulvertOftenCheckVo vo);

    /**
     * 根据id查询涵洞经常检查信息
     * @param id
     * @return
     */
    CulvertOftenCheckVo getCulvertOftenCheckById(String id);

    void importExcelData(MultipartFile file, CulvertOftenCheck parseObject);
}
