package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 桥梁定期检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-16
 */
@ApiModel(value="BridgeRegularCheckDetail对象", description="桥梁定期检查明细表")
@TableName("biz_bridge_regular_check_detail")
public class BridgeRegularCheckDetail extends BaseModel<BridgeRegularCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "桥梁定期检查ID")
    @TableField("BRIDGE_REGULAR_CHECK_ID_")
    private String bridgeRegularCheckId;

    @Excel(name = "结构名称", orderNum = "0")
    @ApiModelProperty(value = "结构名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "评分(0-5)", orderNum = "1")
    @ApiModelProperty(value = "评分(0-5)")
    @TableField("SCORE_")
    private String score;

    @Excel(name = "特别检查", orderNum = "2")
    @ApiModelProperty(value = "特别检查")
    @TableField("SPECIAL_CHECK_")
    private String specialCheck;

    @Excel(name = "维修范围", orderNum = "3")
    @ApiModelProperty(value = "维修范围")
    @TableField("MAINTENANCE_MARGIN_")
    private String maintenanceMargin;

    @Excel(name = "维修方式", orderNum = "4")
    @ApiModelProperty(value = "维修方式")
    @TableField("MAINTAIN_WAY_")
    private String maintainWay;

    @Excel(name = "维修时间", orderNum = "5", format = "yyyy-MM-dd")
    @ApiModelProperty(value = "维修时间")
    @TableField("MAINTAIN_TIME_")
    private LocalDate maintainTime;

    @Excel(name = "维修费用", orderNum = "6")
    @ApiModelProperty(value = "维修费用")
    @TableField("MAINTAIN_COST_")
    private String maintainCost;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getBridgeRegularCheckId() {
        return bridgeRegularCheckId;
    }

    public void setBridgeRegularCheckId(String bridgeRegularCheckId) {
        this.bridgeRegularCheckId = bridgeRegularCheckId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }
    public String getSpecialCheck() {
        return specialCheck;
    }

    public void setSpecialCheck(String specialCheck) {
        this.specialCheck = specialCheck;
    }
    public String getMaintenanceMargin() {
        return maintenanceMargin;
    }

    public void setMaintenanceMargin(String maintenanceMargin) {
        this.maintenanceMargin = maintenanceMargin;
    }
    public String getMaintainWay() {
        return maintainWay;
    }

    public void setMaintainWay(String maintainWay) {
        this.maintainWay = maintainWay;
    }
    public LocalDate getMaintainTime() {
        return maintainTime;
    }

    public void setMaintainTime(LocalDate maintainTime) {
        this.maintainTime = maintainTime;
    }
    public String getMaintainCost() {
        return maintainCost;
    }

    public void setMaintainCost(String maintainCost) {
        this.maintainCost = maintainCost;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "BridgeRegularCheckDetail{" +
            "id=" + id +
            ", bridgeRegularCheckId=" + bridgeRegularCheckId +
            ", unitName=" + unitName +
            ", score=" + score +
            ", specialCheck=" + specialCheck +
            ", maintenanceMargin=" + maintenanceMargin +
            ", maintainWay=" + maintainWay +
            ", maintainTime=" + maintainTime +
            ", maintainCost=" + maintainCost +
        "}";
    }
}
