/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.MinioSetting;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.MinioUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import org.springframework.stereotype.Service;

@Service
public class MinioAttachmentServiceImpl
implements AttachmentService {
    public String getStoreType() {
        return "minio";
    }

    private MinioSetting initMinioSettings(Attachment attachment, String propertiesId) {
        MinioSetting ossSettings = (MinioSetting)AppUtil.getBean(MinioSetting.class);
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FileStorageManager fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = (FileStorage)fileStorageManager.get((Serializable)((Object)propertiesId));
            if (BeanUtils.isNotEmpty((Object)((Object)fileStorage))) {
                ossSettings.setMinioName(fileStorage.getUserName());
                ossSettings.setMinioPass(fileStorage.getPassword());
                String minioUrl = fileStorage.getUrl();
                if (!minioUrl.startsWith("http")) {
                    minioUrl = "http://" + minioUrl;
                }
                if (!minioUrl.endsWith("/")) {
                    minioUrl = minioUrl.concat("/");
                }
                ossSettings.setMinioUrl(minioUrl);
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(Boolean.valueOf(fileStorage.getEncryptName() != 0));
            } else {
                FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
                FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
                if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                    ossSettings.setMinioName(uploadProperties.getUserName());
                    ossSettings.setMinioPass(uploadProperties.getPassword());
                    String minioUrl = uploadProperties.getUrl();
                    if (!minioUrl.startsWith("http")) {
                        minioUrl = "http://" + minioUrl;
                    }
                    if (!minioUrl.endsWith("/")) {
                        minioUrl = minioUrl.concat("/");
                    }
                    ossSettings.setMinioUrl(minioUrl);
                    ossSettings.setBucketName(uploadProperties.getLocation());
                    attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
                }
            }
        }
        MinioUtil.setMinioUrl(ossSettings.getMinioUrl());
        MinioUtil.setMinioName(ossSettings.getMinioName());
        MinioUtil.setMinioPass(ossSettings.getMinioPass());
        MinioUtil.setBucketName(ossSettings.getBucketName());
        return ossSettings;
    }

    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.removeObject(filePath, true);
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.uploadByInputStream(inputStream, filePath);
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String filePath = this.getFilePath(attachment);
        this.initMinioSettings(attachment, propertiesId);
        MinioUtil.downFile("", filePath, outStream, true);
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        this.initMinioSettings(attachment, propertiesId);
        return MinioUtil.checkFile("", attachment.getFileName(), true);
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        return new byte[0];
    }

    public String getFilePath(Attachment attachment) {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        String file = fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName();
        return file;
    }
}

