/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.specialproject.dao.ProjectContractPaymentDao;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.manager.ProjectContractPaymentManager;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.model.ProjectContractPayment;
import com.artfess.yhxt.specialproject.vo.ProjectContractPaymentVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProjectContractPaymentManagerImpl
extends BaseManagerImpl<ProjectContractPaymentDao, ProjectContractPayment>
implements ProjectContractPaymentManager {
    @Resource
    private BizProjectContractManager bizProjectContractManager;

    @Override
    public PageList<ProjectContractPayment> queryProjectContractPayment(QueryFilter<ProjectContractPayment> queryFilter) {
        IPage<ProjectContractPayment> result = ((ProjectContractPaymentDao)this.baseMapper).queryProjectContractPayment((IPage<ProjectContractPayment>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ProjectContractPayment>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void createProjectContractPayment(List<ProjectContractPayment> paymentList, String contractId) {
        for (ProjectContractPayment payment : paymentList) {
            payment.setIsDele("0");
            payment.setContractId(contractId);
        }
        this.saveOrUpdateBatch(paymentList);
    }

    @Override
    public void importDatePay(MultipartFile file, String contractId) {
        List mapList = ExcelUtil.ImportDate((MultipartFile)file);
        ArrayList<ProjectContractPayment> payments = new ArrayList<ProjectContractPayment>();
        for (Map map : mapList) {
            ProjectContractPayment contractPayment = new ProjectContractPayment();
            String projectCode = (String)map.get("\u9879\u76ee\u7f16\u7801");
            String subjectCode = (String)map.get("\u5b50\u9879\u76ee\u7f16\u7801");
            String unit = (String)map.get("\u5355\u4f4d");
            Double amount = Double.parseDouble((String)map.get("\u6570\u91cf"));
            Double price = Double.parseDouble((String)map.get("\u5355\u4ef7"));
            Double totalPrice = Double.parseDouble((String)map.get("\u603b\u4ef7"));
            String date = (String)map.get("\u652f\u4ed8\u65e5\u671f");
            LocalDate payDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            contractPayment.setProjectCode(projectCode);
            contractPayment.setSubjectCode(subjectCode);
            contractPayment.setUnit(unit);
            contractPayment.setAmount(amount);
            contractPayment.setPrice(price);
            contractPayment.setTotalPrice(totalPrice);
            contractPayment.setPayDate(payDate);
            contractPayment.setIsDele("0");
            payments.add(contractPayment);
        }
        this.createProjectContractPayment(payments, contractId);
    }

    @Override
    public ProjectContractPaymentVo getVo(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BizProjectContract projectContract = (BizProjectContract)this.bizProjectContractManager.get((Serializable)((Object)id));
        ProjectContractPaymentVo vo = new ProjectContractPaymentVo();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"CONTRACT_ID_", (Object)id);
            queryWrapper.eq((Object)"is_dele_", (Object)"0");
            List paymentList = ((ProjectContractPaymentDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            vo.setPaymentList(paymentList);
        }
        vo.setBizProjectContract(projectContract);
        return vo;
    }

    @Override
    public void downTemplate(HttpServletResponse response) throws IOException {
        String filePath = "template";
        File path = new File("template");
        if (!path.exists()) {
            path.mkdirs();
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("\u5408\u540c\u652f\u4ed8\u660e\u7ec6");
        XSSFRow row = sheet.createRow(0);
        block9: for (int i = 0; i < 7; ++i) {
            XSSFCell cell = row.createCell(i);
            switch (i) {
                case 0: {
                    cell.setCellValue("\u9879\u76ee\u7f16\u7801");
                    continue block9;
                }
                case 1: {
                    cell.setCellValue("\u5b50\u9879\u76ee\u7f16\u7801");
                    continue block9;
                }
                case 2: {
                    cell.setCellValue("\u5355\u4f4d");
                    continue block9;
                }
                case 3: {
                    cell.setCellValue("\u6570\u91cf");
                    continue block9;
                }
                case 4: {
                    cell.setCellValue("\u5355\u4ef7");
                    continue block9;
                }
                case 5: {
                    cell.setCellValue("\u603b\u4ef7");
                    continue block9;
                }
                case 6: {
                    cell.setCellValue("\u652f\u4ed8\u65e5\u671f");
                    continue block9;
                }
            }
        }
        FileOutputStream out = new FileOutputStream(filePath + "/\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx");
        workbook.write((OutputStream)out);
        out.close();
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)"template/\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx", (String)"\u5408\u540c\u652f\u4ed8\u660e\u7ec6\u5bfc\u5165\u6a21\u677f.xlsx");
    }

    @Override
    public void exportDatePay(String ids, HttpServletResponse response) throws Exception {
        List<String> list = Arrays.asList(ids.split(","));
        if (list.size() > 0) {
            int i;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"ID_", list);
            List paymentList = ((ProjectContractPaymentDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            String filePath = "pay/\u5408\u540c\u652f\u4ed8\u660e\u7ec6.xlsx";
            File path = new File("pay");
            if (!path.exists()) {
                path.mkdirs();
            }
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("\u5408\u540c\u652f\u4ed8\u660e\u7ec6");
            XSSFRow row = sheet.createRow(0);
            block18: for (i = 0; i < 7; ++i) {
                XSSFCell cell = row.createCell(i);
                switch (i) {
                    case 0: {
                        cell.setCellValue("\u9879\u76ee\u7f16\u7801");
                        continue block18;
                    }
                    case 1: {
                        cell.setCellValue("\u5b50\u9879\u76ee\u7f16\u7801");
                        continue block18;
                    }
                    case 2: {
                        cell.setCellValue("\u5355\u4f4d");
                        continue block18;
                    }
                    case 3: {
                        cell.setCellValue("\u6570\u91cf");
                        continue block18;
                    }
                    case 4: {
                        cell.setCellValue("\u5355\u4ef7");
                        continue block18;
                    }
                    case 5: {
                        cell.setCellValue("\u603b\u4ef7");
                        continue block18;
                    }
                    case 6: {
                        cell.setCellValue("\u652f\u4ed8\u65e5\u671f");
                        continue block18;
                    }
                }
            }
            for (i = 0; i < paymentList.size(); ++i) {
                ProjectContractPayment payment = (ProjectContractPayment)((Object)paymentList.get(i));
                XSSFRow row1 = sheet.createRow(i + 1);
                block20: for (int j = 0; j < 7; ++j) {
                    XSSFCell cell = row1.createCell(j);
                    switch (j) {
                        case 0: {
                            String projectCode = payment.getProjectCode();
                            cell.setCellValue(projectCode);
                            continue block20;
                        }
                        case 1: {
                            String subjectCode = payment.getSubjectCode();
                            cell.setCellValue(subjectCode);
                            continue block20;
                        }
                        case 2: {
                            String unit = payment.getUnit();
                            cell.setCellValue(unit);
                            continue block20;
                        }
                        case 3: {
                            String value = payment.getAmount().toString();
                            cell.setCellValue(value);
                            continue block20;
                        }
                        case 4: {
                            String value1 = payment.getPrice().toString();
                            cell.setCellValue(value1);
                            continue block20;
                        }
                        case 5: {
                            String value2 = payment.getTotalPrice().toString();
                            cell.setCellValue(value2);
                            continue block20;
                        }
                        case 6: {
                            cell.setCellValue(payment.getPayDate().toString());
                            continue block20;
                        }
                    }
                }
            }
            FileOutputStream out = new FileOutputStream(filePath);
            workbook.write((OutputStream)out);
            out.close();
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)filePath, (String)filePath.substring(filePath.lastIndexOf("/") + 1));
            FileUtil.deleteFile((String)filePath);
            System.out.println("OK!");
        }
    }
}

