/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.FileUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.springframework.web.multipart.MultipartFile;

public class ZipUtil {
    public static void zip(String path) {
        ZipUtil.zip(path, true);
    }

    public static void main(String[] args) {
        String path = "D:/test";
        ZipUtil.zip(path, false);
        System.out.println("main");
    }

    public static void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir(file);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void zipSetPass(String path, Boolean isDelete, String password) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(password);
            File file = new File(path);
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir(new File(path));
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void unZipFile(MultipartFile multipartFile, String toPath) throws Exception {
        String originalFilename = multipartFile.getOriginalFilename();
        String destPath = toPath + originalFilename;
        ZipUtil.createFilePath(destPath, originalFilename);
        File file = new File(destPath);
        if (file.exists()) {
            file.delete();
        }
        multipartFile.transferTo(file);
        ZipFile zipFile = new ZipFile(file);
        zipFile.setFileNameCharset("GBK");
        if (zipFile.isEncrypted()) {
            zipFile.setPassword("");
        }
        if (!zipFile.isValidZipFile()) {
            throw new ZipException("\u538b\u7f29\u6587\u4ef6\u4e0d\u5408\u6cd5,\u53ef\u80fd\u88ab\u635f\u574f.");
        }
        zipFile.extractAll(toPath);
        ZipUtil.dealDisFileName(file, toPath, originalFilename);
        FileUtil.deleteDir(file);
    }

    private static void dealDisFileName(File file, String toPath, String fileName) {
        try {
            String resultPath = toPath + File.separator + fileName.substring(0, fileName.lastIndexOf("."));
            File resultFile = new File(resultPath);
            if (!resultFile.exists()) {
                ZipFile newZipFile = new ZipFile(file);
                newZipFile.extractAll(resultPath);
                ArrayList<File> dirs = FileUtil.getDiretoryOnly(resultFile);
                if (dirs != null && dirs.size() == 1) {
                    File fi = (File)dirs.get(0);
                    String fromDir = resultPath + File.separator + fi.getName();
                    FileUtil.copyDir(fromDir, resultPath);
                    FileUtil.deleteDir(fi);
                    String oldFilePath = toPath + File.separator + fi.getName();
                    File oldFile = new File(oldFilePath);
                    if (oldFile.exists()) {
                        FileUtil.deleteDir(oldFile);
                    }
                } else {
                    FileUtil.deleteDir(resultFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unZip(String filePath, String toPath, String password) {
        try {
            ZipUtil.unZipFile(new ZipFile(filePath), toPath, password);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void unZipFile(ZipFile zipFile, String toPath, String password) {
        try {
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password);
            }
            List fileHeaderList = zipFile.getFileHeaders();
            for (Object o : fileHeaderList) {
                FileHeader fileHeader = (FileHeader)o;
                zipFile.extractFile(fileHeader, toPath);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public static void unZipFile(String filePath, String toPath) {
        ZipUtil.unZip(filePath, toPath, "");
    }

    public static String createFilePath(String tempPath, String fileName) {
        File file = new File(tempPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getPath() + File.separator + fileName;
    }
}

