package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.dao.SysLoginLogsDao;
import com.artfess.sysConfig.persistence.manager.SysLoginLogsManager;
import com.artfess.sysConfig.persistence.model.SysLoginLogs;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：系统登录日志 处理实现类
 * 构建组：artfess
 * 作者:baseli
 * 日期:2021年6月17日09:53:20
 * </pre>
 */
@Service("sysLoginLogsManager")
public class SysLoginLogsManagerImpl extends BaseManagerImpl<SysLoginLogsDao, SysLoginLogs> implements SysLoginLogsManager{
	
	@Override
	public void removeByEexcutionTime(List<Map<String, Object>> params) {
		baseMapper.removeByEexcutionTime(params);
	}
	
	@Override
	public void create(SysLoginLogs log) {
		if(StringUtil.isNotEmpty(log.getOpeName()) && log.getOpeName().length()>480){
			log.setOpeName(log.getOpeName().substring(0, 480));
		}
		this.save(log);
	}
}
