package com.artfess.report.bigScreen.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualCategory;

import java.util.List;

/**
 * 可视化分类表 服务类
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
public interface BladeVisualCategoryManager extends BaseManager<BladeVisualCategory> {

    PageList<BladeVisualCategory> queryBladeVisualCategory(QueryFilter<BladeVisualCategory> queryFilter);

    void updateBatchBladeVisualCategory(String id);

    /**
     * 检查是否已经存在该分类
     * @param bladeVisualCategory
     */
    void checkByCategoryValue(BladeVisualCategory bladeVisualCategory);

    List<BladeVisual> getVisual(String categoryValue);
}
