/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.model.HtObjectNode;
import com.artfess.base.query.Direction;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.ProcessInstCmd;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.exception.BusinessException;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.constants.ProcDefTestStatus;
import com.artfess.bpm.persistence.dao.ActTaskDao;
import com.artfess.bpm.persistence.dao.BpmCheckOpinionDao;
import com.artfess.bpm.persistence.dao.BpmExeStackDao;
import com.artfess.bpm.persistence.dao.BpmProcessInstanceDao;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmExeStackRelationManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskReadManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.manager.CopyToManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.AuthorizeRight;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.BpmExeStackRelation;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProStatus;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.bpm.persistence.util.BpmStackRelationUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmProcessInstanceManager")
public class BpmProcessInstanceManagerImpl
extends BaseManagerImpl<BpmProcessInstanceDao, DefaultBpmProcessInstance>
implements BpmProcessInstanceManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmProcessInstanceManagerImpl.class);
    @Resource
    BpmExeStackDao bpmExeStackDao;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    CopyToManager copyToManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmTaskReadManager bpmTaskReadManager;
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    ActTaskDao actTaskDao;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    ActTaskManager actTaskManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    IUserService userService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmExeStackRelationManager bpmExeStackRelationManager;

    @Override
    public String getSubject(BpmProcessDef<BpmProcessDefExt> bpmDefinition, ProcessInstCmd processInstCmd, DefaultBpmProcessInstance defaultBpmProcessInstance) throws Exception {
        if (StringUtils.isNotEmpty((String)processInstCmd.getSubject())) {
            return processInstCmd.getSubject();
        }
        if (!defaultBpmProcessInstance.isUpdateSubjectWhenExist() && StringUtil.isNotEmpty((String)defaultBpmProcessInstance.getSubject())) {
            return defaultBpmProcessInstance.getSubject();
        }
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmDefinition.getProcessDefExt();
        String rule = defExt.getExtProperties().getSubjectRule();
        rule = rule.replace("<p>", "");
        rule = rule.replace("</p>", "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", bpmDefinition.getName());
        map.put("startDate", DateUtil.getCurrentTime((String)"yyyy-MM-dd"));
        map.put("startTime", DateUtil.getCurrentTime());
        map.put("businessKey", processInstCmd.getBusinessKey());
        map.put("flowKey_", processInstCmd.getFlowKey());
        map.put("instanceId_", processInstCmd.getInstId());
        String startUserName = ContextUtil.getCurrentUser().getFullname();
        if (BeanUtils.isNotEmpty((Object)processInstCmd.getTransitVars("startUser"))) {
            startUserName = ((IUser)processInstCmd.getTransitVars("startUser")).getFullname();
        }
        if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance.getCreator())) {
            startUserName = defaultBpmProcessInstance.getCreator();
        }
        map.put("startUser", startUserName);
        map.put("startorName", startUserName);
        map.putAll(((DefaultProcessInstCmd)processInstCmd).getVariables());
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (StringUtil.isNotEmpty((String)processInstCmd.getInstId()) && BeanUtils.isEmpty(boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(processInstCmd.getInstId());
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext(boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap) && !ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(defaultBpmProcessInstance.getStatus()) || "true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            for (Map.Entry<String, ObjectNode> ent : boMap.entrySet()) {
                ObjectNode boData = ent.getValue();
                ObjectNode bodef = (ObjectNode)boData.get("boDef");
                String boName = "";
                boName = BeanUtils.isNotEmpty((Object)boData.get("boDefAlias")) ? boData.get("boDefAlias").asText() : (BeanUtils.isNotEmpty((Object)bodef) ? bodef.get("alias").asText() : ent.getKey());
                if (StringUtil.isEmpty((String)boName)) continue;
                Map dataMap = new HashMap();
                try {
                    dataMap = JsonUtil.toMap((String)JsonUtil.toJson((Object)boData));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (Map.Entry entry : dataMap.entrySet()) {
                    map.put(boName + "." + (String)entry.getKey(), entry.getValue());
                }
                try {
                    if (boData.hasNonNull("data") && boData.get("data").isObject()) {
                        boData = (ObjectNode)boData.get("data");
                    }
                    HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(boData);
                    map.put(ent.getKey(), htObjectNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u5904\u7406\u6d41\u7a0b\u6807\u9898bo\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        } else if (BeanUtils.isNotEmpty((Object)processInstCmd.getBusData())) {
            try {
                JsonNode dataNode = JsonUtil.toJsonNode((String)processInstCmd.getBusData());
                Iterator it = dataNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    Iterator subIt = ((JsonNode)entry.getValue()).fields();
                    while (subIt.hasNext()) {
                        Map.Entry subEntry = (Map.Entry)subIt.next();
                        if (((String)subEntry.getKey()).contains("sub_") || !BeanUtils.isNotEmpty(subEntry.getValue())) continue;
                        map.put((String)entry.getKey() + "." + (String)subEntry.getKey(), ((JsonNode)subEntry.getValue()).asText());
                    }
                    try {
                        HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode((ObjectNode)JsonUtil.toJsonNode(entry.getValue()));
                        map.put((String)entry.getKey(), htObjectNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("\u5904\u7406\u6d41\u7a0b\u6807\u9898bo\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("\u89e3\u6790\u6d41\u7a0b\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        rule = StringUtil.getStrByRule((String)rule, map);
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(bpmDefinition.getProcessDefinitionId());
        if (ProcDefTestStatus.TEST.getKey().equalsIgnoreCase(bpmDef.getStatus())) {
            rule = ProcDefTestStatus.TEST.getName() + " -- " + rule;
        }
        return rule;
    }

    @Override
    @Transactional
    public void physicsRemove(String processInstId) {
        DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.get((Serializable)((Object)processInstId));
        if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(inst.getStatus())) {
            super.remove((Serializable)((Object)processInstId));
        } else {
            BpmProcessInstance topInstance = this.getTopBpmProcessInstance(processInstId);
            String topInstId = topInstance.getId();
            List<DefaultBpmProcessInstance> instList = this.getByParentId(topInstId, true);
            String topBpmnInstId = topInstance.getBpmnInstId();
            List<String> instIdList = this.getInstList(instList);
            List<String> bpmnInstList = ((BpmProcessInstanceDao)this.baseMapper).getBpmnByInstList(instIdList);
            this.removeCascade(instIdList);
            this.actExecutionManager.delByInstList(bpmnInstList);
            this.actExecutionManager.remove((Serializable)((Object)topBpmnInstId));
        }
    }

    @Transactional
    public void remove(String processInstId, Boolean isBpm) {
        DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)this.get((Serializable)((Object)processInstId));
        if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(inst.getStatus())) {
            super.remove((Serializable)((Object)processInstId));
        } else if (!isBpm.booleanValue()) {
            ((BpmProcessInstanceDao)this.baseMapper).isDeleInst(processInstId, 1);
            ((BpmProcessInstanceDao)this.baseMapper).isDeleOpinion(processInstId, 1);
            ((BpmProcessInstanceDao)this.baseMapper).isDeleNotice(processInstId, 1);
            ((BpmProcessInstanceDao)this.baseMapper).isDeleTask(processInstId, 1);
        } else {
            BpmProcessInstance topInstance = this.getTopBpmProcessInstance(processInstId);
            String topInstId = topInstance.getId();
            List<DefaultBpmProcessInstance> instList = this.getByParentId(topInstId, true);
            String topBpmnInstId = topInstance.getBpmnInstId();
            List<String> instIdList = this.getInstList(instList);
            List<String> bpmnInstList = ((BpmProcessInstanceDao)this.baseMapper).getBpmnByInstList(instIdList);
            this.removeCascade(instIdList);
            this.actExecutionManager.delByInstList(bpmnInstList);
            this.actExecutionManager.remove((Serializable)((Object)topBpmnInstId));
        }
    }

    @Transactional
    public void remove(String instId) {
        this.remove(instId, false);
    }

    private List<String> getInstList(List<DefaultBpmProcessInstance> instList) {
        ArrayList<String> list = new ArrayList<String>();
        for (DefaultBpmProcessInstance instance : instList) {
            list.add(instance.getId());
        }
        return list;
    }

    @Transactional
    private void removeCascade(List<String> instList) {
        this.bpmCheckOpinionManager.delByInstList(instList);
        this.bpmTaskCandidateManager.delByInstList(instList);
        this.bpmTaskManager.delByInstList(instList);
        this.bpmProStatusManager.delByInstList(instList);
        this.copyToManager.delByInstList(instList);
        this.bpmTaskTurnManager.delByInstList(instList);
        this.bpmSignDataManager.delByInstList(instList);
        this.bpmTaskReadManager.delByInstList(instList);
        for (String id : instList) {
            super.remove((Serializable)((Object)id));
        }
    }

    @Transactional
    public void update(DefaultBpmProcessInstance entity) {
        entity.setUpdateBy(ContextUtil.getCurrentUserId());
        entity.setUpdateTime(LocalDateTime.now());
        super.update((Model)entity);
    }

    @Override
    public DefaultBpmProcessInstance getByBpmnInstId(String bpmnInstId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getBpmnInstId(bpmnInstId);
    }

    @Override
    public DefaultBpmProcessInstance getBpmProcessInstanceHistory(String procInstId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getBpmProcessInstanceHistory(procInstId);
    }

    @Override
    public DefaultBpmProcessInstance getBpmProcessInstanceHistoryByBpmnInstId(String bpmnInstId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getBpmProcessInstanceHistoryByBpmnInstId(bpmnInstId);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserId(String userId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserId((IPage<DefaultBpmProcessInstance>)page, params);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserId(String userId, PageBean pageBean) {
        QueryFilter queryFilter = QueryFilter.build().withParam("userId", (Object)userId);
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserId((IPage<DefaultBpmProcessInstance>)page, queryFilter.getParams());
    }

    @Override
    @Transactional
    public void updateStatusByBpmnInstanceId(String processInstanceId, String status) {
        ((BpmProcessInstanceDao)this.baseMapper).updateStatusByBpmnInstanceId(processInstanceId, status);
    }

    @Override
    @Transactional
    public void updateStatusByInstanceId(String processInstanceId, String status) {
        ((BpmProcessInstanceDao)this.baseMapper).updateStatusByInstanceId(processInstanceId, status);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserIdGroupList(String userId, List<IGroup> groupList) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserIdGroupList(this.getIPage(null), userId, groupList);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserIdGroupList(String userId, List<IGroup> groupList, PageBean pageBean) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserIdGroupList((IPage<DefaultBpmProcessInstance>)this.convert2IPage(pageBean), userId, groupList);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByAttendUserId(String userId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByAttendUserId(this.getIPage(null), userId);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getByAttendUserId(String userId, PageBean pageBean) {
        return (PageList)((BpmProcessInstanceDao)this.baseMapper).getByAttendUserId(this.getIPage(null), userId);
    }

    @Override
    public List<DefaultBpmProcessInstance> getListByBpmnDefKey(String bpmDefKey) {
        List<DefaultBpmProcessInstance> list = ((BpmProcessInstanceDao)this.baseMapper).getListByBpmnDefKey(bpmDefKey);
        return list;
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByAttendUserId(String userId, QueryFilter queryFilter) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByAttendUserId(this.getIPage(queryFilter), userId);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserIdGroupList(String userId, List<IGroup> groupList, QueryFilter queryFilter) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserIdGroupList(this.getIPage(queryFilter), userId, groupList);
    }

    private IPage<DefaultBpmProcessInstance> getIPage(QueryFilter queryFilter) {
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            return page;
        }
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        return page;
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getByUserId(String userId, QueryFilter queryFiler) {
        queryFiler.addParams("userId", (Object)userId);
        return ((BpmProcessInstanceDao)this.baseMapper).getByUserId(this.getIPage(queryFiler), queryFiler.getParams());
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getMyRequestByUserId(String userId, QueryFilter queryFilter) {
        queryFilter.addFilter("create_by_", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)1, QueryOP.NOT_EQUAL);
        Wrapper wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        return ((BpmProcessInstanceDao)this.baseMapper).getMyRequestByUserId((IPage<DefaultBpmProcessInstance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DefaultBpmProcessInstance>)wrapper);
    }

    @Override
    public List<Map<String, Object>> getMyRequestCount(String userId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", userId);
        return ((BpmProcessInstanceDao)this.baseMapper).getMyRequestCount(param);
    }

    @Override
    public Long getMyRequestCountByUserId(String userId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getMyRequestCountByUserId(userId);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getMyCompletedByUserId(String userId, QueryFilter queryFilter) {
        queryFilter.withParam("userId", (Object)userId);
        return ((BpmProcessInstanceDao)this.baseMapper).getMyCompletedByUserId(this.getIPage(queryFilter), queryFilter.getParams());
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getDraftsByUserId(String userId, QueryFilter queryFilter) {
        queryFilter.withParam("userId", (Object)userId);
        Wrapper wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        return ((BpmProcessInstanceDao)this.baseMapper).selectPage(this.convert2IPage(queryFilter.getPageBean()), wrapper);
    }

    @Override
    public IPage<Map<String, Object>> getHandledByUserId(String userId, QueryFilter queryFilter) throws Exception {
        queryFilter.withParam("userId", (Object)userId);
        IPage<Map<String, Object>> map = ((BpmProcessInstanceDao)this.baseMapper).getHandledByUserId((IPage<DefaultBpmProcessInstance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return map;
    }

    @Override
    public PageList<Map<String, Object>> getDoneInstList(String userId, QueryFilter queryFilter) {
        queryFilter.withParam("userId", (Object)userId);
        queryFilter.setSorter(new ArrayList());
        Wrapper convert2Wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setShowTotal(false);
        IPage<Map<String, Object>> doneInstList = ((BpmProcessInstanceDao)this.baseMapper).getDoneInstList((IPage<DefaultBpmProcessInstance>)this.convert2IPage(pageBean), (Wrapper<DefaultBpmProcessInstance>)convert2Wrapper);
        Long total = null;
        total = ((BpmProcessInstanceDao)this.baseMapper).getDoneInstListCount((Wrapper<DefaultBpmProcessInstance>)convert2Wrapper);
        doneInstList.setTotal(total.longValue());
        return new PageList(doneInstList);
    }

    @Override
    public List<Map<String, Object>> getDoneInstCount(String userId, QueryFilter queryFilter) {
        queryFilter.withParam("userId", (Object)userId);
        return ((BpmProcessInstanceDao)this.baseMapper).getDoneInstCount((Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public Long getDoneInstCount(String userId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getDoneInstCountByUserId(userId);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getCompletedByUserId(String userId, QueryFilter queryFilter) {
        queryFilter.addFilter("opinion.auditor_", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("wfInst.status_", (Object)"end,manualend", QueryOP.IN);
        queryFilter.setDefaultSort("wfInst.create_time_", Direction.DESC);
        return ((BpmProcessInstanceDao)this.baseMapper).getCompletedByUserId(this.getIPage(queryFilter), (Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void updForbiddenByDefKey(String defKey, Integer isForbidden) {
        ((BpmProcessInstanceDao)this.baseMapper).updForbiddenByDefKey(defKey, isForbidden);
    }

    @Override
    @Transactional
    public void updForbiddenByInstId(String instId, Integer isForbidden) {
        ((BpmProcessInstanceDao)this.baseMapper).updForbiddenByInstId(instId, isForbidden);
    }

    @Override
    @Transactional
    public void removeBpm(String instId) {
        this.remove(instId, false);
    }

    @Override
    @Transactional
    public void removeTestInstByDefKey(String defKey, Boolean isBpm) {
        List<DefaultBpmProcessInstance> list = ((BpmProcessInstanceDao)this.baseMapper).getByDefKeyFormal(defKey, "N");
        for (DefaultBpmProcessInstance instance : list) {
            this.remove(instance.getId(), isBpm);
        }
    }

    @Override
    public List<DefaultBpmProcessInstance> getByParentId(String parentId, boolean includeSelf) {
        List<DefaultBpmProcessInstance> instances;
        ArrayList<DefaultBpmProcessInstance> list = new ArrayList<DefaultBpmProcessInstance>();
        if (includeSelf) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)super.get((Serializable)((Object)parentId));
            list.add(instance);
            List<DefaultBpmProcessInstance> list2 = ((BpmProcessInstanceDao)this.baseMapper).getByParentId(parentId);
        }
        if (BeanUtils.isEmpty(instances = ((BpmProcessInstanceDao)this.baseMapper).getByParentId(parentId))) {
            return list;
        }
        for (DefaultBpmProcessInstance instance : instances) {
            this.recursionByParent(instance, list);
        }
        return list;
    }

    @Transactional
    private void recursionByParent(DefaultBpmProcessInstance parentInst, List<DefaultBpmProcessInstance> list) {
        list.add(parentInst);
        List<DefaultBpmProcessInstance> instances = ((BpmProcessInstanceDao)this.baseMapper).getByParentId(parentInst.getId());
        if (BeanUtils.isEmpty(instances)) {
            return;
        }
        for (DefaultBpmProcessInstance instance : instances) {
            this.recursionByParent(instance, list);
        }
    }

    @Override
    @Transactional
    public ResultMessage revokeInstance(String instanceId, String informType, String cause) throws Exception {
        ResultMessage resultMessage = this.canRevokeToStart(instanceId);
        if (-1 == resultMessage.getResult()) {
            return resultMessage;
        }
        BpmNodeDef bpmNodeDef = (BpmNodeDef)resultMessage.getVars().get("bpmNodeDef");
        List<DefaultBpmProcessInstance> instList = this.getByParentId(instanceId, true);
        DefaultBpmProcessInstance mainInstance = this.getMainInstance(instList, instanceId);
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (actionCmd == null) {
            DefaultProcessInstCmd actionCmd2 = new DefaultProcessInstCmd();
            actionCmd2.setInstId(instanceId);
            actionCmd2.addTransitVars("IsUnused", true);
            ContextThreadUtil.setActionCmd(actionCmd2);
        } else {
            actionCmd.addTransitVars("IsUnused", true);
        }
        List<String> includeIdList = this.getIdList(instList, instanceId, true, false);
        List<String> includeBpmnIdList = this.getIdList(instList, instanceId, true, true);
        List<String> notIncludeBpmnIdList = this.getIdList(instList, instanceId, false, true);
        Object users = this.getNotifyUsers((List)includeIdList);
        this.bpmTaskCandidateManager.delByInstList(includeIdList);
        this.bpmTaskManager.delByInstList(includeIdList);
        this.bpmTaskTurnManager.delByInstList(includeIdList);
        this.bpmSignDataManager.delByInstList(includeIdList);
        this.bpmTaskReadManager.delByInstList(includeIdList);
        if (BeanUtils.isNotEmpty(notIncludeBpmnIdList)) {
            this.actExecutionManager.delByInstList(notIncludeBpmnIdList);
        } else {
            this.actExecutionManager.delActiveByInstList(includeBpmnIdList);
        }
        this.actTaskDao.delSpecVarsByInstList(includeBpmnIdList);
        this.actTaskDao.delCandidateByInstList(includeBpmnIdList);
        this.actTaskDao.delByInstList(includeBpmnIdList);
        ActExecution actExecution = (ActExecution)this.actExecutionManager.get((Serializable)((Object)mainInstance.getBpmnInstId()));
        ActTask actTask = this.actTaskManager.createTask(actExecution, mainInstance, bpmNodeDef);
        mainInstance.setStatus(ProcessInstanceStatus.STATUS_REVOKE_TOSTART.getKey());
        super.update((Model)mainInstance);
        this.updActExecution(actExecution, bpmNodeDef.getNodeId());
        this.updProStatus(instanceId, bpmNodeDef.getNodeId(), includeIdList);
        this.updOpinion(includeIdList, actTask, mainInstance, cause);
        this.bpmExeStackManager.popStartStack(mainInstance.getId(), "", "normal");
        this.bpmExeStackDao.removeBpmExeStackRelationInToStackId(instanceId, "%");
        this.bpmExeStackDao.removeBpmExeStackRelationInFromStackId(instanceId, "%");
        String targetNodePath = this.bpmExeStackManager.getInitStack(instanceId).getNodePath();
        this.bpmExeStackDao.removeExeStackExceptParentId(instanceId, "0");
        if (StringUtil.isNotEmpty((String)instanceId)) {
            String id = "";
            List<BpmTaskNotice> list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByInstId(instanceId);
            for (int i = 0; i < list1.size(); ++i) {
                id = list1.get(i).getId();
                BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                    this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                }
                bpmTaskNotice.setIsRevoke(1);
                noticeManager.update((Model)bpmTaskNotice);
            }
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(instanceId);
        List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
        BpmContextUtil.setBoToContext(boDatas);
        ScriptType scriptType = ScriptType.fromKey("create");
        String script = bpmNodeDef.getScripts().get((Object)scriptType);
        if (StringUtil.isEmpty((String)script)) {
            return resultMessage;
        }
        HashMap vars = new HashMap();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode(next.getValue()));
            }
            vars.putAll(newMap);
            cmd.setBusData(JsonUtil.toJson(boDatas));
        }
        vars.put("nodeDef", bpmNodeDef);
        vars.put("cmd", cmd);
        try {
            this.groovyScriptEngine.execute(script, vars);
        }
        catch (BusinessException e) {
            throw new WorkFlowException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("\u6d41\u7a0b\u811a\u672c\u5f02\u5e38\uff1a", (Throwable)e);
            StringBuffer sb = new StringBuffer();
            sb.append("<br/><br/>\u6d41\u7a0b\u5728\u8282\u70b9\uff1a" + bpmNodeDef.getName() + "(" + bpmNodeDef.getNodeId() + ")\u6267\u884c\u524d\u7f6e\u4e8b\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01");
            sb.append("<br/>\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            sb.append("<br/>\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
            sb.append("<br/>\u6267\u884c\u811a\u672c\u4e3a\uff1a" + script);
            sb.append("\u811a\u672c\u53d8\u91cf\uff1a" + ((Object)vars).toString());
            String errorMsg = "\u6d41\u7a0b\u5728\u8282\u70b9\u3010" + bpmNodeDef.getName() + "(" + bpmNodeDef.getNodeId() + ")\u3011\u6267\u884c" + scriptType.getValue() + "\u65f6\u51fa\u73b0\u5f02\u5e38\u60c5\u51b5\uff01\u53ef\u80fd\u539f\u56e0\u4e3a\uff1a" + e.getMessage();
            ThreadMsgUtil.addMapMsg((String)"msg_flow_error", (String)errorMsg);
            throw new WorkFlowException(sb.toString(), (Throwable)new RuntimeException(errorMsg));
        }
        return resultMessage;
    }

    @Override
    @Transactional
    public ResultMessage revokeTask(String instId, String informType, String cause) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmExeStackExecutorManager bpmExeStackExecutorManager = (BpmExeStackExecutorManager)AppUtil.getBean(BpmExeStackExecutorManager.class);
        BpmCheckOpinionDao opinionDao = (BpmCheckOpinionDao)AppUtil.getBean(BpmCheckOpinionDao.class);
        List<DefaultBpmTask> list = this.bpmTaskManager.getByInstId(instId);
        DefaultBpmTask runningTask = list.get(0);
        String prcoDefId = runningTask.getProcDefId();
        String nodeId = runningTask.getNodeId();
        String taskId = runningTask.getTaskId();
        List<BpmNodeDef> nodeDefs = bpmDefinitionAccessor.getStartNodes(prcoDefId);
        BpmNodeDef node = bpmDefinitionAccessor.getBpmNodeDef(prcoDefId, nodeId);
        NodeType type = node.getType();
        BpmProcessInstance instance = (BpmProcessInstance)super.get((Serializable)((Object)instId));
        String status = instance.getStatus();
        if (ProcessInstanceStatus.STATUS_REVOKE_TOSTART.getKey().equals(status) || ProcessInstanceStatus.STATUS_BACK_TOSTART.getKey().equals(status)) {
            ResultMessage message = new ResultMessage(0, "\u6d41\u7a0b\u5df2\u5904\u4e8e\u7b2c\u4e00\u4e2a\u8282\u70b9!");
            return message;
        }
        boolean rtn = this.validTask(instance.getBpmnInstId(), nodeDefs.get(0));
        if (!rtn) {
            ResultMessage message = new ResultMessage(0, "\u4efb\u52a1\u5df2\u5728\u53d1\u8d77\u8282\u70b9,\u4e0d\u80fd\u518d\u64a4\u9500!");
            return message;
        }
        if (!type.getKey().equals(NodeType.USERTASK.getKey())) {
            ResultMessage message = new ResultMessage(0, "\u64a4\u56de\u5931\u8d25\uff0c\u975e\u7528\u6237\u4efb\u52a1\u8282\u70b9\u4e0d\u5141\u8bb8\u64a4\u56de");
            return message;
        }
        List<BpmNodeDef> inList = node.getIncomeNodes();
        BpmExeStackExecutor stackExecutor = bpmExeStackExecutorManager.getByTaskId(taskId);
        BpmExeStackRelation relation = this.bpmExeStackRelationManager.getByToStackId(stackExecutor.getStackId());
        if (!relation.getFromNodeType().equals("userTask") && !NodeType.EXCLUSIVEGATEWAY.getKey().equals(relation.getFromNodeType())) {
            ResultMessage message = new ResultMessage(0, "\u64a4\u56de\u5931\u8d25\uff0c\u6709\u7f51\u5173\u8282\u70b9\u4e0d\u5141\u8bb8\u64a4\u56de");
            return message;
        }
        while (NodeType.EXCLUSIVEGATEWAY.getKey().equals(relation.getFromNodeType())) {
            relation = this.bpmExeStackRelationManager.getByToStackId(relation.getFromStackId());
        }
        List<DefaultBpmCheckOpinion> listOpinions = opinionDao.getByInstNodeIdAgree(instId, relation.getFromNodeId());
        while (BeanUtils.isEmpty(listOpinions) && BeanUtils.isNotEmpty((Object)((Object)relation))) {
            if (!BeanUtils.isNotEmpty((Object)((Object)(relation = this.bpmExeStackRelationManager.getByFromStackId(relation.getFromStackId()))))) continue;
            listOpinions = opinionDao.getByInstNodeIdAgree(instId, relation.getFromNodeId());
        }
        boolean isCanRecall = false;
        for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : listOpinions) {
            if (!defaultBpmCheckOpinion.getAuditor().equals(ContextUtil.getCurrentUser().getUserId())) continue;
            isCanRecall = true;
            break;
        }
        if (isCanRecall) {
            BpmIdentity bpmIdentity = DefaultBpmIdentity.getIdentityByUserId(ContextUtil.getCurrentUser().getUserId(), ContextUtil.getCurrentUser().getFullname());
            DefaultTaskFinishCmd cmd = this.getCmdFromRecall(taskId, "reject", "\u64a4\u56de " + cause, "normal", relation.getFromNodeId(), bpmIdentity);
            List<BpmNodeDef> listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef(instId, nodeId, "pre");
            ArrayList bpmExeStacksGoMapUserNode = new ArrayList();
            boolean isCanReject = false;
            List<BpmExeStackRelation> relationList = this.bpmExeStackRelationManager.getListByProcInstId(instId);
            for (BpmNodeDef itemNode : listBpmNodeDef) {
                if (!itemNode.getType().equals((Object)NodeType.USERTASK)) continue;
                boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway(instId, node.getNodeId(), "pre", relationList);
                boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway(instId, node.getNodeId(), "after", relationList);
                isCanReject = (!isHavePre || !isHaveAfter) && relation.getFromNodeId().equals(itemNode.getNodeId());
                if (!isCanReject) continue;
                break;
            }
            if (!isCanReject) {
                ResultMessage message = new ResultMessage(0, "\u64a4\u56de\u5931\u8d25\uff0c\u5f53\u524d\u8282\u70b9\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u64a4\u56de");
                return message;
            }
            boolean result = this.bpmTaskActionService.finishTask(cmd);
            DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)super.get((Serializable)((Object)instId));
            ArrayList<IUser> listUsers = new ArrayList<IUser>();
            IUser user = this.userService.getUserById(runningTask.getOwnerId());
            listUsers.add(user);
            BpmProcessInstanceManagerImpl.notifyUsers(listUsers, instance, informType, cause);
            processInstance.setStatus(ProcessInstanceStatus.STATUS_REVOKE.getKey());
            super.update((Model)processInstance);
            if (StringUtil.isNotEmpty((String)instId)) {
                String id = "";
                List<BpmTaskNotice> list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByTaskId(taskId);
                for (int i = 0; i < list1.size(); ++i) {
                    id = list1.get(i).getId();
                    BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                    BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                    DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                    if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                    if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                        this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                    }
                    bpmTaskNotice.setIsRevoke(1);
                    noticeManager.update((Model)bpmTaskNotice);
                }
            }
            ResultMessage message = new ResultMessage(1, "\u64a4\u56de\u6210\u529f");
            return message;
        }
        ResultMessage message = new ResultMessage(0, "\u64a4\u56de\u5931\u8d25\uff0c\u4e0b\u4e2a\u8282\u70b9\u4efb\u52a1\u5df2\u88ab\u5904\u7406\uff0c\u4e0d\u53ef\u64a4\u56de\uff01");
        return message;
    }

    private DefaultTaskFinishCmd getCmdFromRecall(String taskId, String actionName, String opinion, String backHandMode, String toNodeId, BpmIdentity bpmIdentity) {
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.setDestination(toNodeId);
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.addTransitVars("IsDoneUnused", true);
        cmd.setApprovalOpinion(opinion);
        cmd.setDataMode("bo");
        cmd.addTransitVars("backHandMode", backHandMode);
        ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
        list.add(bpmIdentity);
        HashMap<String, List<BpmIdentity>> nodeIdentityMap = new HashMap<String, List<BpmIdentity>>();
        nodeIdentityMap.put(toNodeId, list);
        cmd.setBpmIdentities(nodeIdentityMap);
        return cmd;
    }

    @Transactional
    private void updActExecution(ActExecution actExecution, String currentNode) {
        actExecution.setActId(currentNode);
        actExecution.setActive(true);
        this.actExecutionManager.update((Model)actExecution);
    }

    @Transactional
    private void updOpinion(List<String> includeIdList, ActTask actTask, BpmProcessInstance mainInstance, String cause) {
        List<DefaultBpmCheckOpinion> opinionList = this.bpmCheckOpinionManager.getByInstIdsAndWait(includeIdList);
        long completeTime = System.currentTimeMillis();
        IUser user = ContextUtil.getCurrentUser();
        for (DefaultBpmCheckOpinion opinion : opinionList) {
            opinion.setStatus(OpinionStatus.REVOKER_TO_START.getKey());
            long startTime = TimeUtil.getTimeMillis((LocalDateTime)opinion.getCreateTime());
            long durms = completeTime - startTime;
            opinion.setDurMs(durms);
            opinion.setAuditor(user.getUserId());
            opinion.setAuditorName(user.getFullname());
            opinion.setOpinion(cause);
            opinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)opinion);
        }
        DefaultBpmCheckOpinion checkOpinion = BpmCheckOpinionUtil.buildBpmCheckOpinion(actTask, mainInstance.getParentInstId(), mainInstance.getId());
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    @Transactional
    private void updProStatus(String instanceId, String nodeId, List<String> includeIdList) {
        this.bpmProStatusManager.updStatusByInstList(includeIdList, NodeStatus.RECOVER_TO_START);
        DefaultBpmProStatus proStatus = this.bpmProStatusManager.getByInstNodeId(instanceId, nodeId);
        proStatus.setStatus(NodeStatus.PENDING.getKey());
        this.bpmProStatusManager.update((Model)proStatus);
    }

    @Transactional
    public static void notifyUsers(List<IUser> recievers, BpmProcessInstance instance, String informType, String cause) {
        if (BeanUtils.isEmpty(recievers)) {
            return;
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("taskSubject", instance.getSubject());
        vars.put("cause", cause);
        try {
            MessageUtil.sendMsg("bpmnRecover", informType, recievers, vars);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
    }

    @Override
    public List<IUser> getNotifyUsers(List<String> includeIdList) {
        HashSet<IUser> userSet = new HashSet<IUser>();
        List<DefaultBpmTask> bpmTasks = this.bpmTaskManager.getByInstList(includeIdList);
        for (DefaultBpmTask defaultBpmTask : bpmTasks) {
            String assigneeId = defaultBpmTask.getAssigneeId();
            if (!StringUtil.isNotZeroEmpty((String)assigneeId)) continue;
            userSet.add(this.userServiceImpl.getUserById(assigneeId));
        }
        List<DefaultBpmTaskCandidate> candidates = this.bpmTaskCandidateManager.getByInstList(includeIdList);
        for (DefaultBpmTaskCandidate candidate : candidates) {
            String executorId = candidate.getExecutor();
            if ("user".equals(candidate.getType())) {
                userSet.add(this.userServiceImpl.getUserById(executorId));
                continue;
            }
            userSet.addAll(this.userServiceImpl.getUserListByGroup(candidate.getType(), executorId));
        }
        if (BeanUtils.isEmpty(userSet)) {
            return null;
        }
        ArrayList<IUser> arrayList = new ArrayList<IUser>();
        arrayList.addAll(userSet);
        return arrayList;
    }

    private List<String> getIdList(List<DefaultBpmProcessInstance> instList, String instanceId, boolean includeSelf, boolean isBpmnId) {
        ArrayList<String> includeIdList = new ArrayList<String>();
        for (DefaultBpmProcessInstance instance : instList) {
            if (!includeSelf && instanceId.equals(instance.getId())) continue;
            if (isBpmnId) {
                includeIdList.add(instance.getBpmnInstId());
                continue;
            }
            includeIdList.add(instanceId);
        }
        return includeIdList;
    }

    private DefaultBpmProcessInstance getMainInstance(List<DefaultBpmProcessInstance> instList, String instanceId) {
        for (DefaultBpmProcessInstance instance : instList) {
            if (!instance.getId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public List<DefaultBpmProcessInstance> queryList(QueryFilter queryFilter) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        Map authorizeRightMap = null;
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            Map<String, Object> actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(userId, "instance", true, true);
            String defKeys = (String)actRightMap.get("defKeys");
            if (StringUtil.isNotEmpty((String)defKeys)) {
                queryFilter.addParams("defKeys", (Object)defKeys);
            }
            authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
        }
        PageList bpmProcessInstanceList = this.query(queryFilter);
        for (DefaultBpmProcessInstance instance : bpmProcessInstanceList.getRows()) {
            ObjectNode rightJson = null;
            String defKey = instance.getProcDefKey();
            if (instance.getDuration() == null || instance.getDuration() < 1L) {
                instance.setDuration(TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)instance.getCreateTime()));
            }
            rightJson = authorizeRightMap == null ? AuthorizeRight.getAdminRight() : (ObjectNode)authorizeRightMap.get(defKey);
            instance.setAuthorizeRight((JsonNode)rightJson);
        }
        return bpmProcessInstanceList.getRows();
    }

    @Override
    public ResultMessage canRevokeToStart(String instanceId) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)super.get((Serializable)((Object)instanceId));
        String defId = instance.getProcDefId();
        List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getStartNodes(defId);
        ResultMessage message = new ResultMessage();
        IUser user = ContextUtil.getCurrentUser();
        if (user == null) {
            message.setResult(-1);
            message.setMessage("\u8bf7\u5148\u8bbe\u7f6e\u5f53\u524d\u6267\u884c\u4eba!");
            return message;
        }
        if (nodeDefs.size() > 1) {
            message.setResult(-1);
            message.setMessage("\u53d1\u8d77\u8282\u70b9\u540e\u6709\u591a\u4e2a\u8282\u70b9!");
            return message;
        }
        String status = instance.getStatus();
        if (ProcessInstanceStatus.STATUS_REVOKE_TOSTART.getKey().equals(status) || ProcessInstanceStatus.STATUS_BACK_TOSTART.getKey().equals(status)) {
            message.setResult(-1);
            message.setMessage("\u6d41\u7a0b\u5df2\u5904\u4e8e\u7b2c\u4e00\u4e2a\u8282\u70b9!");
            return message;
        }
        if (!user.getUserId().equals(instance.getCreateBy())) {
            message.setResult(-1);
            message.setMessage("\u5f53\u524d\u6267\u884c\u4eba\u548c\u6d41\u7a0b\u53d1\u8d77\u4eba\u4e0d\u662f\u540c\u4e00\u4e2a\u4eba!");
            return message;
        }
        boolean rtn = this.validTask(instance.getBpmnInstId(), nodeDefs.get(0));
        if (!rtn) {
            message.setResult(-1);
            message.setMessage("\u4efb\u52a1\u5df2\u5728\u53d1\u8d77\u8282\u70b9,\u4e0d\u80fd\u518d\u64a4\u9500!");
            return message;
        }
        message.addVariable("bpmNodeDef", nodeDefs.get(0));
        message.setResult(1);
        return message;
    }

    private boolean validTask(String bpmnInstId, BpmNodeDef nodeDef) {
        String nodeId = nodeDef.getNodeId();
        List<ActTask> list = this.actTaskDao.getByInstId(bpmnInstId);
        for (ActTask task : list) {
            if (!nodeId.equals(task.getTaskDefKey())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ResultMessage canRevoke(String instanceId, String nodeId) {
        ResultMessage message = ResultMessage.getSuccess();
        BpmProcessInstance processInstance = (BpmProcessInstance)super.get((Serializable)((Object)instanceId));
        message = this.checkInstance(processInstance);
        if (message.getResult() == -1) {
            return message;
        }
        return message;
    }

    private ResultMessage checkInstance(BpmProcessInstance processInstance) {
        ResultMessage message = ResultMessage.getSuccess();
        String status = processInstance.getStatus();
        if (ProcessInstanceStatus.STATUS_RUNNING.getKey().equals(status)) {
            return message;
        }
        message.setResult(-1);
        String msg = "";
        if (ProcessInstanceStatus.STATUS_BACK.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u88ab\u9a73\u56de";
        } else if (ProcessInstanceStatus.STATUS_BACK_TOSTART.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u88ab\u9a73\u56de\u5230\u53d1\u8d77\u4eba";
        } else if (ProcessInstanceStatus.STATUS_END.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ed3\u675f";
        } else if (ProcessInstanceStatus.STATUS_END.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u5b9e\u4f8b\u88ab\u4eba\u5de5\u7ec8\u6b62";
        } else if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u5b9e\u4f8b\u4e3a\u8349\u7a3f\u72b6\u6001";
        } else if (ProcessInstanceStatus.STATUS_REVOKE.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u5b9e\u4f8b\u4e3a\u64a4\u9500\u72b6\u6001";
        } else if (ProcessInstanceStatus.STATUS_REVOKE_TOSTART.getKey().equals(status)) {
            msg = "\u6d41\u7a0b\u5b9e\u4f8b\u4e3a\u64a4\u9500\u72b6\u6001";
        }
        message.setMessage(msg);
        return message;
    }

    @Override
    public BpmProcessInstance getTopBpmProcessInstance(String proceInstId) {
        BpmProcessInstance instance = (BpmProcessInstance)this.get((Serializable)((Object)proceInstId));
        return this.getTopBpmProcessInstance(instance);
    }

    @Override
    public List<DefaultBpmProcessInstance> getListByDefId(String defId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getListByDefId(defId);
    }

    @Override
    public BpmProcessInstance getTopBpmProcessInstance(BpmProcessInstance instance) {
        while (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            instance = (BpmProcessInstance)super.get((Serializable)((Object)instance.getParentInstId()));
        }
        return instance;
    }

    @Override
    public List<BpmProcessInstance> getBpmProcessByParentIdAndSuperNodeId(String parentInstId, String superNodeId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getBpmnByParentIdAndSuperNodeId(parentInstId, superNodeId);
    }

    @Override
    public List<BpmProcessInstance> getHiBpmProcessByParentIdAndSuperNodeId(String parentInstId, String superNodeId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getHiBpmnByParentIdAndSuperNodeId(parentInstId, superNodeId);
    }

    @Override
    public DefaultBpmProcessInstance getByBusinessKey(String businessKey) {
        return ((BpmProcessInstanceDao)this.baseMapper).getByBusinessKey(businessKey);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getMyHandledMeeting(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        IPage<DefaultBpmProcessInstance> insList = ((BpmProcessInstanceDao)this.baseMapper).getMyHandledMeeting((IPage<DefaultBpmProcessInstance>)page, queryFilter.getParams());
        return new PageList(insList);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> queryByuserId(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        IPage<DefaultBpmProcessInstance> query = ((BpmProcessInstanceDao)this.baseMapper).queryByuserId((IPage<DefaultBpmProcessInstance>)page, (Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    @Override
    public IPage<DefaultBpmProcessInstance> getById(String auditor, QueryFilter queryFilter) {
        queryFilter.withParam("auditor", (Object)auditor);
        queryFilter.setDefaultSort("create_time_", Direction.DESC);
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        return ((BpmProcessInstanceDao)this.baseMapper).getById((IPage<DefaultBpmProcessInstance>)page, (Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void restore(String id) {
        ((BpmProcessInstanceDao)this.baseMapper).isDeleInst(id, 0);
        ((BpmProcessInstanceDao)this.baseMapper).isDeleOpinion(id, 0);
        ((BpmProcessInstanceDao)this.baseMapper).isDeleNotice(id, 0);
        ((BpmProcessInstanceDao)this.baseMapper).isDeleTask(id, 0);
    }

    @Override
    public List<String> getBpmTaskIdByInstId(String instId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getBpmTaskIdByInstId(instId);
    }

    @Override
    @Transactional
    public void deleteNotice(String instId) {
        ((BpmProcessInstanceDao)this.baseMapper).deleteNotice(instId);
    }

    @Override
    public List<String> getNodeIdByInstId(String instId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getNodeIdByInstId(instId);
    }

    @Override
    public List<Map<String, Object>> getFlowFieldList(QueryFilter queryFilter) {
        return ((BpmProcessInstanceDao)this.baseMapper).getFlowFieldList((IPage<DefaultBpmProcessInstance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DefaultBpmProcessInstance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public Object getNodeApprovalUsers(List<String> includeIdList) throws Exception {
        Map<String, IUser> map;
        List<DefaultBpmTask> bpmTasks = this.bpmTaskManager.getByInstList(includeIdList);
        if (BeanUtils.isEmpty(bpmTasks) || bpmTasks.size() < 1) {
            return null;
        }
        HashMap<String, String> taskIdMap = new HashMap<String, String>();
        HashMap nodeApprovalMap = new HashMap();
        for (DefaultBpmTask defaultBpmTask : bpmTasks) {
            String assigneeId = defaultBpmTask.getAssigneeId();
            taskIdMap.put(defaultBpmTask.getTaskId(), defaultBpmTask.getNodeId());
            if (!StringUtil.isNotZeroEmpty((String)assigneeId)) continue;
            Map<String, Object> map2 = new HashMap<String, IUser>();
            if (nodeApprovalMap.containsKey(defaultBpmTask.getNodeId())) {
                map2 = (Map)nodeApprovalMap.get(defaultBpmTask.getNodeId());
            }
            map2.put(assigneeId, this.userServiceImpl.getUserById(assigneeId));
            nodeApprovalMap.put(defaultBpmTask.getNodeId(), map2);
        }
        List<DefaultBpmTaskCandidate> candidates = this.bpmTaskCandidateManager.getByInstList(includeIdList);
        for (DefaultBpmTaskCandidate candidate : candidates) {
            String executorId = candidate.getExecutor();
            String nodeId = (String)taskIdMap.get(candidate.getTaskId());
            Map map2 = map = nodeApprovalMap.containsKey(nodeId) ? (Map)nodeApprovalMap.get(nodeId) : new HashMap();
            if ("user".equals(candidate.getType())) {
                IUser userById = this.userServiceImpl.getUserById(executorId);
                if (BeanUtils.isEmpty((Object)userById)) continue;
                map.put(userById.getUserId(), userById);
            } else {
                HashMap<String, IUser> userMap = new HashMap<String, IUser>();
                List users = this.userServiceImpl.getUserListByGroup(candidate.getType(), executorId);
                for (IUser iUser : users) {
                    userMap.put(iUser.getUserId(), iUser);
                }
                map.putAll(userMap);
            }
            nodeApprovalMap.put(nodeId, map);
        }
        ArrayList<Map> arrayList = new ArrayList<Map>();
        List<BpmNodeDef> allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(bpmTasks.get(0).getProcDefId());
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            if (!nodeApprovalMap.containsKey(bpmNodeDef.getNodeId())) continue;
            map = (Map)nodeApprovalMap.get(bpmNodeDef.getNodeId());
            Map jsonNode = JsonUtil.toMap((String)JsonUtil.toJson((Object)bpmNodeDef));
            jsonNode.put("assigneeUsers", map.values());
            arrayList.add(jsonNode);
        }
        return arrayList;
    }

    @Override
    public List<DefaultBpmProcessInstance> getListByRightMap(Map<String, String> userRightMap) {
        return ((BpmProcessInstanceDao)this.baseMapper).getListByRightMap(userRightMap);
    }

    @Override
    public DefaultBpmProcessInstance getNowAndHistory(String instId) {
        return ((BpmProcessInstanceDao)this.baseMapper).getNowAndHistory(instId);
    }

    @Override
    public void delVarByInstIdAndName(String bpmnInstId, String ... names) {
        if (BeanUtils.isEmpty(((BpmProcessInstanceDao)this.baseMapper).getVarByInstIdAndName(bpmnInstId, names))) {
            return;
        }
        ((BpmProcessInstanceDao)this.baseMapper).delVarByInstIdAndName(bpmnInstId, names);
    }

    @Override
    public int getIsInRightMap(String procInstId, String orgIds) {
        return ((BpmProcessInstanceDao)this.baseMapper).getIsInRightMap(procInstId, orgIds);
    }

    @Override
    public List<String> getStringListByRightMap(Map<String, String> userRightMap) {
        return ((BpmProcessInstanceDao)this.baseMapper).getStringListByRightMap(userRightMap);
    }

    @Override
    public List<Map<String, Object>> getInstanceCountByDefKeys(String ... defkeys) {
        return ((BpmProcessInstanceDao)this.baseMapper).getInstanceCountByDefKeys(defkeys);
    }

    @Override
    public String getDefForbidStatus(String definitionId, String instanceId, String taskId) {
        DefaultBpmDefinition bpmDefinition;
        DefaultBpmTask defaultBpmTask;
        if (StringUtil.isEmpty((String)instanceId) && StringUtil.isNotEmpty((String)taskId) && BeanUtils.isNotEmpty((Object)(defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId))))) {
            instanceId = defaultBpmTask.getProcInstId();
        }
        String result = "";
        if (StringUtil.isNotEmpty((String)instanceId)) {
            BpmProcessInstance instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
            int forbindden = instance.getIsForbidden();
            if (BpmProcessInstance.FORBIDDEN_YES == forbindden) {
                result = result + "1";
            }
            definitionId = instance.getProcDefId();
        }
        if (BeanUtils.isNotEmpty((Object)(bpmDefinition = this.bpmDefinitionManager.getById(definitionId)))) {
            String status = bpmDefinition.getStatus();
            if ("forbidden".equals(status)) {
                result = result + "2";
            } else if ("forbidden_instance".equals(status)) {
                result = result + "3";
            }
        }
        return result;
    }
}

