/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.execution.message.context;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.XmlUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.constant.LogicType;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.plugin.core.context.AbstractBpmExecutionPluginContext;
import com.artfess.bpm.api.plugin.core.context.UserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.core.util.UserAssignRuleParser;
import com.artfess.bpm.plugin.execution.message.def.HtmlSetting;
import com.artfess.bpm.plugin.execution.message.def.MessagePluginDef;
import com.artfess.bpm.plugin.execution.message.def.PlainTextSetting;
import com.artfess.bpm.plugin.execution.message.entity.Message;
import com.artfess.bpm.plugin.execution.message.entity.ObjectFactory;
import com.artfess.bpm.plugin.execution.message.plugin.MessagePlugin;
import com.artfess.bpm.plugin.usercalc.cusers.context.CusersPluginContext;
import com.artfess.bpm.plugin.usercalc.cusers.def.CusersPluginDef;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class MessagePluginContext
extends AbstractBpmExecutionPluginContext {
    private static final long serialVersionUID = 7968222573049167392L;

    @Override
    public List<EventType> getEventTypes() {
        ArrayList<EventType> list = new ArrayList<EventType>();
        list.add(EventType.AUTO_TASK_EVENT);
        return list;
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return MessagePlugin.class;
    }

    private static MessagePluginDef getMessageDef() {
        ArrayList<UserAssignRule> ruleList = new ArrayList<UserAssignRule>();
        MessagePluginDef def = new MessagePluginDef();
        HtmlSetting htmlSetting = new HtmlSetting();
        UserAssignRule rule = new UserAssignRule();
        rule.setCondition("aaa>0");
        rule.setGroupNo(1);
        CusersPluginContext ctx = new CusersPluginContext();
        CusersPluginDef cdef = new CusersPluginDef();
        cdef.setAccount("zhangyg");
        cdef.setExtract(ExtractType.EXACT_NOEXACT);
        cdef.setSource("spec");
        cdef.setUserName("zhangyg");
        cdef.setLogicCal(LogicType.OR);
        ctx.setBpmPluginDef(cdef);
        ArrayList<UserCalcPluginContext> calcPluginContextList = new ArrayList<UserCalcPluginContext>();
        calcPluginContextList.add(ctx);
        rule.setCalcPluginContextList(calcPluginContextList);
        ruleList.add(rule);
        htmlSetting.setRuleList(ruleList);
        PlainTextSetting pSetting = new PlainTextSetting();
        def.setExternalClass("com.artfess.Demo");
        def.setHtmlSetting(htmlSetting);
        def.setPlainTextSetting(pSetting);
        return def;
    }

    @Override
    public String getPluginXml() {
        MessagePluginDef pluginDef = (MessagePluginDef)this.getBpmPluginDef();
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"message").a("xmlns", "http://www.jee-soft.cn/bpm/plugins/execution/message");
            if (StringUtil.isNotEmpty((String)pluginDef.getExternalClass())) {
                xmlBuilder.a("externalClass", pluginDef.getExternalClass());
            }
            HtmlSetting setting = pluginDef.getHtmlSetting();
            xmlBuilder = xmlBuilder.e("html").a("msgType", setting.getMsgType()).e("subject").d(setting.getSubject()).up().e("content").d(setting.getContent()).up();
            UserAssignRuleParser.handXmlBulider(xmlBuilder, setting.getRuleList());
            xmlBuilder = xmlBuilder.up();
            PlainTextSetting textSetting = pluginDef.getPlainTextSetting();
            xmlBuilder = xmlBuilder.e("plainText").a("msgType", textSetting.getMsgType()).e("content").d(textSetting.getContent()).up();
            UserAssignRuleParser.handXmlBulider(xmlBuilder, textSetting.getRuleList());
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getJson() throws IOException {
        ArrayNode ruleList;
        ObjectNode setting;
        MessagePluginDef pluginDef = (MessagePluginDef)this.getBpmPluginDef();
        ObjectNode config = JsonUtil.getMapper().createObjectNode();
        config.put("externalClass", pluginDef.getExternalClass());
        config.put("pluginName", pluginDef.getPluginName());
        if (pluginDef.getHtmlSetting() != null) {
            HtmlSetting htmlSetting = pluginDef.getHtmlSetting();
            setting = (ObjectNode)JsonUtil.toJsonNode((Object)htmlSetting);
            ruleList = JsonUtil.getMapper().createArrayNode();
            if (BeanUtils.isNotEmpty(htmlSetting.getRuleList())) {
                UserAssignRuleParser.handJsonConfig(ruleList, htmlSetting.getRuleList());
            }
            setting.remove("ruleList");
            setting.set("ruleList", (JsonNode)ruleList);
            config.set("htmlSetting", (JsonNode)setting);
        }
        if (pluginDef.getPlainTextSetting() != null) {
            PlainTextSetting plainSetting = pluginDef.getPlainTextSetting();
            setting = (ObjectNode)JsonUtil.toJsonNode((Object)plainSetting);
            ruleList = JsonUtil.getMapper().createArrayNode();
            if (BeanUtils.isNotEmpty(plainSetting.getRuleList())) {
                UserAssignRuleParser.handJsonConfig(ruleList, plainSetting.getRuleList());
            }
            setting.remove("ruleList");
            setting.set("ruleList", (JsonNode)ruleList);
            config.set("plainTextSetting", (JsonNode)setting);
        }
        config.put("pluginType", this.getType());
        return JsonUtil.toJson((Object)config);
    }

    @Override
    protected BpmPluginDef parseJson(String pluginJson) throws Exception {
        ObjectNode ObjectNode2 = (ObjectNode)JsonUtil.toJsonNode((String)pluginJson);
        MessagePluginDef pluginDef = new MessagePluginDef();
        String externalClass = JsonUtil.getString((JsonNode)ObjectNode2, (String)"externalClass");
        this.handHtmlSetting(pluginDef, ObjectNode2);
        this.handPlainTextSetting(pluginDef, ObjectNode2);
        pluginDef.setExternalClass(externalClass);
        return pluginDef;
    }

    private void handPlainTextSetting(MessagePluginDef pluginDef, ObjectNode ObjectNode2) throws Exception {
        ObjectNode handPlainJsonObject = (ObjectNode)ObjectNode2.get("plainTextSetting");
        PlainTextSetting plainTextSetting = new PlainTextSetting();
        this.handPublicSetting(handPlainJsonObject, plainTextSetting);
        pluginDef.setPlainTextSetting(plainTextSetting);
    }

    private void handHtmlSetting(MessagePluginDef pluginDef, ObjectNode ObjectNode2) throws Exception {
        ObjectNode htmlJsonObject = (ObjectNode)ObjectNode2.get("htmlSetting");
        String subject = JsonUtil.getString((JsonNode)htmlJsonObject, (String)"subject", (String)"");
        HtmlSetting htmlSetting = new HtmlSetting();
        this.handPublicSetting(htmlJsonObject, htmlSetting);
        htmlSetting.setSubject(subject);
        pluginDef.setHtmlSetting(htmlSetting);
    }

    private void handPublicSetting(ObjectNode ObjectNode2, PlainTextSetting plainTextSetting) throws Exception {
        String msgType = JsonUtil.getString((JsonNode)ObjectNode2, (String)"msgType");
        if ("".equals(msgType)) {
            return;
        }
        String content = ObjectNode2.get("content").asText();
        ArrayNode rulesAry = (ArrayNode)ObjectNode2.get("ruleList");
        List<UserAssignRule> ruleList = this.getRulesByJsonArray(rulesAry);
        plainTextSetting.setContent(content);
        plainTextSetting.setMsgType(msgType);
        plainTextSetting.setRuleList(ruleList);
    }

    private List<UserAssignRule> getRulesByJsonArray(ArrayNode jsonAry) throws Exception {
        ArrayList<UserAssignRule> rules = new ArrayList<UserAssignRule>();
        if (BeanUtils.isEmpty((Object)jsonAry)) {
            return rules;
        }
        for (Object obj : jsonAry) {
            UserAssignRule rule = UserAssignRuleParser.getUserAssignRule((ObjectNode)obj);
            rules.add(rule);
        }
        return rules;
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        String xml = XmlUtil.getXML((Element)element);
        MessagePluginDef pluginDef = new MessagePluginDef();
        try {
            List<UserAssignRule> list;
            Element el;
            Message message = (Message)JAXBUtil.unmarshall((String)xml, ObjectFactory.class);
            String externalClass = message.getExternalClass();
            if (StringUtil.isNotEmpty((String)externalClass)) {
                pluginDef.setExternalClass(externalClass);
            }
            Message.PlainText plainText = message.getPlainText();
            Message.Html html = message.getHtml();
            if (plainText != null) {
                PlainTextSetting plain = new PlainTextSetting();
                plain.setMsgType(plainText.getMsgType());
                plain.setContent(plainText.getContent());
                el = XmlUtil.getChildNodeByName((Element)element, (String)"plainText");
                list = UserAssignRuleParser.parse(el);
                plain.setRuleList(list);
                pluginDef.setPlainTextSetting(plain);
            }
            if (html != null) {
                HtmlSetting htmlSetting = new HtmlSetting();
                htmlSetting.setSubject(html.getSubject());
                htmlSetting.setMsgType(html.getMsgType());
                htmlSetting.setContent(html.getContent());
                el = XmlUtil.getChildNodeByName((Element)element, (String)"html");
                list = UserAssignRuleParser.parse(el);
                htmlSetting.setRuleList(list);
                pluginDef.setHtmlSetting(htmlSetting);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pluginDef;
    }

    @Override
    public String getTitle() {
        return "\u6d88\u606f\u8282\u70b9";
    }
}

