/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.annotation.AsyncThreadClean;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.NotFoundException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.InterPoseType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.PrivilegeMode;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.helper.identity.UserQueryPluginHelper;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmDefExtProperties;
import com.artfess.bpm.api.model.process.def.BpmDefLayout;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmNodeLayout;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeForm;
import com.artfess.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.BpmTaskOpinion;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmAgentService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.api.service.BpmIdentityService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmOpinionService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.api.service.DiagramService;
import com.artfess.bpm.api.service.SignService;
import com.artfess.bpm.api.service.TaskCommuService;
import com.artfess.bpm.engine.form.BpmFormFactory;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.exception.ApproveTaskException;
import com.artfess.bpm.listener.BusDataUtil;
import com.artfess.bpm.model.form.BpmForm;
import com.artfess.bpm.model.form.FormCategory;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.model.var.DefaultBpmVariableDef;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.ActTaskManager;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefActManager;
import com.artfess.bpm.persistence.manager.BpmDefUserManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmExeStackRelationManager;
import com.artfess.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmReadRecordManager;
import com.artfess.bpm.persistence.manager.BpmSecretaryManageManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.manager.CopyToManager;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.BpmBusLink;
import com.artfess.bpm.persistence.model.BpmDefAct;
import com.artfess.bpm.persistence.model.BpmDefUser;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.BpmExeStackRelation;
import com.artfess.bpm.persistence.model.BpmInterposeRecored;
import com.artfess.bpm.persistence.model.BpmReadRecord;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.BpmTaskNoticeDone;
import com.artfess.bpm.persistence.model.CopyTo;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskTurn;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.bpm.persistence.util.BpmStackRelationUtil;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmIdentityUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.manager.BpmTaskSignSequenceManager;
import com.artfess.workflow.runtime.manager.BpmTaskTransManager;
import com.artfess.workflow.runtime.manager.BpmTaskTransRecordManager;
import com.artfess.workflow.runtime.manager.BpmTransReceiverManager;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.manager.TaskTransService;
import com.artfess.workflow.runtime.model.BpmTaskTrans;
import com.artfess.workflow.runtime.model.BpmTaskTransRecord;
import com.artfess.workflow.runtime.model.BpmTransReceiver;
import com.artfess.workflow.runtime.params.AssignParamObject;
import com.artfess.workflow.runtime.params.CommunicateParamObject;
import com.artfess.workflow.runtime.params.DoNextParamObject;
import com.artfess.workflow.runtime.params.FlowImageVo;
import com.artfess.workflow.runtime.params.FormAndBoVo;
import com.artfess.workflow.runtime.params.InstFormAndBoVo;
import com.artfess.workflow.runtime.params.IsAllowAddSignObject;
import com.artfess.workflow.runtime.params.ModifyExecutorsParamObject;
import com.artfess.workflow.runtime.params.RevokeParamObject;
import com.artfess.workflow.runtime.params.RevokeSignLineParamObject;
import com.artfess.workflow.runtime.params.RevokeTransParamObject;
import com.artfess.workflow.runtime.params.SelectDestinationVo;
import com.artfess.workflow.runtime.params.StartCmdParam;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.artfess.workflow.runtime.params.TaskApproveLineParam;
import com.artfess.workflow.runtime.params.TaskDetailVo;
import com.artfess.workflow.runtime.params.TaskDoNextVo;
import com.artfess.workflow.runtime.params.TaskGetVo;
import com.artfess.workflow.runtime.params.TaskToAgreeVo;
import com.artfess.workflow.runtime.params.TaskToRejectVo;
import com.artfess.workflow.runtime.params.TaskTransParamObject;
import com.artfess.workflow.runtime.params.TaskjImageVo;
import com.artfess.workflow.runtime.params.WithDrawParam;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="IFlowManager")
public class FlowManagerImpl
implements IFlowManager {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    CopyToManager copyToManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmTaskTransRecordManager taskTransRecordManager;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    NatTaskService natTaskService;
    @Resource
    SignService signService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    TaskTransService taskTransService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    TaskCommuService taskCommuService;
    @Resource
    DiagramService diagramService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BpmExeStackRelationManager relationManager;
    @Resource
    BoDataService boDataService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    ActTaskManager actTaskManager;
    @Resource
    IUserService userService;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmTaskSignSequenceManager signSequenceManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmTaskTransManager bpmTaskTransManager;
    @Resource
    BpmAgentService bpmAgentService;
    @Resource
    protected FormFeignService formService;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    BpmDefActManager bpmDefActManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;

    @Override
    @Transactional
    public void delBpmTaskNoticeById(String id) throws Exception {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
        if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) {
            throw new RuntimeException("\u4f20\u9605\u63a5\u6536\u4eba\u5df2\u9605\uff0c\u65e0\u6cd5\u64a4\u56de");
        }
        if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
            this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
        }
        bpmTaskNotice.setIsRevoke(Integer.valueOf(1));
        noticeManager.update((Model)bpmTaskNotice);
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
        defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
        defaultBpmCheckOpinion.setProcDefId(bpmTaskNotice.getProcDefId());
        defaultBpmCheckOpinion.setProcInstId(bpmTaskNotice.getProcInstId());
        defaultBpmCheckOpinion.setTaskId(BeanUtils.isEmpty((Object)bpmTaskNotice.getTaskId()) ? null : bpmTaskNotice.getTaskId());
        defaultBpmCheckOpinion.setTaskKey(null);
        defaultBpmCheckOpinion.setTaskName("\u4f20\u9605\u4efb\u52a1");
        defaultBpmCheckOpinion.setStatus(OpinionStatus.COPYTO.getKey());
        defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
        defaultBpmCheckOpinion.setOpinion("\u4f20\u9605\u64a4\u56de");
        defaultBpmCheckOpinion.setQualfiedNames(bpmTaskNotice.getAssigneeName());
        defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
        defaultBpmCheckOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime())));
        defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        defaultBpmCheckOpinion.setFiles("");
        defaultBpmCheckOpinion.setIsRead(Integer.valueOf(1));
        this.bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
    }

    @Override
    public PageList<DefaultBpmTask> getLeaderTodoList(String account, QueryFilter queryFilter) throws Exception {
        PageList list;
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        if (BeanUtils.isNotEmpty((Object)(list = this.bpmTaskManager.getLeaderByUserId(user.getUserId(), queryFilter)))) {
            HashSet<String> defKeys = new HashSet<String>();
            for (DefaultBpmTask obj : list.getRows()) {
                defKeys.add(obj.getProcDefKey());
            }
            QueryFilter defQueryFilter = QueryFilter.build();
            defQueryFilter.addFilter("def_key_", (Object)StringUtil.join(defKeys), QueryOP.IN);
            defQueryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
            PageList defQuery = this.bpmDefinitionManager.query(defQueryFilter);
            for (DefaultBpmDefinition def : defQuery.getRows()) {
                if (def.getShowUrgentState() != 0) continue;
                defKeys.remove(def.getDefKey());
            }
            for (DefaultBpmTask task : list.getRows()) {
                if (defKeys.contains(task.getProcDefKey())) continue;
                task.setUrgentStateValue("");
            }
        }
        return list;
    }

    @Override
    public ObjectNode getOrgByIdOrCode(String orgId) {
        return this.ucFeignService.getOrgByIdOrCode(orgId);
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<PageList<DefaultBpmTask>> getTodoList(String account, QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            PageList list;
            String dbType = SQLUtil.getDbType();
            if (dbType.equals("postgresql")) {
                this.StringToTimestamp(queryFilter);
            }
            if (BeanUtils.isNotEmpty((Object)(list = this.bpmTaskManager.getByUserId(user.getUserId(), queryFilter)))) {
                HashSet<String> defKeys = new HashSet<String>();
                for (DefaultBpmTask obj : list.getRows()) {
                    defKeys.add(obj.getProcDefKey());
                }
                QueryFilter defQueryFilter = QueryFilter.build();
                defQueryFilter.addFilter("def_key_", (Object)StringUtil.join(defKeys), QueryOP.IN);
                defQueryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
                PageList defQuery = this.bpmDefinitionManager.query(defQueryFilter);
                for (DefaultBpmDefinition def : defQuery.getRows()) {
                    if (def.getShowUrgentState() != 0) continue;
                    defKeys.remove(def.getDefKey());
                }
                for (DefaultBpmTask task : list.getRows()) {
                    if (defKeys.contains(task.getProcDefKey())) continue;
                    task.setUrgentStateValue("");
                }
            }
            return CompletableFuture.completedFuture(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01", e);
        }
    }

    @Override
    public QueryFilter getTodoQueryFilter(QueryFilter queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            List fields = queryFilter.getQuerys();
            for (QueryField field : fields) {
                if (!"urgentStateValue".equals(field.getProperty())) continue;
                field.setGroup("groupUrgent");
                field.setRelation(FieldRelation.AND);
                QueryFilter defFilter = QueryFilter.build();
                defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                PageList query = this.bpmDefinitionManager.query(defFilter);
                ArrayList<String> defKeys = new ArrayList<String>();
                if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                    for (DefaultBpmDefinition def : query.getRows()) {
                        defKeys.add(def.getDefKey());
                    }
                }
                queryFilter.addFilter("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent");
                break;
            }
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
        return queryFilter;
    }

    @Override
    public PageList<BpmTaskNotice> getMyNoticeReadList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        queryFilter.addFilter("bpm_task_notice.STATUS_", (Object)"COPYTO", QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("OWNER_ID_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeManager.query(queryFilter);
    }

    @Override
    public List<Map<String, Object>> getMyNoticeReadCount(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        queryFilter.addFilter("notice.STATUS_", (Object)"COPYTO", QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("notice.OWNER_ID_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeManager.getNoticeTodoReadCount(queryFilter);
    }

    @Override
    public PageList<BpmTaskNotice> getNoticeTodoReadList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        BpmSecretaryManageManager bpmSecretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map leadersRigths = bpmSecretaryManageManager.getLeadersRigthMapBySecretaryId(user.getUserId(), "2", Boolean.valueOf(false));
        queryFilter.withParam("leaders", (Object)leadersRigths);
        queryFilter.addFilter("bpm_task_notice.ASSIGNEE_ID_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("IS_READ_", (Object)0, QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("IS_REVOKE_", (Object)0, QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeManager.query(queryFilter);
    }

    @Override
    public List<Map<String, Object>> getNoticeTodoReadCount(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        BpmSecretaryManageManager bpmSecretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map leadersRigths = bpmSecretaryManageManager.getLeadersRigthMapBySecretaryId(user.getUserId(), "2", Boolean.valueOf(false));
        queryFilter.withParam("leaders", (Object)leadersRigths);
        queryFilter.addFilter("notice.ASSIGNEE_ID_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("IS_READ_", (Object)0, QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("IS_REVOKE_", (Object)0, QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeManager.getNoticeTodoReadCount(queryFilter);
    }

    @Override
    public PageList<BpmTaskNoticeDone> getNoticeDoneReadList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        queryFilter.addFilter("bpm_task_notice_done.STATUS_", (Object)"COPYTO", QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("bpm_task_notice_done.AUDITOR_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeDoneManager.query(queryFilter);
    }

    @Override
    public List<Map<String, Object>> getNoticeDoneReadCount(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        queryFilter.addFilter("done.STATUS_", (Object)"COPYTO", QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("done.AUDITOR_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        return this.bpmTaskNoticeDoneManager.getNoticeDoneReadCount(queryFilter);
    }

    @Override
    public PageList<Map<String, Object>> getDoneList(String account, QueryFilter queryFilter, String status) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        IPage list = this.bpmProcessInstanceManager.getHandledByUserId(user.getUserId(), queryFilter);
        if (BeanUtils.isEmpty((Object)list) || BeanUtils.isEmpty((Object)list.getRecords())) {
            return new PageList(list);
        }
        List bpmnNodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(((Map)list.getRecords().get(0)).get("procDefId").toString());
        HashMap<String, BpmNodeDef> nodeMap = new HashMap<String, BpmNodeDef>();
        HashMap<String, String> superInstAndDefKeyMap = new HashMap<String, String>();
        for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
            nodeMap.put(bpmNodeDef.getNodeId(), bpmNodeDef);
        }
        for (int i = 0; i < list.getRecords().size(); ++i) {
            BpmNodeDef nodeDef;
            if (BeanUtils.isEmpty(((Map)list.getRecords().get(i)).get("taskKey")) || BeanUtils.isEmpty((Object)(nodeDef = (BpmNodeDef)nodeMap.get(((Map)list.getRecords().get(i)).get("taskKey").toString())))) continue;
            NodeProperties NodeProperties2 = nodeDef.getLocalProperties();
            if (BeanUtils.isNotEmpty(((Map)list.getRecords().get(i)).get("supInstId")) && BeanUtils.isNotEmpty((Object)nodeDef.getNodeProperties())) {
                String supInstId = ((Map)list.getRecords().get(i)).get("supInstId").toString();
                String parentDefkey = (String)superInstAndDefKeyMap.get(supInstId);
                if (StringUtil.isEmpty((String)parentDefkey)) {
                    DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)supInstId));
                    parentDefkey = processInstance.getProcDefKey();
                    superInstAndDefKeyMap.put(supInstId, parentDefkey);
                }
                NodeProperties2 = nodeDef.getPropertiesByParentDefKey(parentDefkey);
            }
            if (BeanUtils.isNotEmpty((Object)NodeProperties2)) {
                ((Map)list.getRecords().get(i)).put("referOpinion", NodeProperties2.isReferOpinion());
                ((Map)list.getRecords().get(i)).put("approvalArea", NodeProperties2.getApprovalArea());
                ((Map)list.getRecords().get(i)).put("previousRevoke", NodeProperties2.isPreviousRevoke());
            }
            ((Map)list.getRecords().get(i)).put("nodeType", nodeDef.getType().name());
        }
        return new PageList(list);
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<PageList<Map<String, Object>>> getDoneInstList(String account, QueryFilter queryFilter, String status) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        PageList result = this.bpmProcessInstanceManager.getDoneInstList(user.getUserId(), queryFilter);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public List<Map<String, Object>> getDoneInstCount(String account, QueryFilter queryFilter, String status) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        return this.bpmProcessInstanceManager.getDoneInstCount(user.getUserId(), queryFilter);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getCompletedList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        IPage list = this.bpmProcessInstanceManager.getCompletedByUserId(user.getUserId(), queryFilter);
        return new PageList(list);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getMyCompletedList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        IPage list = this.bpmProcessInstanceManager.getMyCompletedByUserId(user.getUserId(), queryFilter);
        return new PageList(list);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getMyRequestList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        IPage list = this.bpmProcessInstanceManager.getMyRequestByUserId(user.getUserId(), queryFilter);
        ArrayList<DefaultBpmProcessInstance> listInst = new ArrayList<DefaultBpmProcessInstance>();
        for (DefaultBpmProcessInstance entity : list.getRecords()) {
            TaskjImageVo taskNode;
            DefaultBpmProcessInstance defaultBpmProcessInstance = new DefaultBpmProcessInstance();
            defaultBpmProcessInstance = entity;
            if ("back".equals(entity.getStatus()) && BeanUtils.isNotEmpty((Object)(taskNode = this.taskImage("", entity.getProcDefId())))) {
                List listLayout = taskNode.getBpmDefLayout().getListLayout();
                List listStr = this.bpmProcessInstanceManager.getNodeIdByInstId(entity.getParentInstId());
                if (BeanUtils.isNotEmpty((Object)listStr) && ((BpmNodeLayout)listLayout.get(1)).getNodeId().equals(listStr.get(0))) {
                    defaultBpmProcessInstance.setBackToStart(Boolean.valueOf(true));
                }
            }
            listInst.add(defaultBpmProcessInstance);
        }
        return new PageList(listInst);
    }

    @Override
    public PageList<DefaultBpmDefinition> getMyFlowList(String account, QueryFilter queryFilter, String typeId) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        queryFilter.withParam("bpmDefAuthorizeRightType", (Object)"start");
        queryFilter.withQuery(new QueryField("is_main_", (Object)"Y", QueryOP.EQUAL));
        try {
            List list = this.bpmDefinitionManager.queryList(queryFilter, user).getRows();
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    private QueryFilter buildQueryFilter(ObjectNode jsonObject) {
        String orderField = JsonUtil.getString((JsonNode)jsonObject, (String)"orderField", (String)"create_time_");
        String orderSeq = JsonUtil.getString((JsonNode)jsonObject, (String)"orderSeq", (String)"desc");
        Integer currentPage = JsonUtil.getInt((ObjectNode)jsonObject, (String)"currentPage", (int)1);
        Integer pageSize = JsonUtil.getInt((ObjectNode)jsonObject, (String)"pageSize", (int)20);
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        PageBean page = new PageBean(currentPage, pageSize);
        queryFilter.setPageBean(page);
        if (StringUtil.isNotEmpty((String)orderField) && StringUtil.isNotEmpty((String)orderSeq)) {
            ArrayList<FieldSort> fieldSorts = new ArrayList<FieldSort>();
            fieldSorts.add(new FieldSort(orderField, Direction.fromString((String)orderSeq)));
            queryFilter.setSorter(fieldSorts);
        }
        return queryFilter;
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getMyDraftList(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            IPage list = this.bpmProcessInstanceManager.getDraftsByUserId(user.getUserId(), queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public PageList<CopyTo> getReceiverCopyTo(String account, QueryFilter queryFilter, String type) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            List list = this.copyToManager.getReceiverCopyTo(user.getUserId(), queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public PageList<CopyTo> myCopyTo(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            List list = this.copyToManager.getMyCopyTo(user.getUserId(), queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public List<BpmVariableDef> getWorkflowVar(String json) throws Exception {
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String defId = JsonUtil.getString((JsonNode)jsonObject, (String)"defId");
        String defKey = JsonUtil.getString((JsonNode)jsonObject, (String)"defKey");
        String flowKey = JsonUtil.getString((JsonNode)jsonObject, (String)"flowKey");
        DefaultBpmDefinition bpmDefinition = null;
        bpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (BeanUtils.isEmpty((Object)bpmDefinition)) {
            String key;
            String string = key = StringUtil.isNotEmpty((String)defKey) ? defKey : flowKey;
            if (StringUtil.isNotEmpty((String)key)) {
                bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(key, false);
                defId = bpmDefinition.getDefId();
            }
        }
        if (BeanUtils.isEmpty((Object)bpmDefinition)) {
            throw new NullPointerException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684defId\u3001defKey\u6216flowKey\uff01");
        }
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List bpmNodeDefList = this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.USERTASK);
        bpmNodeDefList.addAll(this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.SIGNTASK));
        for (BpmNodeDef bpmNodeDef : bpmNodeDefList) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)bpmNodeDef;
            List nodeVarList = taskNodeDef.getVariableList();
            if (nodeVarList == null) continue;
            bpmVariableList.addAll(nodeVarList);
        }
        return bpmVariableList;
    }

    @Override
    public PageList<DefaultBpmTaskTurn> getDelegate(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            String dbType = SQLUtil.getDbType();
            if (dbType.equals("postgresql")) {
                this.StringToTimestamp(queryFilter);
            }
            IPage list = this.bpmTaskTurnManager.getMyDelegate(user.getUserId(), queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> getDelegateCount(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        try {
            return this.bpmTaskTurnManager.getMyDelegateCount(user.getUserId());
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public PageList<BpmTaskTransRecord> getMyTrans(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        PageList<BpmTaskTransRecord> pageList = this.taskTransRecordManager.getMyTransRecord(user.getUserId(), queryFilter);
        return pageList;
    }

    @Override
    @Transactional
    public CommonResult<String> removeDraftById(String id) throws Exception {
        DefaultBpmProcessInstance processeInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)processeInstance)) {
            throw new NullPointerException("id\u4e3a" + id + "\u7684\u8349\u7a3f\u4e0d\u5b58\u5728\uff01");
        }
        if (!ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processeInstance.getStatus())) {
            throw new RuntimeException("\u8be5\u5b9e\u4f8b\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u8bf7\u4e0d\u8981\u901a\u8fc7\u6b64\u63a5\u53e3\u5220\u9664\uff01");
        }
        this.bpmProcessInstanceManager.remove((Serializable)((Object)id));
        return new CommonResult(true, "\u6d41\u7a0b\u8349\u7a3f\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delegate(AssignParamObject assignParamObject) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String taskId = assignParamObject.getTaskId();
        String messageType = assignParamObject.getMessageType();
        String userIds = assignParamObject.getUserId();
        String opinion = assignParamObject.getOpinion();
        String files = assignParamObject.getFiles();
        String formData = assignParamObject.getFormData();
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        if (StringUtil.isEmpty((String)messageType)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR + ":messageType\u901a\u77e5\u7c7b\u578b\u5fc5\u586b\uff01");
        }
        String userId = "";
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165\u8f6c\u529e\u7528\u6237id(userId)");
        }
        if (user.getUserId().equals(userIds)) {
            throw new RuntimeException("\u4efb\u52a1\u8f6c\u529e\u4eba\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        IUser userById = ServiceUtil.getUserById((String)userIds);
        if (BeanUtils.isEmpty((Object)userById)) {
            throw new RuntimeException("\u8f6c\u529e\u7528\u6237id\u4e0d\u5b58\u5728");
        }
        userId = userById.getUserId();
        this.bpmTaskActionService.delegate(taskId, userId, messageType, opinion, files, formData);
        return new CommonResult(true, "\u4efb\u52a1\u8f6c\u529e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> taskSignUsers(AssignParamObject assignParamObject) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String taskId = assignParamObject.getTaskId();
        String userIds = assignParamObject.getUserId();
        String messageType = assignParamObject.getMessageType();
        String addReason = assignParamObject.getOpinion();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165\u52a0\u7b7e\u7528\u6237Id");
        }
        String[] userIdAry = userIds.split(",");
        ArrayList<String> userIdList = new ArrayList<String>();
        HashSet<String> userNames = new HashSet<String>();
        for (String userId : userIdAry) {
            if (user.getUserId().equals(userId)) {
                throw new RuntimeException(String.format("\u4efb\u52a1\u52a0\u7b7e\u4eba\u4e0d\u80fd\u4e3a\u81ea\u5df1:%s", userId));
            }
            IUser userById = ServiceUtil.getUserById((String)userId);
            if (BeanUtils.isEmpty((Object)userById)) {
                throw new RuntimeException(String.format("\u52a0\u7b7e\u7528\u6237Id(userId):%s\u4e0d\u5b58\u5728", userId));
            }
            userNames.add(userById.getFullname());
            userIdList.add(userById.getUserId());
        }
        String[] userIdsAry = new String[userIdList.size()];
        userIdList.toArray(userIdsAry);
        ResultMessage addSignTask = this.signService.addSignTask(taskId, userIdAry);
        if (addSignTask.getResult() == 1) {
            DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            if (StringUtil.isEmpty((String)messageType)) {
                messageType = BpmUtil.getNotifyType((BpmTask)bpmTask);
            }
            DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
            checkOpinion.setId(UniqueIdUtil.getSuid());
            checkOpinion.setProcDefId(bpmTask.getBpmnDefId());
            checkOpinion.setProcInstId(bpmTask.getProcInstId());
            checkOpinion.setTaskId(bpmTask.getTaskId());
            checkOpinion.setTaskKey(bpmTask.getNodeId());
            checkOpinion.setTaskName(bpmTask.getName());
            checkOpinion.setStatus(OpinionStatus.ADDSIGN.getKey());
            checkOpinion.setCreateTime(LocalDateTime.now());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setQualfiedNames(StringUtil.join(userNames));
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            checkOpinion.setOpinion(assignParamObject.getOpinion());
            this.bpmCheckOpinionManager.create((Model)checkOpinion);
            List bpmIdentities = (List)addSignTask.getVars().get("users");
            ArrayList<IUser> users = this.bpmIdentityExtractService.extractUser(bpmIdentities);
            Map variables = this.natTaskService.getVariables(taskId);
            variables.put("cause", addReason);
            variables.put("sender", ContextUtil.getCurrentUser().getFullname());
            variables.put("taskSubject", variables.get("subject_"));
            String baseUrl = "";
            variables.put("baseUrl", baseUrl);
            List taskIds = (List)addSignTask.getVars().get("taskIds");
            for (IUser iuser : users) {
                String taskid = this.findTaskId(taskIds, user.getUserId());
                if (!StringUtil.isNotEmpty((String)taskid)) continue;
                variables.put("taskId", taskid);
                users = new ArrayList<IUser>();
                users.add(user);
                this.signService.sendNotify(users, Arrays.asList(messageType.split(",")), "addSignTask", variables);
            }
            return new CommonResult(true, "\u4efb\u52a1\u52a0\u7b7e\u6210\u529f");
        }
        throw new RuntimeException(addSignTask.getCause());
    }

    private String findTaskId(List<Map<String, String>> taskIds, String userId) {
        String taskId = "";
        for (Map<String, String> map : taskIds) {
            String uid = map.get("userId");
            if (!userId.equals(uid)) continue;
            taskId = map.get("taskId");
            break;
        }
        return taskId;
    }

    @Override
    @Transactional
    public CommonResult<String> revokeInstance(RevokeParamObject revokeParamObject) throws Exception {
        String instanceId = revokeParamObject.getInstanceId();
        String messageType = revokeParamObject.getMessageType();
        String cause = revokeParamObject.getCause();
        Boolean isHandRevoke = revokeParamObject.getIsHandRevoke();
        BpmUtil.checkDefForbidStatus((String)"", (String)instanceId, (String)"");
        ResultMessage result = null;
        result = isHandRevoke != false ? this.revokeTask(revokeParamObject.getTaskId(), instanceId, messageType, cause, revokeParamObject.getRevokeNodeId()) : this.bpmProcessInstanceManager.revokeInstance(instanceId, messageType, cause);
        if (result.getResult() == 1) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            String val = "";
            if (StringUtil.isNotEmpty((String)((String)actionCmd.getTransitVars().get("revokeTaskId")))) {
                val = actionCmd.getTransitVars().get("revokeTaskId").toString();
            }
            return new CommonResult(true, "\u64a4\u56de\u6210\u529f", (Object)val);
        }
        return new CommonResult(false, result.getMessage(), (Object)"");
    }

    private boolean validTask(String bpmnInstId, BpmNodeDef nodeDef) {
        String nodeId = nodeDef.getNodeId();
        List list = this.actTaskManager.getByInstId(bpmnInstId);
        for (ActTask task : list) {
            if (!nodeId.equals(task.getTaskDefKey())) continue;
            return false;
        }
        return true;
    }

    private DefaultTaskFinishCmd getCmdFromRecall(String taskId, String actionName, String opinion, String backHandMode, String toNodeId, BpmIdentity bpmIdentity) {
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        cmd.setDestination(toNodeId);
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.addTransitVars("IsDoneUnused", (Object)true);
        cmd.setApprovalOpinion(opinion);
        cmd.setDataMode("bo");
        cmd.addTransitVars("backHandMode", (Object)backHandMode);
        ArrayList<BpmIdentity> list = new ArrayList<BpmIdentity>();
        list.add(bpmIdentity);
        HashMap<String, ArrayList<BpmIdentity>> nodeIdentityMap = new HashMap<String, ArrayList<BpmIdentity>>();
        nodeIdentityMap.put(toNodeId, list);
        cmd.setBpmIdentities(nodeIdentityMap);
        return cmd;
    }

    private void doEndRevoke(PageList<DefaultBpmCheckOpinion> query, DefaultBpmProcessInstance instance, String cause, String revokeTaskId) throws Exception {
        ActionCmd actionCmd;
        String taskId = "";
        if (BeanUtils.isNotEmpty(query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
            for (DefaultBpmCheckOpinion opinion : query.getRows()) {
                if (!OpinionStatus.END.getKey().equals(opinion.getStatus())) continue;
                taskId = opinion.getParentTaskId();
                break;
            }
        }
        if (!revokeTaskId.equals(taskId)) {
            throw new RuntimeException("\u60a8\u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u5904\u7406\u4eba\uff0c\u65e0\u6cd5\u8fdb\u884c\u529e\u7ed3\u64a4\u56de");
        }
        if (StringUtil.isEmpty((String)taskId)) {
            throw new BaseException("\u672a\u627e\u5230\u7ed3\u675f\u8282\u70b9\uff0c\u65e0\u6cd5\u64a4\u56de");
        }
        DefaultBpmCheckOpinion checkOpinion = BpmCheckOpinionUtil.getCheckOpinionByTaskId((String)taskId);
        instance.setStatus(ProcessInstanceStatus.STATUS_DRAFT.getKey());
        instance.setDuration(null);
        instance.setEndTime(null);
        this.bpmProcessInstanceManager.update((Model)instance);
        IProcessManager processManager = (IProcessManager)AppUtil.getBean(IProcessManager.class);
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setDestination(checkOpinion.getTaskKey());
        startFlowParamObject.setDefId(instance.getProcDefId());
        startFlowParamObject.setProInstId(instance.getId());
        startFlowParamObject.setAccount(this.userServiceImpl.getUserById(instance.getCreateBy()).getAccount());
        ObjectNode nextNodeUser = JsonUtil.getMapper().createObjectNode();
        nextNodeUser.put("nodeId", checkOpinion.getTaskKey());
        ArrayList<DefaultBpmIdentity> userList = new ArrayList<DefaultBpmIdentity>();
        userList.add((DefaultBpmIdentity)DefaultBpmIdentity.getIdentityByUserId((String)checkOpinion.getAuditor(), (String)checkOpinion.getAuditorName()));
        nextNodeUser.set("executors", JsonUtil.toJsonNode(userList));
        startFlowParamObject.setNodeUsers(JsonUtil.toJson((Object)nextNodeUser));
        startFlowParamObject.setIsSendNodeUsers(1);
        ThreadMsgUtil.addMapMsg((String)"inst_end_revoke", (String)"true");
        processManager.syncStart(startFlowParamObject);
        ThreadMsgUtil.addMapMsg((String)"inst_end_revoke", (String)"false");
        checkOpinion.setAuditor("");
        checkOpinion.setAuditorName("");
        checkOpinion.setCompleteTime(null);
        checkOpinion.setOpinion("");
        checkOpinion.setZfiles("");
        checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        if (StringUtil.isNotEmpty((String)ThreadMsgUtil.getMapMsg((String)"bpmTask_"))) {
            this.bpmExeStackManager.updateStackTaskIdWhenEndRevoke(checkOpinion.getTaskId(), ThreadMsgUtil.getMapMsg((String)"bpmTask_"));
            checkOpinion.setTaskId(ThreadMsgUtil.getMapMsg((String)"bpmTask_"));
        }
        if (BeanUtils.isEmpty((Object)(actionCmd = ContextThreadUtil.getActionCmd()))) {
            actionCmd = new BaseActionCmd();
            ContextThreadUtil.setActionCmd((ActionCmd)actionCmd);
        }
        actionCmd.addTransitVars("revokeTaskId", (Object)checkOpinion.getTaskId());
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    @Transactional
    public ResultMessage revokeTask(String revokeTaskId, String instId, String informType, String cause, String revokeNodeId) throws Exception {
        DefaultBpmDefinition def;
        List byParentId;
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmExeStackExecutorManager bpmExeStackExecutorManager = (BpmExeStackExecutorManager)AppUtil.getBean(BpmExeStackExecutorManager.class);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter = QueryFilter.build();
        queryFilter.addFilter("PROC_INST_ID_", (Object)instId, QueryOP.EQUAL);
        ArrayList<FieldSort> sorter1 = new ArrayList<FieldSort>();
        FieldSort sort1 = new FieldSort("COMPLETE_TIME_", Direction.DESC);
        sorter1.add(sort1);
        queryFilter.setSorter(sorter1);
        PageList query = this.bpmCheckOpinionManager.query(queryFilter);
        if (ProcessInstanceStatus.STATUS_END.getKey().equals(instance.getStatus())) {
            this.doEndRevoke((PageList<DefaultBpmCheckOpinion>)query, instance, cause, revokeTaskId);
            return new ResultMessage(1, "\u64a4\u56de\u6210\u529f");
        }
        List list = this.bpmTaskManager.getByInstId(instId);
        if (BeanUtils.isEmpty((Object)list)) {
            throw new BaseException("\u9a73\u56de\u5230\u5916\u90e8\u5b50\u6d41\u7a0b\u7684\u64cd\u4f5c\u4e0d\u652f\u6301\u64a4\u56de");
        }
        for (DefaultBpmCheckOpinion opinion : query.getRows()) {
            if (!revokeTaskId.equals(opinion.getParentTaskId()) || !OpinionStatus.DELIVERTO.getKey().equals(opinion.getStatus())) continue;
            throw new RuntimeException("\u6b64\u5de5\u4f5c\u76ee\u524d\u4e0d\u529e\u7406\uff0c\u53ef\u80fd\u5df2\u7ecf\u529e\u7ed3\u6216\u8005\u88ab\u6682\u505c\uff01\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\uff01");
        }
        DefaultBpmTask runningTask = (DefaultBpmTask)list.get(0);
        if (list.size() > 1 && BeanUtils.isNotEmpty((Object)(byParentId = this.bpmCheckOpinionManager.getByParentId(revokeTaskId)))) {
            HashSet<String> taskIds = new HashSet<String>();
            for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : byParentId) {
                if (!defaultBpmCheckOpinion.getStatus().equals(OpinionStatus.AWAITING_CHECK.getKey())) continue;
                taskIds.add(defaultBpmCheckOpinion.getTaskId());
            }
            for (DefaultBpmTask task : list) {
                if (!taskIds.contains(task.getId())) continue;
                runningTask = task;
                break;
            }
        }
        String prcoDefId = runningTask.getProcDefId();
        String nodeId = runningTask.getNodeId();
        String taskId = runningTask.getTaskId();
        BpmNodeDef node = bpmDefinitionAccessor.getBpmNodeDef(prcoDefId, nodeId);
        NodeType type = node.getType();
        List bpmReadRecord = this.bpmReadRecordManager.getByTaskIds(list);
        if (BeanUtils.isNotEmpty((Object)bpmReadRecord) && "false".equals((def = this.bpmDefinitionManager.getById(prcoDefId)).getIsReadRevoke())) {
            throw new BaseException("\u4efb\u52a1\u5df2\u88ab\u67e5\u9605\uff0c\u65e0\u6cd5\u64a4\u56de!");
        }
        DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)query.getRows().get(0);
        if (OpinionStatus.INQU.getKey().equals(checkOpinion.getStatus())) {
            DefaultBpmDefinition bpmDefinition;
            BpmTaskNotice bpmTaskNotice;
            BpmTaskNoticeManager noticeManager;
            List list1;
            int i;
            DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)checkOpinion.getTaskId()));
            task.setStatus(TaskType.NORMAL.getKey());
            this.bpmTaskManager.update((Model)task);
            QueryFilter queryFilter2 = QueryFilter.build();
            queryFilter2.addFilter("task_id_", (Object)checkOpinion.getTaskId(), QueryOP.EQUAL);
            BpmTaskTransManager bpmTaskTransManager = (BpmTaskTransManager)AppUtil.getBean(BpmTaskTransManager.class);
            PageList query2 = bpmTaskTransManager.query(queryFilter2);
            String[] ids = new String[query2.getRows().size()];
            for (int i2 = 0; i2 < query2.getRows().size(); ++i2) {
                ids[i2] = ((BpmTaskTrans)query2.getRows().get(i2)).getId();
            }
            bpmTaskTransManager.removeByIds(ids);
            BpmTaskTransRecordManager bpmTaskTransRecordManager = (BpmTaskTransRecordManager)AppUtil.getBean(BpmTaskTransRecordManager.class);
            QueryFilter queryFilter3 = QueryFilter.build();
            queryFilter3.addFilter("task_id_", (Object)checkOpinion.getTaskId(), QueryOP.EQUAL);
            PageList query3 = bpmTaskTransRecordManager.query(queryFilter3);
            String[] ids3 = new String[query3.getRows().size()];
            for (int i3 = 0; i3 < query3.getRows().size(); ++i3) {
                ids3[i3] = ((BpmTaskTransRecord)((Object)query3.getRows().get(i3))).getId();
            }
            if (ids3.length > 0) {
                bpmTaskTransRecordManager.removeByIds(ids3);
                BpmTransReceiverManager bpmTransReceiverManager = (BpmTransReceiverManager)AppUtil.getBean(BpmTransReceiverManager.class);
                QueryFilter queryFilter4 = QueryFilter.build();
                queryFilter4.addFilter("TRANS_RECORDID_", (Object)ids3, QueryOP.IN);
                PageList query4 = bpmTransReceiverManager.query(queryFilter4);
                String[] ids4 = new String[query4.getRows().size()];
                for (i = 0; i < query4.getRows().size(); ++i) {
                    ids4[i] = ((BpmTransReceiver)((Object)query4.getRows().get(i))).getId();
                }
                bpmTransReceiverManager.removeByIds(ids4);
            }
            List childsByTaskId = this.bpmTaskManager.getChildsByTaskId(checkOpinion.getTaskId());
            String[] childTaskIds = new String[childsByTaskId.size()];
            for (int i4 = 0; i4 < childsByTaskId.size(); ++i4) {
                childTaskIds[i4] = ((DefaultBpmTask)childsByTaskId.get(i4)).getTaskId();
                DefaultBpmCheckOpinion childOpinion = this.bpmCheckOpinionManager.getByTaskId(childTaskIds[i4]);
                if (!BeanUtils.isNotEmpty((Object)childOpinion)) continue;
                this.bpmCheckOpinionManager.remove((Serializable)((Object)childOpinion.getId()));
            }
            this.bpmTaskManager.delByParentId(checkOpinion.getTaskId());
            this.handleRevokeInquCheckOpinion(task, checkOpinion, cause);
            checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
            checkOpinion.setOpinion("");
            checkOpinion.setFiles("");
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
            if (StringUtil.isNotEmpty((String)taskId)) {
                String id = "";
                list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByTaskId(taskId);
                for (i = 0; i < list1.size(); ++i) {
                    id = ((BpmTaskNotice)list1.get(i)).getId();
                    noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                    bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                    bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                    if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                    if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                        this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                    }
                    bpmTaskNotice.setIsRevoke(Integer.valueOf(1));
                    noticeManager.update((Model)bpmTaskNotice);
                }
            }
            if (StringUtil.isNotEmpty((String)revokeTaskId)) {
                String id = "";
                list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByTaskId(revokeTaskId);
                for (i = 0; i < list1.size(); ++i) {
                    id = ((BpmTaskNotice)list1.get(i)).getId();
                    noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                    bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                    bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                    if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                    if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                        this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                    }
                    bpmTaskNotice.setIsRevoke(Integer.valueOf(1));
                    noticeManager.update((Model)bpmTaskNotice);
                }
            }
            ResultMessage message = new ResultMessage(1, "\u64a4\u56de\u6210\u529f");
            return message;
        }
        if (OpinionStatus.DELIVERTO.getKey().equals(checkOpinion.getStatus())) {
            this.bpmAgentService.retrieveTask(taskId, informType, cause);
            ResultMessage message = new ResultMessage(1, "\u64a4\u56de\u6210\u529f");
            return message;
        }
        if (!type.getKey().equals(NodeType.USERTASK.getKey()) && !type.getKey().equals(NodeType.SIGNTASK.getKey())) {
            throw new BaseException("\u64a4\u56de\u5931\u8d25\uff0c\u975e\uff08\u7528\u6237\u4efb\u52a1\u8282\u70b9\u548c\u4f1a\u7b7e\u8282\u70b9\uff09\u4e0d\u5141\u8bb8\u64a4\u56de");
        }
        Map inGatewayNodeMap = BpmUtil.getInGatewayNodeMap((BpmProcessDef)bpmDefinitionAccessor.getBpmProcessDef(prcoDefId));
        if (inGatewayNodeMap.containsKey(checkOpinion.getTaskKey())) {
            throw new BaseException("\u64a4\u56de\u5931\u8d25\uff0c\u7f51\u5173\u5185\u4e0d\u5141\u8bb8\u64a4\u56de");
        }
        List<DefaultBpmCheckOpinion> listOpinions = new ArrayList();
        boolean backRevoke = false;
        BpmExeStackExecutor stackExecutor = bpmExeStackExecutorManager.getByTaskId(taskId);
        if (("back".equals(instance.getStatus()) || "backToStart".equals(instance.getStatus()) || "revoke".equals(instance.getStatus())) && BeanUtils.isEmpty((Object)stackExecutor)) {
            listOpinions = this.bpmCheckOpinionManager.getByInstNodeIdStatus(instId, revokeNodeId, null);
            backRevoke = true;
            this.restoreStackData(instId, revokeNodeId);
        } else {
            BpmExeStackRelation relation = this.relationManager.getByToStackId(stackExecutor.getStackId());
            if (BeanUtils.isNotEmpty((Object)relation) && !relation.getFromNodeType().equals("userTask") && !NodeType.EXCLUSIVEGATEWAY.getKey().equals(relation.getFromNodeType()) && !relation.getFromNodeType().equals("signTask")) {
                throw new BaseException("\u64a4\u56de\u5931\u8d25\uff0c\u6709\u7f51\u5173\u8282\u70b9\u4e0d\u5141\u8bb8\u64a4\u56de");
            }
            while (NodeType.EXCLUSIVEGATEWAY.getKey().equals(relation.getFromNodeType())) {
                relation = this.relationManager.getByToStackId(relation.getFromStackId());
            }
            listOpinions = this.bpmCheckOpinionManager.getByInstNodeIdAgree(instId, relation.getFromNodeId());
            while (BeanUtils.isEmpty(listOpinions) && BeanUtils.isNotEmpty((Object)relation)) {
                List fromOpinions;
                String fromStackId = relation.getFromStackId();
                String fromNodeId = relation.getFromNodeId();
                if (BeanUtils.isNotEmpty((Object)(relation = this.relationManager.getByToStackId(relation.getFromStackId())))) {
                    listOpinions = this.bpmCheckOpinionManager.getByInstNodeIdAgree(instId, relation.getFromNodeId());
                    continue;
                }
                BpmExeStack stack = (BpmExeStack)this.bpmExeStackManager.get((Serializable)((Object)fromStackId));
                if (!BeanUtils.isNotEmpty((Object)stack) || !"0".equals(stack.getParentId()) || !StringUtil.isNotEmpty((String)fromNodeId) || !BeanUtils.isNotEmpty((Object)(fromOpinions = this.bpmCheckOpinionManager.getByInstNodeId(instId, fromNodeId)))) continue;
                for (DefaultBpmCheckOpinion opinion : fromOpinions) {
                    if (!OpinionStatus.SKIP.getKey().equals(opinion.getStatus())) continue;
                    listOpinions.add(opinion);
                    relation = this.relationManager.getByFromStackId(fromStackId);
                }
            }
            revokeNodeId = relation.getFromNodeId();
        }
        if (nodeId.equals(revokeNodeId)) {
            throw new BaseException(String.format("\u6d41\u7a0b\u5df2\u7ecf\u5728\u3010%s\u3011\u8282\u70b9\uff0c\u65e0\u6cd5\u64a4\u56de\u5230\u6b64\u8282\u70b9", node.getName()));
        }
        boolean isCanRecall = false;
        for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : listOpinions) {
            if (!ContextUtil.getCurrentUser().getUserId().equals(defaultBpmCheckOpinion.getAuditor())) continue;
            isCanRecall = true;
            break;
        }
        if (isCanRecall) {
            BpmIdentity bpmIdentity = DefaultBpmIdentity.getIdentityByUserId((String)ContextUtil.getCurrentUser().getUserId(), (String)ContextUtil.getCurrentUser().getFullname());
            if (StringUtil.isEmpty((String)cause)) {
                cause = "\u64a4\u56de";
            }
            BpmCheckOpinionUtil.updateCheckRevoker((String)revokeTaskId);
            if (node.getType().equals((Object)NodeType.SIGNTASK) && node.getNodeId().equals(revokeNodeId) && ((SignNodeDef)node).isParallel()) {
                String[] addSignUserId = new String[]{ContextUtil.getCurrentUserId()};
                this.signService.addSignTask(taskId, addSignUserId);
            } else {
                BpmTaskNotice bpmTaskNotice;
                BpmTaskNoticeManager noticeManager;
                String id;
                String opinion = StringUtil.isNotEmpty((String)cause) ? cause : OpinionStatus.SIGN_RECOVER_CANCEL.getValue();
                DefaultTaskFinishCmd cmd = this.getCmdFromRecall(taskId, "reject", opinion, "normal", revokeNodeId, bpmIdentity);
                if (!backRevoke) {
                    List listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef((String)instId, (String)nodeId, (String)"pre");
                    if (node.getType().equals((Object)NodeType.SIGNTASK)) {
                        listBpmNodeDef.add(node);
                    }
                    boolean isCanReject = false;
                    List relationList = this.relationManager.getListByProcInstId(instId);
                    for (BpmNodeDef itemNode : listBpmNodeDef) {
                        if (!itemNode.getType().equals((Object)NodeType.USERTASK) && !itemNode.getType().equals((Object)NodeType.SIGNTASK)) continue;
                        boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway((String)instId, (String)node.getNodeId(), (String)"pre", (List)relationList);
                        boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway((String)instId, (String)node.getNodeId(), (String)"after", (List)relationList);
                        isCanReject = (!isHavePre || !isHaveAfter) && revokeNodeId.equals(itemNode.getNodeId());
                        if (!isCanReject) continue;
                        break;
                    }
                    if (!isCanReject) {
                        throw new BaseException("\u64a4\u56de\u5931\u8d25\uff0c\u5f53\u524d\u8282\u70b9\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u64a4\u56de");
                    }
                }
                this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
                instance.setStatus(ProcessInstanceStatus.STATUS_REVOKE.getKey());
                this.bpmProcessInstanceManager.update((Model)instance);
                if (StringUtil.isNotEmpty((String)taskId)) {
                    id = "";
                    List list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByTaskId(taskId);
                    for (int i = 0; i < list1.size(); ++i) {
                        id = ((BpmTaskNotice)list1.get(i)).getId();
                        noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                        bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                        if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                        if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                            this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                        }
                        bpmTaskNotice.setIsRevoke(Integer.valueOf(1));
                        noticeManager.update((Model)bpmTaskNotice);
                    }
                }
                if (StringUtil.isNotEmpty((String)revokeTaskId)) {
                    id = "";
                    List list1 = this.bpmTaskNoticeManager.getBpmTaskNoticeByTaskId(revokeTaskId);
                    for (int i = 0; i < list1.size(); ++i) {
                        id = ((BpmTaskNotice)list1.get(i)).getId();
                        noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                        bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
                        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTaskNotice.getProcDefId());
                        if (bpmTaskNotice.getIsRead() == 1 && "false".equals(bpmDefinition.getIsReadRevoke())) break;
                        if (bpmTaskNotice.getIsRead() == 1 && "true".equals(bpmDefinition.getIsReadRevoke())) {
                            this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneById(id);
                        }
                        bpmTaskNotice.setIsRevoke(Integer.valueOf(1));
                        noticeManager.update((Model)bpmTaskNotice);
                    }
                }
            }
            ResultMessage message = new ResultMessage(1, "\u64a4\u56de\u6210\u529f");
            return message;
        }
        throw new BaseException("\u64a4\u56de\u5931\u8d25\uff0c\u4e0b\u4e2a\u8282\u70b9\u4efb\u52a1\u5df2\u88ab\u5904\u7406\uff0c\u4e0d\u53ef\u64a4\u56de\uff01");
    }

    private void handleRevokeInquCheckOpinion(DefaultBpmTask bpmTask, DefaultBpmCheckOpinion bpmCheckOpinion, String cause) {
        String taskId = bpmCheckOpinion.getTaskId();
        String curUserId = ContextUtil.getCurrentUser().getUserId();
        String curUserName = ContextUtil.getCurrentUser().getFullname();
        BpmCheckOpinionUtil.addCheckOpinion((DefaultBpmTask)bpmTask, (OpinionStatus)OpinionStatus.REVOKER, (String)curUserId, (String)cause, (boolean)true);
        List childrenOpinions = this.bpmCheckOpinionManager.getByParentId(taskId);
        for (DefaultBpmCheckOpinion childOpinion : childrenOpinions) {
            if (!BeanUtils.isNotEmpty((Object)childOpinion)) continue;
            childOpinion.setStatus(OpinionStatus.SIGN_RECOVER_CANCEL.getKey());
            childOpinion.setCompleteTime(LocalDateTime.now());
            childOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)childOpinion.getCreateTime())));
            childOpinion.setOpinion(cause);
            childOpinion.setAuditor(curUserId);
            childOpinion.setAuditorName(curUserName);
            this.bpmCheckOpinionManager.update((Model)childOpinion);
        }
        bpmCheckOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        bpmCheckOpinion.setCreateTime(LocalDateTime.now());
        bpmCheckOpinion.setOpinion("");
        this.bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
    }

    private void restoreStackData(String instId, String revokeNodeId) {
        if (BeanUtils.isNotEmpty((Object)this.bpmExeStackManager.getHisByInstId(instId))) {
            this.bpmExeStackManager.his2StackByInstId(instId);
            this.bpmExeStackManager.his2StackRelationByInstId(instId);
            this.bpmExeStackManager.updateTagertNode(instId, revokeNodeId);
            this.bpmExeStackManager.removeHisByInstId(instId);
            this.relationManager.removeHisByInstId(instId);
        }
    }

    @Override
    public Map<String, List<BpmIdentity>> getNextTaskUsers(String taskId) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(bpmTask.getProcInstId());
        String defId = bpmProcessInstance.getProcDefId();
        String nodeId = bpmTask.getNodeId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List nodes = taskNodeDef.getOutcomeNodes();
        HashMap<String, List<BpmIdentity>> outcomeUserMap = new HashMap<String, List<BpmIdentity>>();
        List<BpmNodeDef> handlerSelectOutcomeNodes = this.handlerSelectOutcomeNodes(nodes);
        for (BpmNodeDef bpmNodeDef : handlerSelectOutcomeNodes) {
            List bpmIdentitys = this.bpmIdentityService.searchByNode(bpmTask.getProcInstId(), bpmNodeDef.getNodeId());
            outcomeUserMap.put(bpmNodeDef.getNodeId(), bpmIdentitys);
        }
        return outcomeUserMap;
    }

    private List<BpmNodeDef> handlerSelectOutcomeNodes(List<BpmNodeDef> outcomeNodes) {
        BpmNodeDef bpmNodeDef;
        NodeType nodeType;
        int size = outcomeNodes.size();
        List<Object> returnList = new ArrayList<BpmNodeDef>();
        if (size == 1 && (NodeType.EXCLUSIVEGATEWAY.equals((Object)(nodeType = (bpmNodeDef = outcomeNodes.get(0)).getType())) || NodeType.INCLUSIVEGATEWAY.equals((Object)nodeType) || NodeType.PARALLELGATEWAY.equals((Object)nodeType))) {
            returnList = bpmNodeDef.getOutcomeNodes();
        }
        if (BeanUtils.isEmpty(returnList)) {
            return outcomeNodes;
        }
        return returnList;
    }

    @Override
    @Transactional
    public CommonResult<String> setTaskExecutors(ModifyExecutorsParamObject modifyExecutorsParamObject) throws Exception {
        String taskId = modifyExecutorsParamObject.getTaskId();
        String[] userIds = modifyExecutorsParamObject.getUserIds();
        String messageType = modifyExecutorsParamObject.getMessageType();
        String opinion = modifyExecutorsParamObject.getCause();
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b\uff01");
        }
        if (BeanUtils.isEmpty((Object)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":userIds\u4efb\u52a1\u6267\u884c\u4ebaid\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)messageType)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":messageType\u901a\u77e5\u65b9\u5f0f\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":cause\u901a\u77e5\u5185\u5bb9\u6bd4\u5fc5\u586b\uff01");
        }
        this.bpmTaskManager.setTaskExecutors(taskId, userIds, messageType, opinion);
        return new CommonResult(true, "\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba\u6210\u529f", (Object)"");
    }

    @Override
    public Boolean isAllowAddSign(IsAllowAddSignObject isAllowAddSignObject) throws Exception {
        Map variables;
        if (StringUtil.isEmpty((String)isAllowAddSignObject.getTaskId())) {
            throw new RuntimeException("taskId\u6ca1\u6709\u8bbe\u7f6e\u503c");
        }
        if (StringUtil.isEmpty((String)isAllowAddSignObject.getUserId()) && StringUtil.isEmpty((String)isAllowAddSignObject.getAccount())) {
            throw new RuntimeException("\u7528\u6237id\u6216\u8005\u7528\u6237\u8d26\u53f7\u4e24\u8005\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        String userId = "";
        if (StringUtil.isNotEmpty((String)isAllowAddSignObject.getUserId())) {
            userId = isAllowAddSignObject.getUserId();
        } else {
            IUser user = ServiceUtil.getUserByAccount((String)isAllowAddSignObject.getAccount());
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            userId = user.getUserId();
        }
        String taskId = isAllowAddSignObject.getTaskId();
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (!(bpmNodeDef instanceof SignNodeDef)) {
            throw new RuntimeException("\u8be5\u4efb\u52a1\u4e0d\u662f\u4f1a\u7b7e\u4efb\u52a1");
        }
        NatTaskService natTaskService = (NatTaskService)AppUtil.getBean(NatTaskService.class);
        SignService signService = (SignService)AppUtil.getBean(SignService.class);
        List privilege = signService.getPrivilege(userId, (SignNodeDef)bpmNodeDef, variables = natTaskService.getVariables(taskId));
        if (privilege.contains(PrivilegeMode.ALL) || privilege.contains(PrivilegeMode.ALLOW_ADD_SIGN)) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public CommonResult<String> taskToTrans(TaskTransParamObject taskTransParamObject) throws Exception {
        BpmProcessDef bpmProcessDef;
        BpmProcessDefExt processDefExt;
        List boDefList;
        String notifyType = taskTransParamObject.getNotifyType();
        String opinion = taskTransParamObject.getOpinion();
        String userIds = taskTransParamObject.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        String formData = taskTransParamObject.getData();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":userIds\u6d41\u8f6c\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u6d41\u8f6c\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            throw new RuntimeException("\u6d41\u8f6c\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba\uff01");
        }
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        if (BeanUtils.isEmpty((Object)defaultBpmTask)) {
            throw new NotFoundException("\u4efb\u52a1\u4e0d\u5b58\u5728\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u4e86");
        }
        String procInstId = defaultBpmTask.getProcInstId();
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        this.bpmProcessInstanceManager.updateStatusByInstanceId(procInstId, ProcessInstanceStatus.STATUS_RUNNING.getKey());
        String busData = Base64.getFromBase64((String)formData);
        if (StringUtil.isNotEmpty((String)formData) && BeanUtils.isNotEmpty((Object)(boDefList = (processDefExt = (bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defaultBpmTask.getProcDefId())).getProcessDefExt()).getBoDefList()))) {
            DefaultProcessInstCmd processCmd = new DefaultProcessInstCmd();
            processCmd.setBusData(busData);
            BusDataUtil.handSaveBoData((BpmProcessInstance)defaultBpmProcessInstance, (ActionCmd)processCmd);
        }
        String files = taskTransParamObject.getFiles();
        this.taskTransService.addTransTask(taskTrans, userList, notifyType, opinion, formData, files, false);
        return new CommonResult(true, "\u6d41\u7a0b\u6d41\u8f6c\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> userTaskToSign(TaskTransParamObject taskTransParamObject) throws Exception {
        BpmTask pendingTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTransParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)pendingTask)) {
            return new CommonResult(false, "\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff01");
        }
        taskTransParamObject.setTaskId(pendingTask.getTaskId());
        String notifyType = taskTransParamObject.getNotifyType();
        String opinion = taskTransParamObject.getOpinion();
        String userIds = taskTransParamObject.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR + ":userIds\u52a0\u7b7e\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u52a0\u7b7e\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            return new CommonResult(false, "\u52a0\u7b7e\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba", (Object)"");
        }
        if (userList.size() > 1) {
            taskTransParamObject.setDecideType("agree");
            taskTransParamObject.setNotifyType("inner");
            taskTransParamObject.setSignType("parallel");
            taskTransParamObject.setVoteAmount(Short.valueOf("100"));
            taskTransParamObject.setVoteType("percent");
        }
        String files = taskTransParamObject.getFiles();
        taskTransParamObject.setVoteType(null);
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        this.taskTransService.addTransTask(taskTrans, userList, notifyType, opinion, files);
        return new CommonResult(true, "\u52a0\u7b7e\u6210\u529f", (Object)"");
    }

    @Override
    public String getUrlFormByTaskId(String taskId, String formType) throws Exception {
        DefaultBpmTask task = this.bpmTaskManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.fromValue((String)formType));
        FormModel formModel = bpmFormService.getByDefId(defId, nodeId, bpmProcessInstance, true);
        if (formModel == null || formModel.isFormEmpty() || FormCategory.INNER.equals((Object)formModel.getType())) {
            return "";
        }
        return formModel.getFormValue();
    }

    @Override
    public String getInstUrlForm(String proInstId, String nodeId, String formType) throws Exception {
        DefaultBpmProcessInstance instance;
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.fromValue((String)formType));
        FormModel formModel = bpmFormService.getInstFormByDefId((BpmProcessInstance)(instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId))));
        if (BeanUtils.isNotEmpty((Object)formModel) && StringUtil.isNotEmpty((String)formModel.getFormId())) {
            FormModel formModelTmp;
            if (StringUtil.isNotEmpty((String)nodeId) && (formModelTmp = bpmFormService.getByDefId(instance.getProcDefId(), nodeId, (BpmProcessInstance)instance, false)) != null && !formModelTmp.isFormEmpty()) {
                formModel = formModelTmp;
            }
            if (formModel == null || formModel.isFormEmpty() || FormCategory.INNER.equals((Object)formModel.getType())) {
                return "";
            }
        }
        return formModel.getFormValue();
    }

    @Override
    @Transactional
    public CommonResult<String> communicate(CommunicateParamObject communicateParamObject) throws Exception {
        String curid = ContextUtil.getCurrentUserId();
        String instId = communicateParamObject.getInstId();
        String defId = communicateParamObject.getDefId();
        if (StringUtil.isEmpty((String)instId)) {
            return new CommonResult(false, "\u6d41\u7a0b\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userIds = communicateParamObject.getUserId();
        String communicateReason = communicateParamObject.getOpinion();
        String messageType = communicateParamObject.getMessageType();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new ApproveTaskException("\u5fc5\u987b\u4f20\u5165\u6c9f\u901a\u7528\u6237id");
        }
        String[] userIdAry = userIds.split(",");
        ArrayList<IUser> userIdList = new ArrayList<IUser>();
        for (String userId : userIdAry) {
            if (curid.equals(userId)) {
                return new CommonResult(false, "\u4e0d\u80fd\u5bf9\u81ea\u5df1\u53d1\u8d77\u6c9f\u901a");
            }
            IUser userByAccount = ServiceUtil.getUserById((String)userId);
            if (BeanUtils.isEmpty((Object)userByAccount)) {
                throw new RuntimeException(String.format("\u6c9f\u901a\u7528\u6237\u8d26\u53f7(userAccount):%s\u4e0d\u5b58\u5728", userId));
            }
            userIdList.add(userByAccount);
        }
        this.taskCommuService.addCommuTask(instId, messageType, communicateReason, userIdList, communicateParamObject.getFiles(), defId);
        return new CommonResult(true, "\u6c9f\u901a\u6210\u529f");
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getMyRequestListAll(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        queryFilter.withQuery(new QueryField("create_by_", (Object)user.getUserId(), QueryOP.EQUAL));
        queryFilter.withQuery(new QueryField("status_", (Object)"draft", QueryOP.NOT_EQUAL));
        try {
            PageList list = this.bpmProcessInstanceManager.query(queryFilter);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    public PageList<DefaultBpmDefinition> getBpmDefList(String account, QueryFilter queryFilter) throws Exception {
        return this.bpmDefinitionManager.query(queryFilter);
    }

    @Override
    public PageList<DefaultBpmDefinition> newProcess(String account, QueryFilter queryFilter) throws Exception {
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.addFilter("status_", (Object)"deploy", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.getParams().put("bpmDefAuthorizeRightType", "start");
        return this.bpmDefinitionManager.queryList(queryFilter);
    }

    @Override
    public List<Map<String, Object>> newProcessCount(QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.addFilter("status_", (Object)"deploy", QueryOP.EQUAL, FieldRelation.AND, "a");
        queryFilter.getParams().put("bpmDefAuthorizeRightType", "start");
        return this.bpmDefinitionManager.getDefCount(queryFilter);
    }

    @Override
    public PageList<DefaultBpmProcessInstance> myRequest(String account, QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql")) {
            this.StringToTimestamp(queryFilter);
        }
        IPage list = this.bpmProcessInstanceManager.getMyRequestByUserId(user.getUserId(), queryFilter);
        PageList pageList = new PageList(list);
        ArrayList<DefaultBpmProcessInstance> listInst = new ArrayList<DefaultBpmProcessInstance>();
        for (DefaultBpmProcessInstance entity : pageList.getRows()) {
            TaskjImageVo taskNode;
            DefaultBpmProcessInstance defaultBpmProcessInstance = new DefaultBpmProcessInstance();
            defaultBpmProcessInstance = entity;
            if ("back".equals(entity.getStatus()) && BeanUtils.isNotEmpty((Object)(taskNode = this.taskImage("", entity.getProcDefId())))) {
                List listLayout = taskNode.getBpmDefLayout().getListLayout();
                List listStr = this.bpmProcessInstanceManager.getNodeIdByInstId(entity.getId());
                if (BeanUtils.isNotEmpty((Object)listStr) && ((BpmNodeLayout)listLayout.get(1)).getNodeId().equals(listStr.get(0))) {
                    defaultBpmProcessInstance.setBackToStart(Boolean.valueOf(true));
                }
            }
            listInst.add(defaultBpmProcessInstance);
        }
        pageList.setRows(listInst);
        return pageList;
    }

    @Override
    public List<Map<String, Object>> myRequestCount(String account) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        return this.bpmProcessInstanceManager.getMyRequestCount(user.getUserId());
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getInstanceList(String account, QueryFilter queryFilter) throws Exception {
        queryFilter.setDefaultSort("createTime", Direction.DESC);
        return this.bpmProcessInstanceManager.query(queryFilter);
    }

    @Override
    public InstFormAndBoVo getInstFormAndBO(String proInstId, String nodeId, String formId, FormType formType, Boolean includData, Boolean getStartForm) throws Exception {
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)formType);
        InstFormAndBoVo instFormAndBoVo = new InstFormAndBoVo();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId));
        if (StringUtil.isNotEmpty((String)nodeId)) {
            ContextThreadUtil.putCommonVars((String)"nodeId", (Object)nodeId);
            ContextThreadUtil.putCommonVars((String)"defId", (Object)instance.getProcDefId());
        }
        BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance((BpmProcessInstance)instance);
        String topDefKey = "";
        if (StringUtil.isNotZeroEmpty((String)topInstance.getParentInstId())) {
            topDefKey = topInstance.getProcDefKey();
        }
        FormModel formModel = null;
        if (!getStartForm.booleanValue()) {
            formModel = bpmFormService.getByDefId(instance.getProcDefId(), nodeId, (BpmProcessInstance)instance, false);
        }
        if (BeanUtils.isEmpty(formModel) && ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance.getStatus()) || getStartForm.booleanValue()) {
            BpmNodeForm nodeForm = null;
            nodeForm = bpmFormService.getByDefId(instance.getProcDefId());
            formModel = (FormModel)nodeForm.getForm();
        }
        if (BeanUtils.isNotEmpty((Object)formModel) && (StringUtil.isNotEmpty((String)formModel.getFormId()) || StringUtil.isNotEmpty((String)formModel.getFormValue()))) {
            FormModel formModelTmp;
            if (StringUtil.isNotEmpty((String)nodeId) && (formModelTmp = bpmFormService.getByDefId(instance.getProcDefId(), nodeId, (BpmProcessInstance)instance, false)) != null && !formModelTmp.isFormEmpty()) {
                formModel = formModelTmp;
            }
            if (formModel == null || formModel.isFormEmpty()) {
                instFormAndBoVo.setResult("formEmpty");
                return instFormAndBoVo;
            }
            if (StringUtil.isNotEmpty((String)formId)) {
                this.checkPrintForm(formModel, formId);
            }
            instFormAndBoVo.setForm(formModel);
            if (FormCategory.INNER.equals((Object)formModel.getType())) {
                BpmProcessDef procDef = this.bpmDefinitionAccessor.getBpmProcessDef(topInstance.getProcDefId());
                String doneDataVersion = procDef.getProcessDefExt().getExtProperties().getDoneDataVersion();
                instFormAndBoVo.setDoneDataVersion(StringUtil.isEmpty((String)doneDataVersion) ? "history" : doneDataVersion);
                String curUserId = ContextUtil.getCurrentUserId();
                ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
                formRestParams.put("formkey", formModel.getFormKey());
                formRestParams.put("userId", curUserId);
                formRestParams.put("parentFlowKey", topDefKey);
                formRestParams.put("flowKey", topInstance.getProcDefKey());
                String permission = "";
                formRestParams.put("nodeId", formModel.getNodeId());
                permission = this.formRestfulService.getPermission(formRestParams);
                ContextThreadUtil.putCommonVars((String)"formPermission", (Object)permission);
                if (includData.booleanValue()) {
                    List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)instance);
                    ObjectNode jsondata = (ObjectNode)BoDataUtil.hanlerData((List)boDatas);
                    instFormAndBoVo.setData(jsondata);
                    ObjectNode opinionJson = this.boDataService.getFormOpinionJson(proInstId);
                    instFormAndBoVo.setOpinionList(opinionJson);
                }
                instFormAndBoVo.setPermission(permission);
            }
        }
        return instFormAndBoVo;
    }

    private void checkPrintForm(FormModel formModel, String formId) throws Exception {
        String formStr;
        ObjectNode byFormKey = this.formService.getByFormId(formId);
        if (BeanUtils.isNotEmpty((Object)byFormKey) && BeanUtils.isNotEmpty((Object)(formStr = byFormKey.toString()))) {
            BpmForm bpmForm = (BpmForm)JsonUtil.toBean((String)formStr, BpmForm.class);
            formModel.setFormHtml(bpmForm.getFormHtml());
            formModel.setFormKey(bpmForm.getFormKey());
            formModel.setFormId(bpmForm.getFormId());
        }
    }

    @Override
    public FormAndBoVo getFormAndBO(StartCmdParam startCmdParam, FormType formType) throws Exception {
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)formType);
        FormAndBoVo formAndBoVo = new FormAndBoVo();
        DefaultBpmProcessInstance proInstance = null;
        BpmNodeForm nodeForm = null;
        if (StringUtil.isEmpty((String)startCmdParam.getProInstId())) {
            nodeForm = bpmFormService.getByDefId(startCmdParam.getDefId());
        } else {
            proInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)startCmdParam.getProInstId()));
            nodeForm = bpmFormService.getByDraft((BpmProcessInstance)proInstance);
        }
        if (nodeForm == null) {
            formAndBoVo.setResultMsg("formEmpty");
            return formAndBoVo;
        }
        if (StringUtil.isEmpty((String)startCmdParam.getDefId())) {
            startCmdParam.setDefId(proInstance.getProcDefId());
        }
        FormModel formModel = (FormModel)nodeForm.getForm();
        formAndBoVo.setForm(formModel);
        BpmNodeDef bpmNodeDef = nodeForm.getBpmNodeDef();
        List buttons = BpmUtil.getButtons((BpmNodeDef)bpmNodeDef);
        formAndBoVo.setButtons(buttons);
        if (FormCategory.INNER.equals((Object)formModel.getType())) {
            ObjectNode jsondata = JsonUtil.getMapper().createObjectNode();
            DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
            cmd.setVariables(this.getStartCmd(startCmdParam).getVariables());
            ContextThreadUtil.setActionCmd((ActionCmd)cmd);
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("formkey", formModel.getFormKey());
            formRestParams.put("flowKey", bpmNodeDef.getBpmProcessDef().getDefKey());
            formRestParams.put("nodeId", formModel.getNodeId());
            String permission = this.formRestfulService.getStartPermission(formRestParams);
            ContextThreadUtil.putCommonVars((String)"formPermission", (Object)permission);
            if (StringUtil.isNotEmpty((String)startCmdParam.getProInstId())) {
                List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)proInstance);
                jsondata = ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(proInstance.getStatus()) ? BoDataUtil.hanlerData((String)startCmdParam.getDefId(), (List)boDatas, (boolean)false) : BoDataUtil.hanlerData((String)"", (List)boDatas, (boolean)false);
            } else if (StringUtil.isNotEmpty((String)startCmdParam.getCopyInstId())) {
                DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)startCmdParam.getCopyInstId()));
                List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)defaultBpmProcessInstance);
                boDatas = BoDataUtil.emptyFkAndPk((List)boDatas);
                jsondata = BoDataUtil.hanlerData((String)startCmdParam.getDefId(), (List)boDatas, (boolean)true);
            } else {
                List boDatas = this.boDataService.getDataByDefId(startCmdParam.getDefId());
                jsondata = BoDataUtil.hanlerData((String)startCmdParam.getDefId(), (List)boDatas, (boolean)true);
            }
            formAndBoVo.setData(jsondata);
            formAndBoVo.setPermission(permission);
        }
        BpmNodeDef startEvent = this.bpmDefinitionAccessor.getStartEvent(startCmdParam.getDefId());
        NodeProperties startNodeProp = startEvent.getLocalProperties();
        formAndBoVo.setJumpType(startNodeProp.getJumpType());
        return formAndBoVo;
    }

    @Override
    public DefaultProcessInstCmd getStartCmd(StartCmdParam startCmdParam) throws Exception {
        String proInstId = startCmdParam.getProInstId();
        String defId = startCmdParam.getDefId();
        int isSendNodeUsers = startCmdParam.getIsSendNodeUsers();
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        String defKey = bpmDefinition.getDefKey();
        String destination = startCmdParam.getDestination();
        String nodeUsers = startCmdParam.getNodeUsers();
        String busData = startCmdParam.getBusData();
        String formType = startCmdParam.getFormType();
        Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
        DefaultProcessInstCmd cmd = new DefaultProcessInstCmd();
        cmd.setFlowKey(defKey);
        if (StringUtil.isNotEmpty((String)proInstId)) {
            cmd.setInstId(proInstId);
        }
        cmd.setDestination(destination);
        cmd.setBusData(busData);
        if (FormCategory.INNER.value().equals(formType)) {
            cmd.setDataMode("bo");
        } else {
            cmd.setDataMode("pk");
        }
        if (BeanUtils.isNotEmpty((Object)specUserMap)) {
            cmd.addTransitVars("bpm_node_users_", (Object)specUserMap);
            if (isSendNodeUsers == 1) {
                cmd.setBpmIdentities(specUserMap);
            }
        }
        Map<String, Object> params = this.getProcessStartVars(startCmdParam.getReqValue(), defId);
        cmd.setVariables(params);
        cmd.addVariable("processDefId_", defId);
        cmd.addVariable("flowKey_", defKey);
        cmd.addVariable("startUser", ContextUtil.getCurrentUserId());
        return cmd;
    }

    private Map<String, Object> getProcessStartVars(String reqParams, String defId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List list = this.bpmDefinitionService.getVariableDefs(defId);
        if (BeanUtils.isEmpty((Object)list)) {
            return params;
        }
        for (BpmVariableDef varDef : list) {
            if (BeanUtils.isEmpty((Object)reqParams)) {
                return params;
            }
            String reqValue = JsonUtil.toJsonNode((String)reqParams).get(varDef.getVarKey()).asText();
            if (StringUtil.isEmpty((String)reqValue) && varDef.getDefaultVal() != null && StringUtil.isNotEmpty((String)varDef.getDefaultVal().toString())) {
                reqValue = varDef.getDefaultVal().toString();
            }
            if (!StringUtil.isNotEmpty((String)reqValue)) continue;
            Object convertVal = DefaultBpmVariableDef.getValue((String)varDef.getDataType(), (String)reqValue);
            params.put(varDef.getVarKey(), convertVal);
        }
        return params;
    }

    @Override
    public SelectDestinationVo selectDestination(String defId) throws Exception {
        BpmNodeDef startEvent = this.bpmDefinitionAccessor.getStartEvent(defId);
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, startEvent.getNodeId());
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        boolean isSkipFirstNode = bpmProcessDef.getProcessDefExt().getExtProperties().isSkipFirstNode();
        String jumpType = "common";
        SelectDestinationVo selectDestinationVo = new SelectDestinationVo();
        if (nodeProperties != null) {
            jumpType = nodeProperties.getJumpType();
            if (jumpType.indexOf("select") > -1) {
                HashMap<String, List> outcomeUserMap = new HashMap<String, List>();
                if (isSkipFirstNode) {
                    taskNodeDef = (BpmNodeDef)taskNodeDef.getOutcomeNodes().get(0);
                }
                List outcomeNodes = taskNodeDef.getOutcomeNodes();
                List<BpmNodeDef> handlerSelectOutcomeNodes = this.handlerSelectOutcomeNodes(outcomeNodes);
                for (BpmNodeDef bpmNodeDef : handlerSelectOutcomeNodes) {
                    List bpmIdentitys = this.bpmIdentityService.searchByNodeIdOnStartEvent(defId, bpmNodeDef.getNodeId());
                    outcomeUserMap.put(bpmNodeDef.getNodeId(), this.bpmIdentityExtractService.extractBpmIdentity(bpmIdentitys));
                }
                selectDestinationVo.setOutcomeUserMap(outcomeUserMap);
                selectDestinationVo.setOutcomeNodes(handlerSelectOutcomeNodes);
            }
            if (jumpType.indexOf("free") > -1) {
                List<BpmNodeDef> allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(defId);
                allNodeDef = this.handlerSelectOutcomeNodes(allNodeDef);
                ArrayList<BpmNodeDef> removeList = new ArrayList<BpmNodeDef>();
                HashMap allNodeUserMap = new HashMap();
                for (BpmNodeDef bpmNodeDef : allNodeDef) {
                    NodeType type = bpmNodeDef.getType();
                    if (NodeType.START.equals((Object)type) || NodeType.EXCLUSIVEGATEWAY.equals((Object)type) || NodeType.PARALLELGATEWAY.equals((Object)type) || NodeType.END.equals((Object)type)) {
                        removeList.add(bpmNodeDef);
                        continue;
                    }
                    if (!NodeType.USERTASK.equals((Object)bpmNodeDef.getType()) && !NodeType.SIGNTASK.equals((Object)bpmNodeDef.getType())) continue;
                    ArrayList bpmIdentitys = new ArrayList();
                    allNodeUserMap.put(bpmNodeDef.getNodeId(), bpmIdentitys);
                }
                allNodeDef.removeAll(removeList);
                selectDestinationVo.setAllNodeDef(allNodeDef);
                selectDestinationVo.setAllNodeUserMap(allNodeUserMap);
            }
        }
        selectDestinationVo.setJumpType(jumpType);
        return selectDestinationVo;
    }

    @Override
    public FlowImageVo flowImage(String instanceId, String type, String from, String nodeId, String defId) throws Exception {
        FlowImageVo flowImageVo = new FlowImageVo();
        if (StringUtil.isEmpty((String)instanceId) && StringUtil.isEmpty((String)defId)) {
            return flowImageVo;
        }
        BpmProcessInstance bpmProcessInstance = null;
        List<BpmProcessInstance> bpmProcessInstanceList = new ArrayList<BpmProcessInstance>();
        BpmDefLayout bpmDefLayout = null;
        if ("subFlow".equals(type)) {
            String subDefId = "";
            if (StringUtil.isNotEmpty((String)instanceId) && BeanUtils.isEmpty(bpmProcessInstanceList = this.bpmProcessInstanceManager.getBpmProcessByParentIdAndSuperNodeId(instanceId, nodeId))) {
                bpmProcessInstanceList = this.bpmProcessInstanceManager.getHiBpmProcessByParentIdAndSuperNodeId(instanceId, nodeId);
            }
            if (BeanUtils.isNotEmpty(bpmProcessInstanceList) && bpmProcessInstanceList.size() > 0) {
                bpmProcessInstance = (BpmProcessInstance)bpmProcessInstanceList.get(0);
                instanceId = bpmProcessInstance.getId();
                subDefId = bpmProcessInstance.getProcDefId();
            } else {
                if (StringUtil.isEmpty((String)defId)) {
                    BpmProcessInstance parentBpmProcessInstance = this.bpmInstService.getProcessInstance(instanceId);
                    defId = parentBpmProcessInstance.getProcDefId();
                }
                instanceId = "";
                CallActivityNodeDef bpmNodeDef = (CallActivityNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
                String folowKey = bpmNodeDef.getFlowKey();
                DefaultBpmDefinition def = this.bpmDefinitionManager.getMainByDefKey(folowKey, false);
                subDefId = def.getDefId();
            }
            bpmDefLayout = this.diagramService.getLayoutByDefId(subDefId);
            flowImageVo.setDefId(subDefId);
        } else {
            if (StringUtil.isEmpty((String)defId)) {
                bpmProcessInstance = this.bpmInstService.getProcessInstance(instanceId);
                bpmProcessInstanceList.add(bpmProcessInstance);
                defId = bpmProcessInstance.getProcDefId();
            }
            bpmDefLayout = this.diagramService.getLayoutByDefId(defId);
            flowImageVo.setDefId(defId);
        }
        flowImageVo.setBpmProcessInstance(bpmProcessInstance);
        flowImageVo.setInstanceId(instanceId);
        flowImageVo.setBpmProcessInstanceList(bpmProcessInstanceList);
        if (BeanUtils.isNotEmpty((Object)bpmProcessInstance)) {
            flowImageVo.setParentInstId(bpmProcessInstance.getParentInstId());
        }
        flowImageVo.setBpmDefLayout(bpmDefLayout);
        flowImageVo.setFrom(from);
        return flowImageVo;
    }

    @Override
    public List<ObjectNode> opinionHistory(String instId, String taskId) throws Exception {
        if ((instId == null || instId.isEmpty()) && taskId != null) {
            instId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(instId);
        ArrayList llist = new ArrayList();
        ArrayList<BpmTaskOpinion> list = null;
        String preKey = "";
        for (BpmTaskOpinion bto : bpmTaskOpinions) {
            if (StringUtil.isNotEmpty((String)bto.getTaskKey()) && !bto.getTaskKey().equals(preKey)) {
                list = new ArrayList<BpmTaskOpinion>();
                llist.add(list);
                preKey = bto.getTaskKey();
            }
            list.add(bto);
        }
        ArrayList<ObjectNode> opinionList = new ArrayList<ObjectNode>();
        for (List list2 : llist) {
            for (int i = 0; i < list2.size(); ++i) {
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(list2.get(i));
                if (i == 0) {
                    obj.put("isRowSpan", true);
                    obj.put("rowSpan", list2.size());
                }
                opinionList.add(obj);
            }
        }
        return opinionList;
    }

    @Override
    @Transactional
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<TaskDoNextVo> taskDoNext(String taskId) throws Exception {
        Object jsonObj;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        TaskDoNextVo taskDoNextVo = new TaskDoNextVo();
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && (jsonObj = null) == null && !ContextUtil.getCurrentUserId().equals(task.getAssigneeId())) {
            throw new RuntimeException("\u6ca1\u6709\u5904\u7406\u6b64\u4efb\u52a1\u7684\u6743\u9650!");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        NodeProperties nodeProperties = BpmUtil.getNodeProperties((BpmProcessInstance)bpmProcessInstance, (String)task.getNodeId());
        boolean isPopWin = nodeProperties.isPopWin();
        taskDoNextVo.setNodeId(StringUtil.join(Arrays.asList(task.getProcDefKey(), task.getNodeId()), (String)"_"));
        taskDoNextVo.setTaskId(taskId);
        taskDoNextVo.setPopWin(isPopWin);
        return CompletableFuture.completedFuture(taskDoNextVo);
    }

    @Override
    @Transactional
    public TaskDoNextVo taskApprove(String taskId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        if (isForbindden) {
            throw new RuntimeException("\u6d41\u7a0b\u5df2\u7ecf\u88ab\u7981\u6b62\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        TaskDoNextVo taskDoNextVo = new TaskDoNextVo();
        int rtn = this.bpmTaskManager.canLockTask(taskId);
        if (rtn == 4) {
            throw new RuntimeException("\u6b64\u4efb\u52a1\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a!");
        }
        this.validTask(taskId);
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        NodeProperties nodeProperties = BpmUtil.getNodeProperties((BpmProcessInstance)bpmProcessInstance, (String)task.getNodeId());
        boolean isPopWin = nodeProperties.isPopWin();
        taskDoNextVo.setNodeId(StringUtil.join(Arrays.asList(task.getProcDefKey(), task.getNodeId()), (String)"_"));
        taskDoNextVo.setTaskId(taskId);
        taskDoNextVo.setPopWin(isPopWin);
        return taskDoNextVo;
    }

    private void validTask(String taskId) throws Exception {
        IUser defaultUser = ContextUtil.getCurrentUser();
        if (defaultUser.isAdmin()) {
            return;
        }
        boolean mark = false;
        List users = this.bpmTaskService.getUsersByTaskId(taskId);
        String userId = ContextUtil.getCurrentUserId();
        for (IUser user : users) {
            if (!userId.equals(user.getUserId())) continue;
            mark = true;
            break;
        }
        if (!mark) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u6267\u884c\u8be5\u64cd\u4f5c\u7684\u6743\u9650.");
        }
    }

    @Override
    public TaskjImageVo taskImage(String taskId, String defId) throws Exception {
        String parentInstId = "";
        String procDefId = "";
        String instId = "";
        if (StringUtil.isNotEmpty((String)taskId)) {
            DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
            parentInstId = bpmProcessInstance.getParentInstId();
            procDefId = bpmProcessInstance.getProcDefId();
            instId = bpmProcessInstance.getId();
        } else if (StringUtil.isNotEmpty((String)defId)) {
            procDefId = defId;
        }
        BpmDefLayout bpmDefLayout = this.diagramService.getLayoutByDefId(procDefId);
        return new TaskjImageVo(taskId, bpmDefLayout, instId, parentInstId);
    }

    @Override
    public Object nodeOpinion(String defId, String instId, String nodeId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List opinionList = null;
        if (StringUtil.isNotEmpty((String)instId)) {
            opinionList = this.bpmOpinionService.getByInstNodeId(instId, nodeId);
            if (BeanUtils.isNotEmpty((Object)opinionList)) {
                for (BpmTaskOpinion bpmTaskOpinion : opinionList) {
                    String qualfieds = bpmTaskOpinion.getQualfieds();
                    if (StringUtil.isEmpty((String)qualfieds)) continue;
                    ArrayNode qualfiedsObj = null;
                    try {
                        qualfiedsObj = (ArrayNode)JsonUtil.toJsonNode((String)qualfieds);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    DefaultBpmCheckOpinion defaultBpmCheckOpinion = (DefaultBpmCheckOpinion)bpmTaskOpinion;
                    for (JsonNode jsonNode : qualfiedsObj) {
                        ObjectNode identityObj = (ObjectNode)jsonNode;
                        DefaultBpmIdentity identity = (DefaultBpmIdentity)JsonUtil.toBean((JsonNode)identityObj, DefaultBpmIdentity.class);
                        if ("user".equals(identity.getType())) continue;
                        ArrayList<DefaultBpmIdentity> tempList = new ArrayList<DefaultBpmIdentity>();
                        tempList.add(identity);
                        List extractUser = this.bpmIdentityExtractService.extractUser(tempList);
                        if (!BeanUtils.isNotEmpty((Object)extractUser)) continue;
                        ArrayList<String> userNames = new ArrayList<String>();
                        for (IUser iUser : extractUser) {
                            userNames.add(iUser.getFullname());
                        }
                        identityObj.put("users", StringUtil.join(userNames, (String)","));
                    }
                    defaultBpmCheckOpinion.setQualfieds(JsonUtil.toJson((Object)qualfiedsObj));
                }
                map.put("hasOpinion", true);
                map.put("data", opinionList);
                return map;
            }
            map.put("hasOpinion", false);
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if ("end".equals(instance.getStatus()) || "draft".equals(instance.getStatus())) {
                return map;
            }
        }
        map.put("hasOpinion", false);
        List userList = new ArrayList();
        try {
            userList = StringUtil.isEmpty((String)instId) ? this.bpmIdentityService.searchByNodeIdOnStartEvent(defId, nodeId) : this.bpmIdentityService.searchByNode(instId, nodeId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (userList.size() > 0) {
            ArrayList list = new ArrayList();
            for (BpmIdentity identity : userList) {
                String type;
                HashMap<String, String> identityMap = new HashMap<String, String>();
                identityMap.put("id", identity.getId());
                identityMap.put("name", identity.getName());
                String string = type = identity.getType().equals("user") ? "user" : identity.getGroupType();
                if (!"user".equals(type)) {
                    ArrayList<BpmIdentity> tempList = new ArrayList<BpmIdentity>();
                    tempList.add(identity);
                    List extractUser = this.bpmIdentityExtractService.extractUser(tempList);
                    if (BeanUtils.isNotEmpty((Object)extractUser)) {
                        ArrayList<String> userNames = new ArrayList<String>();
                        for (IUser iUser : extractUser) {
                            userNames.add(iUser.getFullname());
                        }
                        identityMap.put("users", StringUtil.join(userNames, (String)","));
                    }
                }
                identityMap.put("type", type);
                list.add(identityMap);
            }
            map.put("data", list);
        }
        return map;
    }

    @Override
    public TaskDetailVo getButtonsBytaskId(String taskId) throws Exception {
        TaskDetailVo taskDetailVo = new TaskDetailVo();
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        List bodatas = this.boDataService.getDataByInst(bpmProcessInstance);
        BpmContextUtil.setBoToContext((List)bodatas);
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u4e86.");
        }
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List buttons = null;
        if (BeanUtils.isNotEmpty((Object)taskNodeDef)) {
            buttons = BpmUtil.getButtons((BpmNodeDef)taskNodeDef, (DefaultBpmTask)task);
        }
        if (BeanUtils.isNotEmpty(buttons)) {
            this.handButtons(buttons, task.getTaskId());
            taskDetailVo.setButtons(buttons);
        }
        return taskDetailVo;
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<TaskDetailVo> taskDetail(String taskId, String reqValue, FormType formType, String leaderId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u4e86.");
        }
        Boolean hasPermTodo = false;
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            throw new RuntimeException("\u8bf7\u5148\u767b\u5f55\u7cfb\u7edf");
        }
        if (StringUtil.isNotEmpty((String)leaderId)) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId);
        }
        if (currentUser.isAdmin()) {
            hasPermTodo = true;
        } else {
            List recievers = new ArrayList();
            List queryByBpmTask = this.bpmIdentityService.queryListByBpmTask((BpmTask)task);
            recievers = this.bpmIdentityExtractService.extractUser(queryByBpmTask);
            if (BeanUtils.isNotEmpty(recievers)) {
                for (IUser iUser : recievers) {
                    if (!currentUser.getUserId().equals(iUser.getUserId()) && !leaderId.equals(iUser.getUserId())) continue;
                    hasPermTodo = true;
                    break;
                }
            }
        }
        if (!hasPermTodo.booleanValue() && !(hasPermTodo = Boolean.valueOf(this.isInRightMap(task.getProcDefKey(), task.getProcInstId()))).booleanValue()) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u8be5\u4efb\u52a1\u7684\u5904\u7406\u6743\u9650");
        }
        TaskDetailVo taskDetailVo = new TaskDetailVo();
        String topDefKey = "";
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        if (StringUtil.isNotZeroEmpty((String)bpmProcessInstance.getParentInstId())) {
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(bpmProcessInstance);
            topDefKey = topInstance.getProcDefKey();
        }
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)formType);
        FormModel formModel = bpmFormService.getByDefId(defId, nodeId, bpmProcessInstance, true);
        if (formModel == null || formModel.isFormEmpty()) {
            taskDetailVo.setResult("formEmpty");
            return CompletableFuture.completedFuture(taskDetailVo);
        }
        taskDetailVo.setForm(formModel);
        if (FormCategory.INNER.value().equals(formModel.getType().value())) {
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("formkey", formModel.getFormKey());
            formRestParams.put("flowKey", task.getProcDefKey());
            formRestParams.put("nodeId", formModel.getNodeId());
            formRestParams.put("parentFlowKey", topDefKey);
            String permission = this.formRestfulService.getPermission(formRestParams);
            taskDetailVo.setPermission(permission);
            ContextThreadUtil.putCommonVars((String)"nodeId", (Object)nodeId);
            ContextThreadUtil.putCommonVars((String)"defId", (Object)defId);
            ContextThreadUtil.putCommonVars((String)"formPermission", (Object)permission);
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            if (!"FOLLOW".equals(task.getStatus())) {
                DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
                cmd.setVariables(this.getTaskVars(taskId, null));
                ContextThreadUtil.setActionCmd((ActionCmd)cmd);
            }
            ObjectNode data = BoDataUtil.hanlerData((BpmProcessInstance)bpmProcessInstance, (String)nodeId, (List)boDatas);
            taskDetailVo.setData(data);
            ObjectNode opinionJson = this.boDataService.getFormOpinionJson(task.getProcInstId());
            taskDetailVo.setOpinionList(opinionJson);
        }
        taskDetailVo.setResult(true);
        if ("FOLLOW".equals(task.getStatus())) {
            this.bpmTaskManager.remove((Serializable)((Object)taskId));
        }
        return CompletableFuture.completedFuture(taskDetailVo);
    }

    @Override
    public boolean isInRightMap(String procDefKey, String procInstId) {
        List list = this.bpmDefUserManager.getByUserMap("bpmDef", "task");
        IGroup ugroup = ContextUtil.getCurrentGroup();
        ArrayList<String> authOrgs = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            boolean baseIn = false;
            boolean needOrg = true;
            for (BpmDefUser bpmDefUser : list) {
                List defKeys;
                String type;
                List bpmDefAct;
                boolean isIn = false;
                if (StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg())) {
                    bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                    block3: for (BpmDefAct bpm : bpmDefAct) {
                        type = bpm.getType();
                        if ("1".equals(type) && (isIn = procDefKey.equals(bpm.getDefKey())) && !baseIn) {
                            baseIn = true;
                        }
                        if (!"2".equals(type)) continue;
                        defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            if (!procDefKey.equals(defKey)) continue;
                            isIn = true;
                            if (!isIn || baseIn) continue block3;
                            baseIn = true;
                            continue block3;
                        }
                    }
                    if (!isIn || !BeanUtils.isNotEmpty((Object)bpmDefUser.getAuthOrg())) continue;
                    authOrgs.add(bpmDefUser.getAuthOrg());
                    continue;
                }
                bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                for (BpmDefAct bpm : bpmDefAct) {
                    type = bpm.getType();
                    if ("1".equals(type) && (isIn = procDefKey.equals(bpm.getDefKey())) && !baseIn) {
                        baseIn = true;
                    }
                    if ("2".equals(type)) {
                        defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            if (!procDefKey.equals(defKey)) continue;
                            isIn = true;
                            if (!isIn || baseIn) break;
                            baseIn = true;
                            break;
                        }
                    }
                    if (!isIn || !StringUtil.isNotEmpty((String)bpm.getRightContent())) continue;
                    try {
                        ObjectNode rightJson = (ObjectNode)JsonUtil.toJsonNode((String)bpm.getRightContent());
                        if (JsonUtil.getBoolean((ObjectNode)rightJson, (String)"i_org", (boolean)false)) continue;
                        needOrg = false;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (needOrg || BeanUtils.isNotEmpty(authOrgs)) {
                if (BeanUtils.isNotEmpty((Object)ugroup)) {
                    String orgId = ugroup.getGroupId();
                    String path = ugroup.getPath();
                    String[] pathArray = path.split(orgId + '.');
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(orgId);
                    if (pathArray.length >= 2) {
                        BpmDefAct childIds;
                        for (String corgId : childIds = pathArray[1].split(".")) {
                            if (!StringUtil.isNotEmpty((String)corgId)) continue;
                            idSet.add(corgId);
                        }
                    }
                    if (needOrg) {
                        int i = this.bpmProcessInstanceManager.getIsInRightMap(procInstId, StringUtil.convertListToSingleQuotesString(idSet));
                        if (i > 0) {
                            return true;
                        }
                    } else {
                        for (String id : authOrgs) {
                            if (!idSet.contains(id)) continue;
                            return true;
                        }
                    }
                }
            } else if (baseIn) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<TaskDetailVo> taskDetailMobile(String taskId, String reqValue, FormType formType) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            task = new DefaultBpmTask();
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
                throw new NotFoundException("\u6b64\u4efb\u52a1\u5df2\u88ab\u5904\u7406\u6216\u4e0d\u5b58\u5728\uff01");
            }
            task = bpmTaskNotice.convertToBpmTask();
        }
        TaskDetailVo taskDetailVo = new TaskDetailVo();
        String topDefKey = "";
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        if (StringUtil.isNotZeroEmpty((String)bpmProcessInstance.getParentInstId())) {
            BpmProcessInstance topInstance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(bpmProcessInstance);
            topDefKey = topInstance.getProcDefKey();
        }
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)formType);
        FormModel formModel = bpmFormService.getByDefId(defId, nodeId, bpmProcessInstance, true);
        if (formModel == null || formModel.isFormEmpty()) {
            taskDetailVo.setResult("formEmpty");
            return CompletableFuture.completedFuture(taskDetailVo);
        }
        taskDetailVo.setForm(formModel);
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List buttons = null;
        if (BeanUtils.isNotEmpty((Object)taskNodeDef) && !"FOLLOW".equals(task.getStatus())) {
            buttons = BpmUtil.getButtons((BpmNodeDef)taskNodeDef, (DefaultBpmTask)task);
        }
        if (FormCategory.INNER.value().equals(formModel.getType().value())) {
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("formkey", formModel.getFormKey());
            formRestParams.put("parentFlowKey", topDefKey);
            if (!("FOLLOW".equals(task.getStatus()) || "COPYTO".equals(task.getStatus()) || "COMMU".equals(task.getStatus()))) {
                formRestParams.put("flowKey", task.getProcDefKey());
                formRestParams.put("nodeId", formModel.getNodeId());
                formRestParams.put("parentFlowKey", topDefKey);
            } else {
                String curUserId = ContextUtil.getCurrentUserId();
                formRestParams.put("userId", curUserId);
            }
            String permission = this.formRestfulService.getPermission(formRestParams);
            taskDetailVo.setPermission(permission);
            ContextThreadUtil.putCommonVars((String)"nodeId", (Object)nodeId);
            ContextThreadUtil.putCommonVars((String)"nodeId", (Object)nodeId);
            ContextThreadUtil.putCommonVars((String)"formPermission", (Object)permission);
            List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            if (!("FOLLOW".equals(task.getStatus()) || "COPYTO".equals(task.getStatus()) || "COMMU".equals(task.getStatus()))) {
                DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
                cmd.setVariables(this.getTaskVars(taskId, null));
                ContextThreadUtil.setActionCmd((ActionCmd)cmd);
            }
            ObjectNode data = BoDataUtil.hanlerData((BpmProcessInstance)bpmProcessInstance, (String)nodeId, (List)boDatas);
            taskDetailVo.setData(data);
            ObjectNode opinionJson = this.boDataService.getFormOpinionJson(task.getProcInstId());
            taskDetailVo.setOpinionList(opinionJson);
        }
        if (BeanUtils.isNotEmpty((Object)buttons)) {
            this.handButtons(buttons, task.getTaskId());
            taskDetailVo.setButtons(buttons);
        }
        taskDetailVo.setResult(true);
        return CompletableFuture.completedFuture(taskDetailVo);
    }

    private void handButtons(List<Button> buttons, String taskId) {
        GroovyScriptEngine scriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        Map boMap = BpmContextUtil.getBoFromContext();
        HashMap variables = new HashMap();
        if (BeanUtils.isNotEmpty((Object)boMap)) {
            variables.putAll(boMap);
        }
        ArrayList<Button> removeBtns = new ArrayList<Button>();
        for (Button btn : buttons) {
            String script = btn.getGroovyScript();
            if (StringUtil.isEmpty((String)script)) continue;
            boolean rtn = true;
            if (variables.size() != 0) {
                rtn = scriptEngine.executeBoolean(script, variables);
            }
            if (rtn) continue;
            removeBtns.add(btn);
        }
        buttons.removeAll(removeBtns);
    }

    private Map<String, Object> getActVars(String taskId, Map<String, String> varMap) throws Exception {
        Map<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtil.isEmpty((String)taskId)) {
            return rtnMap;
        }
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (!StringUtil.isZeroEmpty((String)bpmTask.getParentId())) {
            taskId = bpmTask.getParentId();
        }
        rtnMap = this.natTaskService.getVariables(taskId);
        if (BeanUtils.isEmpty(varMap)) {
            return rtnMap;
        }
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(bpmTask.getProcDefId());
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ArrayList bpmVariableList = defExt.getVariableList();
        if (bpmVariableList == null) {
            bpmVariableList = new ArrayList();
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getNodeId())) {
            bpmVariableList.addAll(defExt.getVariableList(bpmTask.getNodeId()));
        }
        for (BpmVariableDef var : bpmVariableList) {
            String varkey = var.getVarKey();
            String val = varMap.get(varkey);
            if (val == null) continue;
            Object rtnVal = DefaultBpmVariableDef.getValue((String)var.getDataType(), (String)val);
            rtnMap.put(varkey, rtnVal);
        }
        return rtnMap;
    }

    @Override
    public Map<String, Object> getTaskVars(String taskId, Map<String, String> vars) throws Exception {
        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isEmpty((String)taskId)) {
            return params;
        }
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (!StringUtil.isZeroEmpty((String)bpmTask.getParentId())) {
            taskId = bpmTask.getParentId();
        }
        if (TaskType.TRANSFORMEDINQU.name().equals(bpmTask.getStatus())) {
            taskId = this.compareBpmTask(bpmTask);
        }
        params = this.natTaskService.getVariables(taskId);
        List list = this.bpmDefinitionService.getVariableDefs(bpmTask.getProcDefId(), bpmTask.getNodeId());
        for (BpmVariableDef varDef : list) {
            String reqValue = null;
            if (BeanUtils.isNotEmpty(vars)) {
                reqValue = vars.get(varDef.getVarKey());
            }
            if (StringUtil.isEmpty(reqValue) && varDef.getDefaultVal() != null && StringUtil.isNotEmpty((String)varDef.getDefaultVal().toString())) {
                reqValue = varDef.getDefaultVal().toString();
            }
            if (!StringUtil.isNotEmpty(reqValue)) continue;
            Object convertVal = DefaultBpmVariableDef.getValue((String)varDef.getDataType(), (String)reqValue);
            params.put(varDef.getVarKey(), convertVal);
        }
        return params;
    }

    private String compareBpmTask(DefaultBpmTask bpmTask) {
        if (StringUtil.isZeroEmpty((String)bpmTask.getParentId())) {
            return bpmTask.getId();
        }
        return this.compareBpmTask((DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)bpmTask.getParentId())));
    }

    public Map<String, Object> getVarsFromURLForm(String taskId, String data) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isEmpty((String)taskId) || StringUtil.isEmpty((String)data)) {
            return params;
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)data);
        if (BeanUtils.isEmpty((Object)jsonNode)) {
            return params;
        }
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        List list = this.bpmDefinitionService.getVariableDefs(bpmTask.getProcDefId());
        if (BeanUtils.isEmpty((Object)list)) {
            return params;
        }
        for (BpmVariableDef varDef : list) {
            String varKey = varDef.getVarKey();
            String reqValue = null;
            JsonNode varKeyInData = jsonNode.get(varKey);
            if (varKeyInData != null && varKeyInData.isValueNode()) {
                reqValue = varKeyInData.asText();
            }
            if (!StringUtil.isNotEmpty(reqValue)) continue;
            Object convertVal = DefaultBpmVariableDef.getValue((String)varDef.getDataType(), (String)reqValue);
            params.put(varKey, convertVal);
        }
        return params;
    }

    @Override
    @Transactional
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<CommonResult<String>> complete(DoNextParamObject doNextParamObject) throws Exception {
        try {
            DefaultTaskFinishCmd cmd = this.getCmdFromRequest(doNextParamObject);
            boolean result = this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
            CommonResult resultObj = new CommonResult(result, result ? "\u4efb\u52a1\u529e\u7406\u6210\u529f" : "\u4efb\u52a1\u529e\u7406\u5931\u8d25", (Object)"");
            return CompletableFuture.completedFuture(resultObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (StringUtil.isNotEmpty((String)rootCauseMessage) && rootCauseMessage.indexOf("\u8868\u5355\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u3002") > -1) {
                rootCauseMessage = "\u8868\u5355\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u3002";
            }
            throw new BaseException("\u4efb\u52a1\u529e\u7406\u5931\u8d25:" + rootCauseMessage, (Throwable)e);
        }
    }

    private DefaultTaskFinishCmd getCmdFromRequest(DoNextParamObject doNextParamObject) throws Exception {
        String nodeUsers;
        DefaultBpmDefinition mainByDefKey;
        String taskId = doNextParamObject.getTaskId();
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isNotEmpty((Object)doNextParamObject.getUrgentStateValue()) && BeanUtils.isNotEmpty((Object)defaultBpmTask) && BeanUtils.isNotEmpty((Object)(mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(defaultBpmTask.getProcDefKey()))) && mainByDefKey.getShowUrgentState() == 1) {
            String instanceUrgentState;
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)defaultBpmTask.getProcInstId()));
            String oldValue = doNextParamObject.getUrgentStateValue().hasNonNull("old") ? doNextParamObject.getUrgentStateValue().get("old").asText() : "";
            String string = instanceUrgentState = StringUtil.isNotEmpty((String)instance.getUrgentState()) ? instance.getUrgentState() : "";
            if (!oldValue.equals(instanceUrgentState)) {
                throw new RuntimeException("\u7d27\u6025\u72b6\u6001\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u8868\u5355\u83b7\u53d6\u6700\u65b0\u6570\u636e\u518d\u63d0\u4ea4");
            }
            if (BeanUtils.isNotEmpty((Object)doNextParamObject.getUrgentStateValue().get("new"))) {
                instance.setUrgentState(doNextParamObject.getUrgentStateValue().get("new").asText());
            }
            this.bpmProcessInstanceManager.update((Model)instance);
        }
        String actionName = doNextParamObject.getActionName();
        String opinion = doNextParamObject.getOpinion();
        String formType = StringUtil.isEmpty((String)doNextParamObject.getFormType()) ? FormCategory.INNER.value() : doNextParamObject.getFormType();
        String data = "";
        if (StringUtil.isNotEmpty((String)doNextParamObject.getData())) {
            try {
                data = Base64.getFromBase64((String)doNextParamObject.getData());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean directHandlerSign = doNextParamObject.getDirectHandlerSign();
        String backHandMode = doNextParamObject.getBackHandMode();
        String jumpType = doNextParamObject.getJumpType();
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        if (StringUtil.isNotEmpty((String)doNextParamObject.getInterPoseOpinion())) {
            cmd.setInterPoseOpinion(doNextParamObject.getInterPoseOpinion());
        }
        Map<String, Object> varsFromVars = this.getActVars(taskId, doNextParamObject.getVars());
        if ("free".equals(jumpType) || "select".equals(jumpType) || "reject".equals(actionName)) {
            String destination = doNextParamObject.getDestination();
            if (StringUtil.isNotEmpty((String)destination)) {
                cmd.setDestination(destination);
                if (!"reject".equals(actionName)) {
                    varsFromVars.put("bpm_destination_" + defaultBpmTask.getNodeId(), destination);
                }
            } else if (BeanUtils.isNotEmpty((Object)varsFromVars.get("bpm_destination_" + defaultBpmTask.getNodeId())) && !"reject".equals(actionName)) {
                cmd.setDestination((String)varsFromVars.get("bpm_destination_" + defaultBpmTask.getNodeId()));
            }
        }
        if (StringUtil.isNotEmpty((String)(nodeUsers = doNextParamObject.getNodeUsers())) && !"[]".equals(nodeUsers)) {
            Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
            if (BeanUtils.isNotEmpty((Object)specUserMap)) {
                cmd.addTransitVars("bpm_node_users_", (Object)specUserMap);
                varsFromVars.put("bpm_node_users_" + defaultBpmTask.getNodeId(), nodeUsers);
            }
        } else if (BeanUtils.isNotEmpty((Object)varsFromVars.get("bpm_node_users_" + defaultBpmTask.getNodeId()))) {
            cmd.addTransitVars("bpm_node_users_", (Object)BpmIdentityUtil.getBpmIdentity((String)((String)varsFromVars.get("bpm_node_users_" + defaultBpmTask.getNodeId()))));
        }
        if (StringUtil.isEmpty((String)cmd.getDestination()) && "reject".equals(actionName)) {
            String destination = this.getRejectPreDestination(taskId);
            if (StringUtil.isEmpty((String)destination)) {
                throw new RuntimeException("\u8be5\u8282\u70b9\u4efb\u52a1\u4e0d\u652f\u6301\u9a73\u56de\u4e0a\u4e00\u6b65");
            }
            cmd.setDestination(destination);
        }
        if ("common".equals(jumpType)) {
            List identity = BpmIdentityUtil.getNextNodeBpmIdentity((String)nodeUsers);
            cmd.addTransitVars("bpm_next_node_users_", (Object)identity);
        }
        if (directHandlerSign) {
            cmd.addTransitVars("signDirect", (Object)"1");
        }
        if (StringUtil.isNotEmpty((String)doNextParamObject.getRejectTaskId())) {
            cmd.setTaskId(doNextParamObject.getRejectTaskId());
        } else if (StringUtil.isNotEmpty((String)taskId)) {
            cmd.setTaskId(taskId);
        }
        cmd.setActionName(actionName);
        cmd.setApprovalOpinion(opinion);
        cmd.setAgentLeaderId(doNextParamObject.getAgentLeaderId());
        cmd.setFiles(doNextParamObject.getFiles());
        cmd.setZfiles(doNextParamObject.getZfiles());
        cmd.setAddSignAction(doNextParamObject.getAddSignAction());
        if (StringUtil.isNotEmpty((String)doNextParamObject.getRejectTaskId())) {
            cmd.setRejectTaskId(doNextParamObject.getRejectTaskId());
            if ("direct".equals(doNextParamObject.getBackHandMode())) {
                cmd.setAddSignTaskId(taskId);
            }
        }
        Map<Object, Object> varsFromData = new HashMap();
        if (FormCategory.INNER.value().equals(formType)) {
            BpmUtil.handOpinion((String)data, (DefaultTaskFinishCmd)cmd);
            cmd.setDataMode("bo");
        } else {
            if (StringUtil.isNotEmpty((String)data)) {
                varsFromData = this.getVarsFromURLForm(taskId, data);
            }
            cmd.setDataMode("pk");
        }
        varsFromVars.putAll(varsFromData);
        cmd.setVariables(varsFromVars);
        cmd.addTransitVars("backHandMode", (Object)backHandMode);
        cmd.setBusData(data);
        Map<String, List<BpmIdentity>> nodeIdentityMap = this.getNodeBpmIdentities(taskId, doNextParamObject.getUsersMap());
        cmd.setBpmIdentities(nodeIdentityMap);
        cmd.setFormKey(doNextParamObject.getFormKey());
        return cmd;
    }

    public String getRejectPreDestination(String taskId) throws Exception {
        boolean canRejectPreAct = true;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        boolean canReject = false;
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List buttons = BpmUtil.getButtons((BpmNodeDef)taskNodeDef, (DefaultBpmTask)task);
        for (Button button : buttons) {
            if (!"reject".equals(button.getAlias())) continue;
            canReject = true;
        }
        if (!canReject) {
            return "";
        }
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String procInstId = task.getProcInstId();
        List listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef((String)procInstId, (String)task.getNodeId(), (String)"pre");
        ArrayList<BpmNodeDef> bpmExeStacksUserNode = new ArrayList<BpmNodeDef>();
        ArrayList<BpmNodeDef> bpmExeStacksGoMapUserNode = new ArrayList<BpmNodeDef>();
        List relationList = this.relationManager.getListByProcInstId(procInstId);
        for (BpmNodeDef node : listBpmNodeDef) {
            if (!node.getType().equals((Object)NodeType.CALLACTIVITY) && !node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK) || node.getNodeId().equals(nodeId)) continue;
            bpmExeStacksUserNode.add(node);
            boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"pre", (List)relationList);
            boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"after", (List)relationList);
            if (!isHavePre || !isHaveAfter) {
                bpmExeStacksGoMapUserNode.add(node);
                continue;
            }
            List incomeNodes = node.getIncomeNodes();
            if (!BeanUtils.isNotEmpty((Object)incomeNodes)) continue;
            BpmNodeDef nodeDef = (BpmNodeDef)incomeNodes.get(0);
            if (!node.getType().equals((Object)NodeType.USERTASK) || !nodeDef.getType().equals((Object)NodeType.START) && !nodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
            bpmExeStacksGoMapUserNode.add(node);
        }
        boolean bl = canRejectPreAct = bpmExeStacksGoMapUserNode.size() > 0 || bpmExeStacksUserNode.size() > 0;
        if (!canRejectPreAct) {
            return "";
        }
        if ("direct".equals(backMode)) {
            return ((BpmNodeDef)bpmExeStacksUserNode.get(0)).getNodeId();
        }
        return ((BpmNodeDef)bpmExeStacksGoMapUserNode.get(0)).getNodeId();
    }

    private Map<String, List<BpmIdentity>> getNodeBpmIdentities(String taskId, ObjectNode usersMap) throws Exception {
        HashMap<String, List<BpmIdentity>> nodeIdentityMap = new HashMap<String, List<BpmIdentity>>();
        if (StringUtil.isEmpty((String)taskId)) {
            return nodeIdentityMap;
        }
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        for (BpmNodeDef nodeDef : taskNodeDef.getOutcomeTaskNodes()) {
            if (!BeanUtils.isNotEmpty((Object)usersMap)) continue;
            String userIdStr = usersMap.get("uId_" + nodeDef.getNodeId()).asText();
            String[] userIds = userIdStr.split(",");
            ArrayList<DefaultBpmIdentity> bpmIdentities = new ArrayList<DefaultBpmIdentity>();
            if (BeanUtils.isEmpty((Object)userIds)) continue;
            for (String uId : userIds) {
                IUser user = this.userServiceImpl.getUserById(uId);
                DefaultBpmIdentity identity = new DefaultBpmIdentity(user);
                bpmIdentities.add(identity);
            }
            nodeIdentityMap.put(nodeDef.getNodeId(), bpmIdentities);
        }
        return nodeIdentityMap;
    }

    @Override
    @Transactional
    public CommonResult<String> saveDraft(DoNextParamObject doNextParamObject) throws Exception {
        try {
            doNextParamObject.setActionName("saveDraft");
            DefaultTaskFinishCmd cmd = this.getCmdFromRequest(doNextParamObject);
            this.bpmTaskService.saveDraft((TaskFinishCmd)cmd);
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f!", (Object)"");
        }
        catch (Exception e) {
            String rootCauseMsg = ExceptionUtil.getExceptionMessage((Throwable)e);
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff1a" + rootCauseMsg, (Object)"");
        }
    }

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<TaskGetVo> getTaskById(String taskId, boolean requireLayout) throws Exception {
        int modifyRecord;
        DefaultBpmTask bpmTask = this.bpmTaskManager.getByTaskId(taskId);
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            bpmTask = new DefaultBpmTask();
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
                throw new BaseException("\u6b64\u4efb\u52a1\u5df2\u88ab\u5904\u7406\u6216\u4e0d\u5b58\u5728\uff01");
            }
            bpmTask = bpmTaskNotice.convertToBpmTask();
        } else {
            this.bpmTaskService.getTaskCandidates(taskId);
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(bpmTask.getProcInstId());
        bpmTask.setInstStatus(bpmProcessInstance.getStatus());
        BpmDefLayout bpmDefLayout = null;
        if (requireLayout) {
            bpmDefLayout = this.diagramService.getLayoutByDefId(bpmProcessInstance.getProcDefId());
        }
        List opinionList = this.bpmOpinionService.getTaskOpinions(bpmTask.getProcInstId());
        ArrayList<List<BpmTaskOpinion>> llist = new ArrayList<List<BpmTaskOpinion>>();
        ArrayList<BpmTaskOpinion> list = null;
        String preKey = "";
        for (BpmTaskOpinion bto : opinionList) {
            if (!preKey.equals(bto.getTaskKey())) {
                list = new ArrayList<BpmTaskOpinion>();
                llist.add(list);
                preKey = StringUtil.isNotEmpty((String)bto.getTaskKey()) ? bto.getTaskKey() : "";
            }
            list.add(bto);
        }
        BpmNodeDef nodeDef = null;
        if (!("COMMU".equals(bpmTask.getStatus()) || "FOLLOW".equals(bpmTask.getStatus()) || "COPYTO".equals(bpmTask.getStatus()))) {
            nodeDef = this.getCurNodeProperties(taskId, "", "");
        }
        boolean showModifyRecord = false;
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(bpmTask.getProcDefId());
        if (BeanUtils.isNotEmpty((Object)bpmDefinition) && (modifyRecord = bpmDefinition.getShowModifyRecord()) == 1) {
            showModifyRecord = true;
        }
        String defId = bpmTask.getProcDefId();
        String nodeId = bpmTask.getNodeId();
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
        FormModel formModel = bpmFormService.getByDefId(defId, nodeId, bpmProcessInstance, true);
        String formKey = "";
        if (BeanUtils.isNotEmpty((Object)formModel)) {
            formKey = formModel.getFormKey();
        }
        TaskGetVo getVo = new TaskGetVo(bpmTask, bpmDefLayout, llist, bpmIdentities, nodeDef, showModifyRecord, formKey);
        if (BeanUtils.isNotEmpty((Object)nodeDef)) {
            NodeProperties nodeProperties = nodeDef.getLocalProperties();
            getVo.setInitFillData(nodeProperties.isInitFillData());
            getVo.setSignatureField(nodeProperties.getSignatureField());
            getVo.setSignatureCover(nodeProperties.isSignatureCover());
            getVo.setSecretFree(nodeProperties.isSecretFree());
        }
        return CompletableFuture.completedFuture(getVo);
    }

    private void getNextAllNodes(BpmNodeDef curNode, List<BpmNodeDef> nextAllNodeDef) {
        List outcomeNodes = curNode.getOutcomeNodes();
        for (BpmNodeDef bpmNodeDef : outcomeNodes) {
            String typeKey = bpmNodeDef.getType().getKey();
            if (NodeType.SERVICETASK.getKey().equals(typeKey) || NodeType.EXCLUSIVEGATEWAY.getKey().equals(typeKey) || NodeType.PARALLELGATEWAY.getKey().equals(typeKey) || NodeType.INCLUSIVEGATEWAY.getKey().equals(typeKey)) {
                this.getNextAllNodes(bpmNodeDef, nextAllNodeDef);
                continue;
            }
            nextAllNodeDef.add(bpmNodeDef);
        }
    }

    @Override
    @Transactional
    public TaskToAgreeVo toAgree(String taskId, String actionName) throws Exception {
        Map variables;
        SignNodeDef signNodeDef;
        String userId;
        List pmLists;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
        }
        TaskToAgreeVo toAgreeVo = new TaskToAgreeVo();
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        String defKey = bpmProcessInstance.getProcDefKey();
        String typeId = task.getTypeId();
        toAgreeVo.setTaskId(taskId);
        toAgreeVo.setActionName(actionName);
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        NodeProperties nodeProperties = BpmUtil.getNodeProperties((BpmProcessInstance)bpmProcessInstance, (String)nodeId);
        String jumpType = "common";
        boolean isGoNextJustEndEvent = this.isGoNextJustEndEvent(taskNodeDef);
        toAgreeVo.setGoNextJustEndEvent(isGoNextJustEndEvent);
        if (nodeProperties != null) {
            jumpType = nodeProperties.getJumpType();
            if (OpinionStatus.AGREE.getKey().equals(actionName)) {
                List bpmIdentitys;
                List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
                BoDataUtil.hanlerData((BpmProcessInstance)bpmProcessInstance, (String)nodeId, (List)boDatas);
                if (jumpType.indexOf("select") > -1) {
                    HashMap<String, List> outcomeUserMap = new HashMap<String, List>();
                    List outcomeNodes = taskNodeDef.getOutcomeNodes();
                    List<BpmNodeDef> handlerSelectOutcomeNodes = this.handlerSelectOutcomeNodes(outcomeNodes);
                    for (BpmNodeDef bpmNodeDef : handlerSelectOutcomeNodes) {
                        bpmIdentitys = this.bpmIdentityService.searchByNode(task.getProcInstId(), bpmNodeDef.getNodeId());
                        outcomeUserMap.put(bpmNodeDef.getNodeId(), bpmIdentitys);
                    }
                    toAgreeVo.setOutcomeUserMap(outcomeUserMap);
                    toAgreeVo.setOutcomeNodes(handlerSelectOutcomeNodes);
                }
                if (jumpType.indexOf("free") > -1) {
                    List allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(defId);
                    ArrayList<BpmNodeDef> removeList = new ArrayList<BpmNodeDef>();
                    HashMap<String, List> allNodeUserMap = new HashMap<String, List>();
                    for (BpmNodeDef bpmNodeDef : allNodeDef) {
                        if (NodeType.START.equals((Object)bpmNodeDef.getType())) {
                            removeList.add(bpmNodeDef);
                            continue;
                        }
                        if (!NodeType.USERTASK.equals((Object)bpmNodeDef.getType()) && !NodeType.SIGNTASK.equals((Object)bpmNodeDef.getType())) continue;
                        bpmIdentitys = this.bpmIdentityService.searchByNode(task.getProcInstId(), bpmNodeDef.getNodeId());
                        allNodeUserMap.put(bpmNodeDef.getNodeId(), bpmIdentitys);
                    }
                    allNodeDef.removeAll(removeList);
                    toAgreeVo.setAllNodeDef(allNodeDef);
                    toAgreeVo.setAllNodeUserMap(allNodeUserMap);
                }
            }
        }
        if (taskNodeDef instanceof SignNodeDef && ((pmLists = this.signService.getPrivilege(userId = ContextUtil.getCurrentUserId(), signNodeDef = (SignNodeDef)taskNodeDef, variables = this.natTaskService.getVariables(taskId))).contains(PrivilegeMode.ALL) || pmLists.contains(PrivilegeMode.DIRECT))) {
            toAgreeVo.setDirectHandlerSign(true);
        }
        List approvalItem = this.workflowFeignService.getApprovalByDefKeyAndTypeId(defKey, typeId, ContextUtil.getCurrentUserId());
        toAgreeVo.setJumpType(jumpType);
        toAgreeVo.setApprovalItem(approvalItem);
        return toAgreeVo;
    }

    private boolean isGoNextJustEndEvent(BpmNodeDef taskNodeDef) {
        boolean isGoNextJustEndEvent = true;
        try {
            List outcomeNodes = taskNodeDef.getOutcomeNodes();
            if (BeanUtils.isNotEmpty((Object)outcomeNodes)) {
                for (BpmNodeDef bpmNodeDef : outcomeNodes) {
                    if (bpmNodeDef.getType().equals((Object)NodeType.END)) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isGoNextJustEndEvent;
    }

    @Override
    @Transactional
    public TaskToRejectVo toReject(String taskId, String backModel) throws Exception {
        BpmNodeDef beforNode;
        boolean canRejectToStart = false;
        boolean canRejectToAnyNode = false;
        boolean canReject = false;
        boolean canRejectPreAct = false;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new WorkFlowException("\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff01");
        }
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List buttons = BpmUtil.getButtons((BpmNodeDef)taskNodeDef, (DefaultBpmTask)task);
        for (Button button : buttons) {
            String rejectMode;
            if (!"reject".equals(button.getAlias()) || !StringUtil.isNotEmpty((String)(rejectMode = button.getRejectMode()))) continue;
            List<String> rejectModeList = Arrays.asList(rejectMode.split(","));
            if (rejectModeList.contains("backToStart")) {
                canRejectToStart = true;
            }
            if (rejectModeList.contains("rejectPre")) {
                canRejectPreAct = true;
            }
            if (!rejectModeList.contains("reject")) continue;
            canRejectToAnyNode = true;
        }
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String backNode = nodeProperties.getBackNode();
        String procInstId = task.getProcInstId();
        ArrayList<BpmNodeDef> allowDirectNode = new ArrayList<BpmNodeDef>();
        ArrayList<Object> allowNormalNode = new ArrayList<BpmNodeDef>();
        Map inGatewayNodeMap = BpmUtil.getInGatewayNodeMap((BpmProcessDef)bpmProcessDef);
        Map beforeNodes = BpmUtil.getNodesByDirection((BpmNodeDef)taskNodeDef, (String)"");
        BpmExeStackRelationManager relationManager = (BpmExeStackRelationManager)AppUtil.getBean(BpmExeStackRelationManager.class);
        List relationList = relationManager.getListByProcInstId(procInstId);
        HashSet<String> bpmExeStackSet = new HashSet<String>();
        for (BpmExeStackRelation relation : relationList) {
            BpmNodeDef node = (BpmNodeDef)beforeNodes.get(relation.getFromNodeId());
            if (BeanUtils.isEmpty((Object)node) || bpmExeStackSet.contains(node.getNodeId()) || node.getNodeId().equals(nodeId) || !node.getType().equals((Object)NodeType.CALLACTIVITY) && !node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK)) continue;
            allowDirectNode.add(node);
            bpmExeStackSet.add(node.getNodeId());
            if (inGatewayNodeMap.containsKey(node.getNodeId())) continue;
            allowNormalNode.add(node);
        }
        TaskToRejectVo taskToRejectVo = new TaskToRejectVo();
        taskToRejectVo.setTaskId(taskId);
        taskToRejectVo.setBackMode(backMode);
        taskToRejectVo.setBackNode(backNode);
        List<Object> backNodeList = new ArrayList();
        if (StringUtil.isNotEmpty((String)backNode)) {
            String[] split = backNode.split(",");
            backNodeList = Arrays.asList(split);
            ArrayList<BpmNodeDef> tmp = new ArrayList<BpmNodeDef>();
            for (BpmNodeDef bpmNodeDef : allowNormalNode) {
                if (!backNodeList.contains(bpmNodeDef.getNodeId())) continue;
                tmp.add(bpmNodeDef);
            }
            allowNormalNode = tmp;
            tmp = new ArrayList();
            for (BpmNodeDef bpmNodeDef : allowDirectNode) {
                if (!backNodeList.contains(bpmNodeDef.getNodeId())) continue;
                tmp.add(bpmNodeDef);
            }
            allowDirectNode = tmp;
        }
        if (canRejectToAnyNode) {
            canRejectToAnyNode = allowDirectNode.size() != 0 || allowNormalNode.size() != 0;
        }
        taskToRejectVo.setAllowNormalNode(allowNormalNode);
        taskToRejectVo.setAllowDirectNode(allowDirectNode);
        taskToRejectVo.setCanReject(canReject);
        taskToRejectVo.setCanRejectPreAct(canRejectPreAct);
        taskToRejectVo.setCanRejectToAnyNode(canRejectToAnyNode);
        taskToRejectVo.setCanRejectToStart(canRejectToStart);
        List incomeNodes = taskNodeDef.getIncomeNodes();
        if (incomeNodes.size() == 1 && ((beforNode = (BpmNodeDef)incomeNodes.get(0)).getType().equals((Object)NodeType.PARALLELGATEWAY) || beforNode.getType().equals((Object)NodeType.INCLUSIVEGATEWAY)) && beforNode.getIncomeNodes().size() > 1) {
            taskToRejectVo.setAfterGateway(true);
        }
        if (inGatewayNodeMap.containsKey(nodeId)) {
            taskToRejectVo.setInGateway(true);
        }
        if (BeanUtils.isNotEmpty((Object)taskNodeDef.getParentBpmNodeDef())) {
            taskToRejectVo.setInSubProcess(true);
        }
        return taskToRejectVo;
    }

    @Override
    @Transactional
    public CommonResult<String> withDraw(WithDrawParam withDrawParam) throws Exception {
        try {
            this.taskTransService.withDraw(withDrawParam.getTaskId(), withDrawParam.getNotifyType(), withDrawParam.getOpinion());
            return new CommonResult(true, "\u8ffd\u56de\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u8ffd\u56de\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public List<ObjectNode> opinionHistory(String instId, String taskId, boolean isCommu) throws Exception {
        if ((instId == null || instId.isEmpty()) && taskId != null) {
            instId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(instId);
        ArrayList<ObjectNode> opinionList = new ArrayList<ObjectNode>();
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < bpmTaskOpinions.size(); ++i) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(bpmTaskOpinions.get(i));
            opinionList.add(obj);
            if (!obj.hasNonNull("agentLeaderId")) continue;
            userIds.add(obj.get("agentLeaderId").asText());
        }
        if (!userIds.isEmpty()) {
            UCFeignService uCFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ArrayNode users = uCFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList(userIds), (String)","));
            HashMap<String, String> userNameMap = new HashMap<String, String>();
            for (JsonNode jsonNode : users) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                userNameMap.put(objectNode.get("id").asText(), objectNode.get("fullname").asText());
            }
            for (ObjectNode opinion : opinionList) {
                if (!opinion.hasNonNull("agentLeaderId")) continue;
                opinion.put("statusVal", "\u4ee3\u3010" + (String)userNameMap.get(opinion.get("agentLeaderId").asText()) + "\u3011" + OpinionStatus.fromKey((String)opinion.get("status").asText()).getValue());
            }
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PROC_INST_ID_", (Object)instId, QueryOP.EQUAL);
        BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
        PageList query = manager.query(queryFilter);
        ArrayList<ObjectNode> interPoseList = new ArrayList<ObjectNode>();
        for (BpmInterposeRecored recored : query.getRows()) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((Object)recored);
            obj.put("statusVal", InterPoseType.fromKey((String)recored.getStatus()).getValue());
            interPoseList.add(obj);
        }
        opinionList.addAll(interPoseList);
        return opinionList;
    }

    @Override
    public List<ObjectNode> filterByAuth(List<ObjectNode> opinionList, String instId, boolean isReqeust) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        if (instId == null || user.isAdmin()) {
            return opinionList;
        }
        BpmProcessInstance bpmProcessInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        BpmProcessDef def = this.bpmDefinitionAccessor.getBpmProcessDef(bpmProcessInstance.getProcDefId());
        String checkLimit = StringUtil.isNotEmpty((String)def.getProcessDefExt().getExtProperties().getCheckLimit()) ? def.getProcessDefExt().getExtProperties().getCheckLimit() : "all,end";
        String startLimit = StringUtil.isNotEmpty((String)def.getProcessDefExt().getExtProperties().getStartLimit()) ? def.getProcessDefExt().getExtProperties().getStartLimit() : "self,back,end";
        boolean isEndRevoke = opinionList.stream().filter(item -> item.get("status").asText().equals(OpinionStatus.END_REVOKE.getKey())).count() > 0L;
        return opinionList.stream().filter(item -> {
            if (user.getUserId().equals(bpmProcessInstance.getCreateBy())) {
                return this.isAdd(checkLimit, (ObjectNode)item, userId, isEndRevoke);
            }
            return this.isAdd(checkLimit, (ObjectNode)item, userId, isEndRevoke);
        }).collect(Collectors.toList());
    }

    boolean isAdd(String limit, ObjectNode obj, String userId, boolean isEndRevoke) {
        if (limit.indexOf("all") == -1) {
            if (limit.indexOf("self") >= 0 && obj.get("auditor").asText().equals(userId) && (limit.indexOf("end") == -1 || !obj.get("status").equals((Object)OpinionStatus.MANUAL_END.getKey()))) {
                return true;
            }
            if (limit.indexOf("back") >= 0) {
                ArrayList<String> userIds = new ArrayList<String>();
                try {
                    ArrayNode nodes = (ArrayNode)JsonUtil.toJsonNode((String)obj.get("qualfieds").asText());
                    for (JsonNode node : nodes) {
                        userIds.add(node.get("id").asText());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (userIds.contains(userId) && this.isBack(obj.get("status").asText())) {
                    return true;
                }
            }
        } else if (this.isRenew(obj.get("status").asText())) {
            if (limit.indexOf("end") >= 0) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isBack(String status) {
        return status.equals(OpinionStatus.REJECT.getKey()) || status.equals(OpinionStatus.BACK_TO_START.getKey());
    }

    private boolean isEnd(String status) {
        return status.equals(OpinionStatus.END.getKey()) || status.equals(OpinionStatus.MANUAL_END.getKey()) || status.equals(OpinionStatus.END_REVOKE.getKey());
    }

    private boolean isRenew(String status) {
        return status.equals(InterPoseType.RENEW_END.getKey());
    }

    @Override
    @Transactional
    public CommonResult<String> taskToInqu(TaskTransParamObject taskTransParamObject) throws Exception {
        BpmTask pendingTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTransParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)pendingTask)) {
            return new CommonResult(false, "\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff01");
        }
        taskTransParamObject.setTaskId(pendingTask.getTaskId());
        String notifyType = taskTransParamObject.getNotifyType();
        String opinion = taskTransParamObject.getOpinion();
        String userIds = taskTransParamObject.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR + ":userIds\u5f81\u8be2\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u5f81\u8be2\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            return new CommonResult(false, "\u5f81\u8be2\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba", (Object)"");
        }
        String files = taskTransParamObject.getFiles();
        taskTransParamObject.setVoteType(null);
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        if (StringUtil.isEmpty((String)taskTrans.getInquType()) && StringUtil.isNotEmpty((String)taskTransParamObject.getInquType())) {
            taskTrans.setInquType(taskTransParamObject.getInquType());
        }
        this.taskTransService.addTaskToInqu(taskTrans, userList, notifyType, opinion, files);
        if (BeanUtils.isNotEmpty((Object)taskTransParamObject.getData())) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)pendingTask.getProcInstId()));
            BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)pendingTask.getNodeId(), (String)taskTransParamObject.getData());
        }
        return new CommonResult(true, "\u5f81\u8be2\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public void addReadRecord(Object obj) {
        try {
            boolean isCreate = false;
            BpmReadRecord bpmReadRecord = new BpmReadRecord();
            bpmReadRecord.setId(UniqueIdUtil.getSuid());
            IUser user = ContextUtil.getCurrentUser();
            if (!user.isAdmin()) {
                if (BeanUtils.isNotEmpty((Object)user)) {
                    bpmReadRecord.setReader(user.getUserId());
                    bpmReadRecord.setReaderName(user.getFullname());
                }
                bpmReadRecord.setReadTime(LocalDateTime.now());
                ObjectNode node = this.ucFeignService.getMainGroup(user.getUserId());
                if (BeanUtils.isNotEmpty((Object)node)) {
                    bpmReadRecord.setOrgId(node.get("id").asText());
                    bpmReadRecord.setOrgPath(node.get("pathName").asText());
                }
                DefaultBpmProcessInstance instance = null;
                if (obj instanceof DefaultBpmTask) {
                    isCreate = true;
                    DefaultBpmTask task = (DefaultBpmTask)obj;
                    bpmReadRecord.setTaskId(task.getId());
                    bpmReadRecord.setTaskName(task.getName());
                    bpmReadRecord.setProcDefId(task.getProcDefId());
                    bpmReadRecord.setProcInstId(task.getProcInstId());
                    bpmReadRecord.setTaskKey(task.getNodeId());
                } else if (obj instanceof DefaultBpmProcessInstance) {
                    isCreate = true;
                    instance = (DefaultBpmProcessInstance)obj;
                }
                if (BeanUtils.isNotEmpty(instance)) {
                    bpmReadRecord.setProcInstId(instance.getId());
                    bpmReadRecord.setProcDefId(instance.getProcDefId());
                    bpmReadRecord.setSupInstId(instance.getParentInstId());
                }
                if (isCreate) {
                    this.bpmReadRecordManager.create((Model)bpmReadRecord);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void noticeTurnDode(String taskId) {
        try {
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNoticeDoneManager noticeDoneManager = (BpmTaskNoticeDoneManager)AppUtil.getBean(BpmTaskNoticeDoneManager.class);
            BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)bpmTaskNotice) || TaskType.COMMU.getKey().equals(bpmTaskNotice.getStatus())) {
                return;
            }
            String taskName = "";
            taskName = bpmTaskNotice.getStatus().equals("FOLLOW") ? "\u3010\u8ddf\u8e2a\u3011" + bpmTaskNotice.getName() : bpmTaskNotice.getName();
            BpmTaskNoticeDone bpmTaskNoticeDone = new BpmTaskNoticeDone(taskName, bpmTaskNotice.getProcDefId(), bpmTaskNotice.getProcInstId(), bpmTaskNotice.getAssigneeId(), bpmTaskNotice.getAssigneeName(), bpmTaskNotice.getStatus(), bpmTaskNotice.getSubject(), bpmTaskNotice.getProcDefName(), bpmTaskNotice.getOwnerName(), bpmTaskNotice.getId(), bpmTaskNotice.getTaskId(), bpmTaskNotice.getNodeId(), bpmTaskNotice.getSupportMobile());
            noticeDoneManager.create((Model)bpmTaskNoticeDone);
            if (!"COPYTO".equals(bpmTaskNotice.getStatus())) {
                noticeManager.removeByIds(new String[]{taskId});
            } else {
                BpmTaskNotice notice = bpmTaskNotice;
                notice.setIsRead(Integer.valueOf(1));
                noticeManager.update((Model)notice);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ObjectNode getAfterJumpNode(ObjectNode obj) throws Exception {
        BpmTask bpmTask;
        String taskId = "";
        if (obj.has("taskId")) {
            taskId = obj.get("taskId").asText();
        }
        String defId = "";
        if (obj.has("defId")) {
            defId = obj.get("defId").asText();
        }
        String instId = "";
        if (obj.has("instId")) {
            instId = obj.get("instId").asText();
        }
        String bodata = "";
        if (obj.has("data")) {
            bodata = obj.get("data").asText();
            bodata = Base64.getFromBase64((String)bodata);
        }
        String type = "";
        if (obj.has("type")) {
            type = obj.get("type").asText();
        }
        String curNodeId = "";
        BpmNodeDef curBpmNodeDef = null;
        Map<String, String> variables = new HashMap();
        if (StringUtil.isNotEmpty((String)taskId)) {
            DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)task)) {
                throw new NotFoundException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5904\u7406\u4e86\u3002\u4efb\u52a1ID:" + taskId);
            }
            curNodeId = task.getNodeId();
            defId = task.getProcDefId();
            TaskService taskService = (TaskService)AppUtil.getBean(TaskService.class);
            variables = taskService.getVariables(taskId);
            if (!task.getStatus().equals("TRANSFORMED")) {
                variables.put("not_request_uc", "true");
            }
        } else if (StringUtil.isNotEmpty((String)instId)) {
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance)) {
                defId = defaultBpmProcessInstance.getProcDefId();
            }
        } else if (StringUtil.isEmpty((String)defId)) {
            throw new RequiredException("\u4efb\u52a1ID\u548c\u5b9a\u4e49ID\u5fc5\u987b\u4f20\u4e00\u4e2a");
        }
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List bpmnNodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        boolean isSkipFirstNode = false;
        if (StringUtil.isEmpty((String)taskId)) {
            curBpmNodeDef = bpmProcessDefExt.getStartEvent();
            BpmDefExtProperties extProperties = bpmProcessDefExt.getProcessDefExt().getExtProperties();
            if (extProperties.isSkipFirstNode()) {
                isSkipFirstNode = true;
            }
        } else {
            curBpmNodeDef = this.findBpmNodeDefByNodeId(bpmnNodeDefs, curNodeId);
        }
        ArrayList<BpmNodeDef> nextAllNodeDef = new ArrayList();
        NodeProperties nodeProperties = curBpmNodeDef.getLocalProperties();
        if (StringUtil.isNotEmpty((String)curNodeId) && BeanUtils.isNotEmpty(variables.get("bpm_destination_" + curNodeId))) {
            nodeProperties.setJumpType("");
            nodeProperties.setChoiceExcutor("");
        }
        String jumpType = nodeProperties.getJumpType();
        String helpGlobal = nodeProperties.getHelpGlobal();
        String help = nodeProperties.getHelp();
        String choiceExcutor = nodeProperties.getChoiceExcutor();
        String approvalArea = nodeProperties.getApprovalArea();
        Boolean sponsorRevoke = nodeProperties.isSponsorRevoke();
        Boolean previousRevoke = nodeProperties.isPreviousRevoke();
        Boolean referOpinion = nodeProperties.isReferOpinion();
        if (StringUtil.isNotEmpty((String)jumpType) && !"select".equals(jumpType) || StringUtil.isNotEmpty((String)type) && "free".equals(type)) {
            nextAllNodeDef = bpmnNodeDefs;
        } else if ("select".equals(jumpType) || StringUtil.isNotEmpty((String)choiceExcutor)) {
            if (isSkipFirstNode) {
                curBpmNodeDef = (BpmNodeDef)curBpmNodeDef.getOutcomeNodes().get(0);
            }
            this.getNextAllNodes(curBpmNodeDef, nextAllNodeDef);
        }
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        List bodatas = BusDataUtil.transFormDataToBoData((DefaultBpmProcessDefExt)defExt, (String)bodata);
        BpmContextUtil.setBoToContext((List)bodatas);
        Map nodeMap = new HashMap();
        ArrayNode nodeArray = JsonUtil.getMapper().createArrayNode();
        Map inGatewayNodeMap = BpmUtil.getInGatewayNodeMap((BpmProcessDef)bpmProcessDefExt);
        if (!variables.containsKey("startUser")) {
            variables.put("startUser", ContextUtil.getCurrentUserId());
        }
        for (BpmNodeDef bpmNodeDef : nextAllNodeDef) {
            try {
                String nodeType = bpmNodeDef.getType().getKey();
                if (curNodeId.equals(bpmNodeDef.getNodeId()) || !NodeType.USERTASK.getKey().equals(nodeType) && !NodeType.SIGNTASK.getKey().equals(nodeType) && !NodeType.CUSTOMSIGNTASK.getKey().equals(nodeType) && !NodeType.END.getKey().equals(nodeType) || inGatewayNodeMap.containsKey(bpmNodeDef.getNodeId())) continue;
                ObjectNode nodeObj = JsonUtil.getMapper().createObjectNode();
                nodeObj.put("nodeName", bpmNodeDef.getName());
                nodeObj.put("nodeId", bpmNodeDef.getNodeId());
                nodeObj.put("nodeType", bpmNodeDef.getType().getKey());
                nodeArray.add((JsonNode)nodeObj);
                if (!"candidate".equals(choiceExcutor)) continue;
                UserQueryPluginHelper userQueryPluginHelper = (UserQueryPluginHelper)AppUtil.getBean(UserQueryPluginHelper.class);
                List bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
                List bpmIdentities = userQueryPluginHelper.query(bpmPluginContexts, variables, "user");
                ArrayList<Map> identitiesMap = new ArrayList<Map>();
                for (BpmIdentity bpmIdentitie : bpmIdentities) {
                    identitiesMap.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)bpmIdentitie)));
                }
                nodeMap.put(bpmNodeDef.getNodeId(), identitiesMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtil.isNotEmpty((String)taskId) && (bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId))).getStatus().equals("TRANSFORMED")) {
            jumpType = "";
            choiceExcutor = "";
            nodeArray = JsonUtil.getMapper().createArrayNode();
        }
        ObjectNode resulObj = JsonUtil.getMapper().createObjectNode();
        resulObj.put("jumpType", jumpType);
        resulObj.put("help", help);
        resulObj.put("helpGlobal", helpGlobal);
        resulObj.set("afterNodes", (JsonNode)nodeArray);
        resulObj.put("choiceExcutor", choiceExcutor);
        resulObj.put("approvalArea", approvalArea);
        resulObj.put("referOpinion", referOpinion);
        resulObj.put("sponsorRevoke", sponsorRevoke);
        resulObj.put("previousRevoke", previousRevoke);
        if (!"candidate".equals(choiceExcutor)) {
            return resulObj;
        }
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (BeanUtils.isNotEmpty(nodeMap)) {
            nodeMap = ucFeignService.calculateNodeUser(nodeMap);
        }
        for (JsonNode jsonNode : nodeArray) {
            ObjectNode objNode = (ObjectNode)jsonNode;
            if (!nodeMap.containsKey(objNode.get("nodeId").asText())) continue;
            List list = (List)nodeMap.get(objNode.get("nodeId").asText());
            ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
            for (Object excutorObj : list) {
                arrayNode.add(JsonUtil.toJsonNode(excutorObj));
            }
            objNode.set("excutorList", (JsonNode)arrayNode);
        }
        return resulObj;
    }

    @Override
    public BpmNodeDef getCurNodeProperties(String taskId, String defId, String instId) throws Exception {
        String curNodeId = "";
        BpmNodeDef curBpmNodeDef = null;
        if (StringUtil.isNotEmpty((String)taskId)) {
            DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)task)) {
                throw new RequiredException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5904\u7406\u4e86\u3002\u4efb\u52a1ID:" + taskId);
            }
            curNodeId = task.getNodeId();
            defId = task.getProcDefId();
        } else if (StringUtil.isEmpty((String)defId)) {
            throw new RequiredException("\u4efb\u52a1ID\u548c\u5b9a\u4e49ID\u5fc5\u987b\u4f20\u4e00\u4e2a");
        }
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        if (StringUtil.isEmpty((String)taskId)) {
            curBpmNodeDef = bpmProcessDefExt.getStartEvent();
        } else {
            List bpmnNodeDefs = BpmUtil.getSubProcessNodes((List)bpmProcessDefExt.getBpmnNodeDefs());
            for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
                if (!bpmNodeDef.getNodeId().equals(curNodeId)) continue;
                curBpmNodeDef = bpmNodeDef;
                break;
            }
        }
        return curBpmNodeDef;
    }

    private BpmNodeDef findBpmNodeDefByNodeId(List<BpmNodeDef> bpmnNodeDefs, String nodeId) {
        BpmNodeDef curBpmNodeDef = null;
        for (BpmNodeDef bpmNodeDef : bpmnNodeDefs) {
            if (bpmNodeDef.getType().getKey().equals(NodeType.SUBPROCESS.getKey())) {
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
                curBpmNodeDef = this.findBpmNodeDefByNodeId(subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs(), nodeId);
                continue;
            }
            if (!bpmNodeDef.getNodeId().equals(nodeId)) continue;
            curBpmNodeDef = bpmNodeDef;
        }
        return curBpmNodeDef;
    }

    @Override
    public PageList<Map<String, Object>> getFlowFieldList(QueryFilter queryFilter) throws Exception {
        try {
            List list = this.bpmProcessInstanceManager.getFlowFieldList(queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519\u4e86\uff01");
        }
    }

    @Override
    @Transactional
    public CommonResult<String> taskToApproveLine(TaskApproveLineParam taskApproveLineParam) throws Exception {
        String notifyType = taskApproveLineParam.getNotifyType();
        String opinion = taskApproveLineParam.getOpinion();
        String userIds = taskApproveLineParam.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":userIds\u6d41\u8f6c\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u6d41\u8f6c\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            throw new RuntimeException("\u6d41\u8f6c\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba\uff01");
        }
        TaskTransParamObject taskTransParamObject = (TaskTransParamObject)JsonUtil.toBean((String)JsonUtil.toJson((Object)taskApproveLineParam), TaskTransParamObject.class);
        taskTransParamObject.setAction("submit");
        taskTransParamObject.setDecideType("agree");
        taskTransParamObject.setSignType("parallel");
        taskTransParamObject.setVoteType("percent");
        taskTransParamObject.setVoteAmount(Short.valueOf("100"));
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        this.taskTransService.addApproveLineTask(taskTrans, userList, notifyType, opinion);
        return new CommonResult(true, "\u53d1\u8d77\u5e76\u884c\u5ba1\u6279\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> taskToSignSequence(TaskTransParamObject taskTransParamObject) throws Exception {
        String notifyType = taskTransParamObject.getNotifyType();
        String opinion = taskTransParamObject.getOpinion();
        String userIds = taskTransParamObject.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":userIds\u7b7e\u7f72\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u7b7e\u7f72\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            throw new RuntimeException("\u7b7e\u7f72\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba\uff01");
        }
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        this.taskTransService.addSignSequenceTask(taskTrans, userList, notifyType, opinion);
        return new CommonResult(true, "\u53d1\u8d77\u987a\u5e8f\u7b7e\u7f72\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> revokeTrans(RevokeTransParamObject revokeTransParamObject) throws Exception {
        if (revokeTransParamObject.getTaskId().equals(revokeTransParamObject.getParentTaskId())) {
            try {
                this.taskTransService.withDraw(revokeTransParamObject.getTaskId(), revokeTransParamObject.getMessageType(), revokeTransParamObject.getCause(), "bpmnTaskApproveLineCancel");
                return new CommonResult(true, "\u64a4\u56de\u6210\u529f", (Object)"");
            }
            catch (Exception e) {
                return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
            }
        }
        DefaultBpmTask parentTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)revokeTransParamObject.getParentTaskId()));
        if (!BeanUtils.isNotEmpty((Object)parentTask) || !TaskType.APPROVELINEING.getKey().equals(parentTask.getStatus())) {
            return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u8282\u70b9\u5df2\u4e0d\u652f\u6301\u64a4\u56de\uff01");
        }
        DefaultBpmCheckOpinion bpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(revokeTransParamObject.getTaskId(), OpinionStatus.APPROVE_LINEING_AGREE.getKey());
        if (BeanUtils.isEmpty((Object)bpmCheckOpinion)) {
            return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a\u6839\u636e\u4efb\u52a1ID\uff1a" + revokeTransParamObject.getTaskId() + "\u672a\u627e\u5230\u5bf9\u5e94\u5ba1\u6279\u8bb0\u5f55\uff01");
        }
        try {
            IUser user = ContextUtil.getCurrentUser();
            this.taskTransService.addRevokeTask(parentTask, user, revokeTransParamObject.getMessageType());
            bpmCheckOpinion.setStatus(OpinionStatus.REVOKER.getKey());
            bpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getTime((LocalDateTime)bpmCheckOpinion.getCompleteTime(), (LocalDateTime)bpmCheckOpinion.getCreateTime());
            bpmCheckOpinion.setDurMs(Long.valueOf(durMs));
            bpmCheckOpinion.setAuditor(user.getUserId());
            bpmCheckOpinion.setAuditorName(user.getFullname());
            bpmCheckOpinion.setOpinion(revokeTransParamObject.getCause());
            this.bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
            return new CommonResult(true, "\u64a4\u56de\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @Override
    @Transactional
    public void revokeSignSequence(RevokeTransParamObject revokeTransParamObject) throws Exception {
        this.taskTransService.revokeSignSequence(revokeTransParamObject);
    }

    @Override
    @Transactional
    public CommonResult<String> taskToSignLine(TaskTransParamObject taskTransParamObject) throws Exception {
        String notifyType = taskTransParamObject.getNotifyType();
        String opinion = taskTransParamObject.getOpinion();
        String userIds = taskTransParamObject.getUserIds();
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":userIds\u7b7e\u7f72\u4eba\u5458id\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)opinion)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":opinion\u7b7e\u7f72\u610f\u89c1\u5fc5\u586b");
        }
        String[] userIdArray = userIds.split(",");
        ArrayList<IUser> userList = new ArrayList<IUser>();
        for (String id : userIdArray) {
            IUser u = this.userServiceImpl.getUserById(id);
            if (u != null) {
                userList.add(u);
            }
            if (!currentUserId.equals(u.getUserId())) continue;
            throw new RuntimeException("\u7b7e\u7f72\u4eba\u5458\u4e0d\u80fd\u5305\u542b\u672c\u4eba\uff01");
        }
        ObjectNode transObject = (ObjectNode)JsonUtil.toJsonNode((String)taskTransParamObject.toString());
        BpmTaskTrans taskTrans = (BpmTaskTrans)JsonUtil.toBean((JsonNode)transObject, BpmTaskTrans.class);
        this.taskTransService.addSignLineTask(taskTrans, userList, notifyType, opinion);
        return new CommonResult(true, "\u53d1\u8d77\u5e76\u884c\u7b7e\u7f72\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public void revokeSignLine(RevokeSignLineParamObject revokeParamObject) throws Exception {
        this.taskTransService.revokeSignLine(revokeParamObject);
    }

    @Override
    @Transactional
    public CommonResult<String> taskCustomSignUsers(AssignParamObject assignParamObject) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String taskId = assignParamObject.getTaskId();
        String userIds = assignParamObject.getUserId();
        String messageType = assignParamObject.getMessageType();
        String addReason = assignParamObject.getOpinion();
        if (StringUtil.isEmpty((String)userIds)) {
            throw new RuntimeException("\u5fc5\u987b\u4f20\u5165\u7b7e\u7f72\u4eba\u5458");
        }
        String[] userIdAry = userIds.split(",");
        ArrayList<String> userIdList = new ArrayList<String>();
        for (String userId : userIdAry) {
            if (user.getUserId().equals(userId)) {
                throw new RuntimeException(String.format("\u7b7e\u7f72\u4eba\u5458\u4e0d\u80fd\u4e3a\u81ea\u5df1:%s", userId));
            }
            IUser userById = ServiceUtil.getUserById((String)userId);
            if (BeanUtils.isEmpty((Object)userById)) {
                throw new RuntimeException(String.format("\u5fc5\u987b\u4f20\u5165\u7b7e\u7f72\u4eba\u5458(userId):%s\u4e0d\u5b58\u5728", userId));
            }
            userIdList.add(userById.getUserId());
        }
        String[] userIdsAry = new String[userIdList.size()];
        userIdList.toArray(userIdsAry);
        ResultMessage addSignTask = this.signService.addCustomSignTask(taskId, userIdAry);
        if (addSignTask.getResult() == 1) {
            if (StringUtil.isNotEmpty((String)messageType)) {
                List bpmIdentities = (List)addSignTask.getVars().get("users");
                ArrayList<IUser> users = this.bpmIdentityExtractService.extractUser(bpmIdentities);
                Map variables = this.natTaskService.getVariables(taskId);
                variables.put("cause", addReason);
                variables.put("sender", ContextUtil.getCurrentUser().getFullname());
                variables.put("taskSubject", variables.get("subject_"));
                String baseUrl = "";
                variables.put("baseUrl", baseUrl);
                List taskIds = (List)addSignTask.getVars().get("taskIds");
                for (IUser iuser : users) {
                    String taskid = this.findTaskId(taskIds, user.getUserId());
                    if (!StringUtil.isNotEmpty((String)taskid)) continue;
                    variables.put("taskId", taskid);
                    users = new ArrayList<IUser>();
                    users.add(user);
                    this.signService.sendNotify(users, Arrays.asList(messageType.split(",")), "bpmnTaskSignSequence", variables);
                }
            }
            DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
            cmd.setTaskId(taskId);
            cmd.setActionName("agree");
            cmd.setApprovalOpinion(assignParamObject.getOpinion());
            cmd.setDataMode("bo");
            cmd.addTransitVars("custom_sign_status", (Object)String.valueOf(addSignTask.getVars().get("customStatus")));
            this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
            return new CommonResult(true, "\u6dfb\u52a0\u7b7e\u7f72\u4eba\u5458\u6210\u529f");
        }
        throw new RuntimeException(addSignTask.getCause());
    }

    @Override
    public CommonResult<BpmIdentity> nextExecutor(String taskId) {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\u4e86.");
        }
        BpmIdentity bpmIdentity = null;
        if (TaskType.SIGNSEQUENCEED.getKey().equals(task.getStatus())) {
            String varName = "signUsers_" + task.getNodeId();
            Integer loopCounter = (Integer)this.natTaskService.getVariable(taskId, "loopCounter");
            List list = (List)this.natTaskService.getVariable(taskId, varName);
            if (loopCounter + 1 < list.size()) {
                bpmIdentity = (BpmIdentity)list.get(loopCounter + 1);
            }
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", bpmIdentity);
    }

    private void StringToTimestamp(QueryFilter queryFilter) {
        List querys = queryFilter.getQuerys();
        ArrayList<Timestamp> objects = new ArrayList<Timestamp>();
        for (QueryField query : querys) {
            if (query.getProperty().indexOf("create") == -1 || !List.class.isInstance(query.getValue())) continue;
            for (String v : (List)query.getValue()) {
                objects.add(Timestamp.valueOf(v));
            }
            query.setValue(objects);
        }
    }

    @Override
    public Map<String, ObjectNode> getInstanceByPks(List<String> pks, String boDefAlias) {
        FormFeignService bean = (FormFeignService)AppUtil.getBean(FormFeignService.class);
        String pkType = bean.getPkTypeByDefAlias(boDefAlias);
        HashMap<String, ObjectNode> result = new HashMap<String, ObjectNode>();
        boolean isNumber = "number".equals(pkType);
        for (String pk : pks) {
            BpmBusLink busLink = this.bpmBusLinkManager.getByBusinesKey(pk, isNumber);
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            if (BeanUtils.isEmpty((Object)busLink)) {
                objectNode.put("isStartFlow", false);
                result.put(pk, objectNode);
                continue;
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)busLink.getProcInstId()));
            if (BeanUtils.isEmpty((Object)instance)) {
                objectNode.put("isStartFlow", true);
                result.put(pk, objectNode);
                continue;
            }
            objectNode.put("bpm_proc_inst_id_", instance.getId());
            objectNode.put("bpm_subject_", instance.getSubject());
            objectNode.put("bpm_proc_def_name_", instance.getProcDefName());
            objectNode.put("bpm_status_", instance.getStatus());
            String createTime = "";
            String endTime = "";
            if (BeanUtils.isNotEmpty((Object)instance.getCreateTime())) {
                createTime = DateFormatUtil.format((LocalDateTime)instance.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (BeanUtils.isNotEmpty((Object)instance.getEndTime())) {
                endTime = DateFormatUtil.format((LocalDateTime)instance.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            objectNode.put("bpm_create_time_", createTime);
            objectNode.put("bpm_end_time_", endTime);
            objectNode.put("bpm_is_forbidden_", instance.getIsForbidden());
            objectNode.put("bpm_creator_", instance.getCreator());
            objectNode.put("bpm_is_dele_", instance.getIsDele());
            objectNode.put("isStartFlow", true);
            result.put(pk, objectNode);
        }
        return result;
    }
}

