/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.SideSlopeInformationDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.vo.SideSlopCheckVo;
import com.artfess.yhxt.basedata.vo.SideSlopeRegularVo;
import com.artfess.yhxt.check.regular.dao.SideSlopeOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.SideSlopeRegularCheckDao;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.SideSlopeRegularCheck;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.vo.Org4sideSlopelVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SideSlopeInformationManagerImpl
extends BaseManagerImpl<SideSlopeInformationDao, SideSlopeInformation>
implements SideSlopeInformationManager {
    @Resource
    private SideSlopeOftenCheckDao slopeOftenCheckDao;
    @Resource
    private SideSlopeRegularCheckDao sideSlopeRegularCheckDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    OrgManager orgManager;
    @Resource
    WorkbenchDao workbenchDao;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4sideSlopelVO> getsideSlopelCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4sideSlopelVO> lists = new ArrayList<Org4sideSlopelVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = SideSlopeInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4sideSlopelVO fvo = new Org4sideSlopelVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = SideSlopeInformationManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4sideSlopelVO> setCount(List<Org4sideSlopelVO> list) {
        Iterator<Org4sideSlopelVO> it = list.iterator();
        while (it.hasNext()) {
            Org4sideSlopelVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4sideSlopelVO newCount(List<String> ids, Org4sideSlopelVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)0);
        List sides = this.list((Wrapper)wrapper);
        BigDecimal height = new BigDecimal(sides.stream().filter(e -> null != e.getHeight()).mapToDouble(SideSlopeInformation::getHeight).sum());
        orgVO.setCount(sides.size());
        if (sides.size() > 0 && !height.equals(BigDecimal.ZERO)) {
            orgVO.setHeight(height.divide(new BigDecimal(sides.size()), 2, 0));
        } else {
            orgVO.setHeight(BigDecimal.ZERO);
        }
        orgVO.setLength(new BigDecimal(String.format("%.2f", sides.stream().filter(e -> null != e.getLength()).mapToDouble(SideSlopeInformation::getLength).sum())));
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            SideSlopeInformationManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4sideSlopelVO> getChild(List<Org4sideSlopelVO> allList, String pCode) {
        ArrayList<Org4sideSlopelVO> returnList = new ArrayList<Org4sideSlopelVO>();
        for (Org4sideSlopelVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(SideSlopeInformationManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private List<String> getOrgIds(String currentOrgId) {
        List orgList = this.orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }

    @Override
    public PageList<SideSlopCheckVo> querySideSlope(QueryFilter<SideSlopeInformation> queryFilter) throws Exception {
        String baseContextCurrentOrgId;
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)(baseContextCurrentOrgId = this.baseContext.getCurrentOrgId()))) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<SideSlopCheckVo> result = ((SideSlopeInformationDao)this.baseMapper).querySideSlope((IPage<SideSlopeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SideSlopeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (SideSlopCheckVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"SIDE_SLOPE_ID_", (Object)record.getId());
            List sideSlopeOftenChecks = this.slopeOftenCheckDao.selectList((Wrapper)queryWrapper);
            if (sideSlopeOftenChecks != null && sideSlopeOftenChecks.size() > 0) {
                SideSlopeOftenCheck sideSlopeOftenCheck = (SideSlopeOftenCheck)((Object)sideSlopeOftenChecks.get(0));
                record.setEvaluateValue(sideSlopeOftenCheck.getEvaluateValue());
                record.setRummager(sideSlopeOftenCheck.getRummager());
                record.setNoteTaker(sideSlopeOftenCheck.getNoteTaker());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public SideSlopeInformation getSideSlopeById(String id) {
        SideSlopeInformation sideSlopeInformation = (SideSlopeInformation)((Object)((SideSlopeInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        ArrayList<Accessory> accessoriesFrontView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesLateralView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesTwoDimensionalView = new ArrayList<Accessory>();
        if (accessories != null && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) {
                    accessoriesFrontView.add((Accessory)((Object)s));
                }
                if ("lateralView".equalsIgnoreCase(group)) {
                    accessoriesLateralView.add((Accessory)((Object)s));
                }
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) {
                    accessoriesTwoDimensionalView.add((Accessory)((Object)s));
                }
            });
        }
        sideSlopeInformation.setAccessoriesFrontView(accessoriesFrontView);
        sideSlopeInformation.setAccessoriesLateralView(accessoriesLateralView);
        sideSlopeInformation.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);
        return sideSlopeInformation;
    }

    @Override
    public void checkNumber(SideSlopeInformation sideSlopeInformation) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)sideSlopeInformation.getId())) {
            queryWrapper.notIn((Object)"id_", new Object[]{sideSlopeInformation.getId()});
        }
        queryWrapper.eq((Object)"NUMBER_", (Object)sideSlopeInformation.getNumber());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = ((SideSlopeInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("\u8be5\u8fb9\u5761\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @Override
    public Integer getSn() {
        HashMap<String, String> map = new HashMap<String, String>();
        IUser user = ContextUtil.getCurrentUser();
        if (ObjectUtils.isNotEmpty((Object)user)) {
            map.put("tenant_id_", user.getTenantId());
        }
        return this.getNextSequence(map);
    }

    @Override
    public PageList<SideSlopeInformation> querySideSlopeInformation(QueryFilter<SideSlopeInformation> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<SideSlopeInformation> result = ((SideSlopeInformationDao)this.baseMapper).querySideSlopeInformation((IPage<SideSlopeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SideSlopeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<SideSlopeRegularVo> queryRegularSideSlope(QueryFilter<SideSlopeInformation> queryFilter) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<SideSlopeRegularVo> result = ((SideSlopeInformationDao)this.baseMapper).querySideSlopeRegularCheckVo((IPage<SideSlopeInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SideSlopeInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (SideSlopeRegularVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"SIDE_SLOPE_ID_", (Object)record.getId());
            List sideSlopeRegularChecks = this.sideSlopeRegularCheckDao.selectList((Wrapper)queryWrapper);
            if (sideSlopeRegularChecks != null && sideSlopeRegularChecks.size() > 0) {
                record.setOverallRatingValue(((SideSlopeRegularCheck)((Object)sideSlopeRegularChecks.get(0))).getOverallRatingValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public void saveSideSlope(SideSlopeInformation sideSlopeInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.save((Object)sideSlopeInformation);
        List<Accessory> accessoriesFrontView = sideSlopeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = sideSlopeInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = sideSlopeInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public void updateSideSlope(SideSlopeInformation sideSlopeInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.update((Model)sideSlopeInformation);
        this.accessoryManager.delAccessoryBySourceId(sideSlopeInformation.getId());
        List<Accessory> accessoriesFrontView = sideSlopeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = sideSlopeInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = sideSlopeInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(sideSlopeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }
}

