/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.app.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/bizAPP/v1/"})
@Api(tags={"APP\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class AppController
extends BaseController<AccessoryManager, Accessory> {
    private static final Logger log = LoggerFactory.getLogger(AppController.class);
    @Resource
    private RedisUtil redisUtil;
    public static final String ROOT_PATH = System.getProperty("user.dir");
    public static final String DATA_TEMP_FILE = "appFile";
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + "appFile";
    public static String FILE_NNAME = "H5_YH_APP_V1.0.apk";
    public static String FILE_PATH = TEMP_DATA_EXCEL + File.separator + FILE_NNAME;

    @PostMapping(value={"/appUpload"})
    @ApiOperation(value="app\u4e0a\u4f20", httpMethod="POST", notes="app\u4e0a\u4f20")
    public CommonResult<String> minioDrawingUpload(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new BaseException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u7a7a\uff01");
        }
        String fileName = file.getOriginalFilename();
        String suffixName = fileName.substring(fileName.lastIndexOf("."));
        File dest = new File(FILE_PATH);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        file.transferTo(dest);
        return new CommonResult("APP\u4e0a\u4f20\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/appDownload"})
    @ApiOperation(value="app\u4e0b\u8f7d", httpMethod="POST", notes="app\u4e0b\u8f7d")
    public void minioUpload(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ServletOutputStream outp = response.getOutputStream();
        String ip = this.getVisitorIp(request);
        String key = "BIZ:APP:DOWNLOAD:" + ip;
        Object obj = this.redisUtil.get(key);
        int num = 1;
        if (obj != null) {
            num = (Integer)obj;
        }
        if (num > 3) {
            response.setHeader("content-type", "text/html;charset=utf-8");
            outp.write("<h1 style='font-size: 2vh;color: #f30707;font-weight: 600;'>\u60a8\u521a\u521a\u5df2\u4e0b\u8f7d\u8fc7\u4e86\uff0c\u8bf7\u4e24\u5206\u949f\u540e\u518d\u6b21\u5c1d\u8bd5\u4e0b\u8f7d\uff01!</h1>".getBytes("utf-8"));
        } else {
            this.redisUtil.set(key, (Object)(++num), 120L);
            String fullPath = FILE_PATH;
            String fileName = FILE_NNAME;
            File file = new File(fullPath);
            if (file.exists()) {
                response.setContentType("application/x-download");
                response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
                if (System.getProperty("file.encoding").equals("GBK")) {
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), "ISO-8859-1"));
                } else {
                    response.addHeader("Content-Disposition", "attachment;filename=" + fileName + ";filename*=utf-8''" + URLEncoder.encode(fileName, "utf-8"));
                }
                try (FileInputStream in = new FileInputStream(fullPath);){
                    IOUtils.copy((InputStream)in, (OutputStream)outp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (outp != null) {
                        outp.close();
                        outp = null;
                        response.flushBuffer();
                    }
                }
            } else {
                response.setHeader("content-type", "text/html;charset=utf-8");
                outp.write("<h1 style='font-size: 2vh;color: #f30707;font-weight: 600;'>\u6587\u4ef6\u4e0d\u5b58\u5728!</h1>".getBytes("utf-8"));
            }
        }
    }

    public String getVisitorIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("x-forwarded-for");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && "0:0:0:0:0:0:0:1".equals(ip = request.getRemoteAddr())) {
            ip = "unknown";
        }
        if ("unknown".equalsIgnoreCase(ip)) {
            ip = "unknown";
            return ip;
        }
        int index = ip.indexOf(44);
        if (index >= 0) {
            ip = ip.substring(0, index);
        }
        return ip;
    }
}

