package com.artfess.yhxt.statistics.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class Org4RescueVO {
    /**
     * 主键
     */

    @ApiModelProperty(name = "id", notes = "组织id")
    protected String id;

    /**
     * name_
     */

    @ApiModelProperty(name = "name", notes = "组织名称")
    protected String name;

    /**
     * prent_id_
     */

    @ApiModelProperty(name = "parentId", notes = "组织父节点id")
    protected String parentId;

    /**
     * code_
     */

    @ApiModelProperty(name = "code", notes = "组织编码")
    protected String code;

    /**
     * 级别
     */

    @ApiModelProperty(name = "grade", notes = "组织级别")
    protected String grade;

    /**
     * 组织类型（ogn,dept）
     */

    @ApiModelProperty(name = "orgKind", notes = "组织类型（ogn,dept）")
    protected String orgKind;

    /**
     * 维度Id
     */

    @ApiModelProperty(name = "demId", notes = "维度id")
    protected String demId;


    @ApiModelProperty(name = "orderNo", notes = "序号")
    protected Long orderNo;

    /**
     * 上级组织名称
     */

    @ApiModelProperty(name = "parentOrgName", notes = "上级组织名称")
    protected String parentOrgName;

    /**
     * 是否主组织。
     */
    @TableField(exist = false)
    @ApiModelProperty(name = "isMaster", notes = "是否主组织")
    private int isMaster = 0;

    /**
     * /**
     * 路径
     */

    @ApiModelProperty(name = "path", notes = "路径")
    protected String path;

    /**
     * 组织路径名
     */

    @ApiModelProperty(name = "pathName", notes = "组织路径名")
    protected String pathName;
    /**
     * 是否有子节点   否0  是1
     */

    @ApiModelProperty(name = "isIsParent", notes = "是否有子节点   否0  是1")
    protected int isIsParent = 0;

    /**
     * 组织参数
     */
    @TableField(exist = false)
    @ApiModelProperty(name = "params", notes = "组织参数（获取单个组织时才会有值）")
    protected Map<String, Object> params;

    /**
     * 维度名称
     */
    @TableField(exist = false)
    @ApiModelProperty(name = "demName", notes = "所属维度")
    protected String demName;

    @TableField(exist = false)
    @ApiModelProperty(name = "demCode")
    protected String demCode;

    /**
     * OA关联ID
     */
    @TableField(exist = false)
    @ApiModelProperty(name = "refId", notes = "OA关联ID")
    protected String refId;

    /**
     * 组织用户关联id
     */
    @TableField(exist = false)
    @ApiModelProperty(name = "orgUserId", notes = "组织用户关联id")
    protected String orgUserId;


    @ApiModelProperty(name = "limitNum", notes = "组织限编用户数量(0:不受限制)")
    protected Integer limitNum = 0;


    @ApiModelProperty(name = "nowNum", notes = "组织现编用户数量")
    protected Integer nowNum;


    @ApiModelProperty(name = "exceedLimitNum", notes = "是否允许超过限编(0:允许；1:不允许)")
    protected Integer exceedLimitNum = 0;

    private List<Org4RescueVO> chirldren;


    @ApiModelProperty(value = "救援点数量")
    private int countNum;

    @ApiModelProperty(value = "人员数量")
    private int peopleNum;


    @ApiModelProperty(value = "路段id(关联路段表ID)")
    private String roadSegmentId;


}
