package com.artfess.yhxt.statistics.dao;


import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.statistics.model.ParamEntity;
import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;


import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/9/1
 */
public interface BaseDataStatisticsMapper {
    //桥梁类型
    List<Map<String, Object>> getBridgeType(@Param("map") Map<String, Object> map);

    //上部结构类别
    List<Map<String, Object>> getBridgeShapeType(@Param("map") Map<String, Object> map);

    //桥梁类别
    List<Map<String, Object>> getBridgeCategory(@Param("map") Map<String, Object> map);

    //边坡
    List<Map<String, Object>> getSideSlopeCount(@Param("map") Map<String, Object> map);

    //沿线设施
    List<Map<String, Object>> getRoadsideFacilities(@Param("map") Map<String, Object> map);

    //路段
    List<Map<String, Object>> getRoadSection(@Param("map") Map<String, Object> map);

    //桥梁
    List<Map<String, Object>> getBridge(@Param("map") Map<String, Object> map);

    //隧道
    List<Map<String, Object>> getTunnel(@Param("map") Map<String, Object> map);

    //涵洞
    List<Map<String, Object>> getCulvert(@Param("map") Map<String, Object> map);

    //各个分公司高危边坡数量
    List<Map<String, Object>> getSideSlopCompany();

    List<Map<String, Object>> getRoadsideFacilitiesCompany();

    List<Map<String, Object>> getRoadSectionCompany();

    List<Map<String, Object>> getBridgeCompany();

    List<Map<String, Object>> getTunnelCompany();

    List<Map<String, Object>> getCulvertCompany();

    //桥梁排行
    List<Map<String, Object>> getBridgeCountRanking();


    //隧道排行榜
    List<Map<String, Object>> getTunnelCountRanking();


    //隧道类型
    List<Map<String, Object>> getTunnelType(Map<String, Object> map);

    //隧道等级
    List<Map<String, Object>> getTunnelGrade(Map<String, Object> map);

    //里程统计

    List<Map<String, Object>> getMileage();


    MileageVo getMileageCount(@Param("id") String id, @Param("name") String name);

    List<MileageVo> getRoadMileageCount(@Param("baseDataParamVo") BaseDataParamVo baseDataParamVo);

    //养护站数量统计
    Integer selectOrgList(@Param("id") String id);

    Integer userManageCount(@Param("userIds") List<String> userIds);

    Integer userInspectionCount(@Param("userIds") List<String> userIds);

    Integer userMaintainCount(@Param("userIds") List<String> userIds);

    Integer userConstructionCount(@Param("companyId")String companyId,@Param("companyName")String companyName);

    List<Road> getRoad(@Param("map") Map<String, Object> map);

    List<BizRoadsideFacilities> getRoadside(@Param("map") Map<String, Object> map);

    List<SideSlopeInformation> getSideSlop(@Param("map") Map<String, Object> map);

    List<BridgeInformation> getBridgeInformation(@Param("map") Map<String, Object> map);

    List<TunnelInformation> getTunnelInformation(@Param("map") Map<String, Object> map);

    List<BizCulvertInformation> getCulvertInformation(@Param("map") Map<String, Object> map);
//  查询养护站个数
    List<MaintenanceStationVo> getMaintenanceStationCount(@Param("baseDataParamVo") BaseDataParamVo baseDataParamVo);

    List<CompanyUserVo> selectCompanyUser(@Param("baseDataParamVo") BaseDataParamVo baseDataParamVo);

    List<CountRoadsideFacilities> countRoadsideFacilities(@Param("baseDataParamVo")  BaseDataParamVo baseDataParamVo);

    Integer countVehicle(@Param("map") Map map,@Param("roadSegmentId") String roadSegmentId);

    Map countMileage(@Param("map") Map map);

    CompanyUserVo selectRoadSegmentUser(@Param("baseDataParamVo") BaseDataParamVo baseDataParamVo);

    //沿线设施-收费站
    List<Map<String, Object>> getRoadsideFacilitiesTollStation(Map<String, Object> map);
    //沿线设置-服务区
    List<Map<String, Object>> getRoadsideFacilitiesServiceArea(Map<String, Object> map);

    List<VehicleQuantityVo> countVehicleQuantity();

}
