package com.artfess.yhxt.specialproject.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 项目合同明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@ApiModel(value="BizProjectContractDetails对象", description="项目合同明细表")
@TableName("biz_project_contract_details")
public class BizProjectContractDetails extends BizModel<BizProjectContractDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合同明细表id")
    @TableField("CONTRACT_DETAIL_ID_")
    private String contractDetailId;

    @ApiModelProperty(value = "合同表id")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "序号")
    @TableField("SUBJECT_SORT_")
    private String subjectSort;

    @ApiModelProperty(value = "科目编码")
    @TableField("SUBJECT_NUMBER_")
    private String subjectNumber;

    @ApiModelProperty(value = "科目名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "细科目编码")
    @TableField("SUB_SUBJECT_NUMBER_")
    private String subSubjectNumber;

    @ApiModelProperty(value = "细科目名称")
    @TableField("SUB_SUBJECT_NAME_")
    private String subSubjectName;

    @ApiModelProperty(value = "单位")
    @TableField("SUBJECT_UNIT_")
    private String subjectUnit;

    @ApiModelProperty(value = "单价（元）")
    @TableField("SUBJECT_PRICE_")
    private BigDecimal subjectPrice;

    @ApiModelProperty(value = "数量")
    @TableField("SUBJECT_AMOUNT_")
    private BigDecimal subjectAmount;

    @ApiModelProperty(value = "金额（元）")
    @TableField("SUBJECT_MONEY_")
    private BigDecimal subjectMoney;

    @ApiModelProperty(value = "完成已计量数量")
    @TableField("COMPLETE_AMOUNT_")
    private BigDecimal completeAmount;

    @ApiModelProperty(value = "完成已计量金额（元）")
    @TableField("PAID_MONEY_")
    private BigDecimal paidMoney;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(String contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSubjectSort() {
        return subjectSort;
    }

    public void setSubjectSort(String subjectSort) {
        this.subjectSort = subjectSort;
    }

    public String getSubjectNumber() {
        return subjectNumber;
    }

    public void setSubjectNumber(String subjectNumber) {
        this.subjectNumber = subjectNumber;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubSubjectName() {
        return subSubjectName;
    }

    public void setSubSubjectName(String subSubjectName) {
        this.subSubjectName = subSubjectName;
    }

    public String getSubjectUnit() {
        return subjectUnit;
    }

    public void setSubjectUnit(String subjectUnit) {
        this.subjectUnit = subjectUnit;
    }

    public BigDecimal getSubjectPrice() {
        return subjectPrice;
    }

    public void setSubjectPrice(BigDecimal subjectPrice) {
        this.subjectPrice = subjectPrice;
    }

    public BigDecimal getSubjectAmount() {
        return subjectAmount;
    }

    public void setSubjectAmount(BigDecimal subjectAmount) {
        this.subjectAmount = subjectAmount;
    }

    public BigDecimal getSubjectMoney() {
        return subjectMoney;
    }

    public void setSubjectMoney(BigDecimal subjectMoney) {
        this.subjectMoney = subjectMoney;
    }

    public BigDecimal getCompleteAmount() {
        return completeAmount;
    }

    public void setCompleteAmount(BigDecimal completeAmount) {
        this.completeAmount = completeAmount;
    }

    public BigDecimal getPaidMoney() {
        return paidMoney;
    }

    public void setPaidMoney(BigDecimal paidMoney) {
        this.paidMoney = paidMoney;
    }

    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getSubSubjectNumber() {
        return subSubjectNumber;
    }

    public void setSubSubjectNumber(String subSubjectNumber) {
        this.subSubjectNumber = subSubjectNumber;
    }

    @Override
    public String toString() {
        return "BizProjectContractDetails{" +
            "id=" + id +
            ", contractDetailId=" + contractDetailId +
            ", contractId=" + contractId +
            ", remarks=" + remarks +
            ", subjectSort=" + subjectSort +
            ", subjectNumber=" + subjectNumber +
            ", subjectName=" + subjectName +
            ", subSubjectNumber=" + subSubjectNumber +
            ", subSubjectName=" + subSubjectName +
            ", subjectUnit=" + subjectUnit +
            ", subjectPrice=" + subjectPrice +
            ", subjectAmount=" + subjectAmount +
            ", subjectMoney=" + subjectMoney +
            ", completeAmount=" + completeAmount +
            ", paidMoney=" + paidMoney +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
