package com.artfess.yhxt.specialcheck.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.math.BigDecimal;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * MQI检查数据表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizMqiCheckData对象", description="MQI检查数据表")
@TableName("biz_mqi_check_data")
@Data
public class BizMqiCheckData extends BizModel<BizMqiCheckData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "年份")
    @TableField("YEAR_")
    private Integer year;

    @ApiModelProperty(value = "年份值")
    @TableField("YEAR_VALUE_")
    private String yearValue;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    private LocalDate checkDate;

    @ApiModelProperty(value = "车道")
    @TableField("LANE_")
    private String lane;

    @ApiModelProperty(value = "车道中文值")
    @TableField("LANE_VALUE_")
    private String laneValue;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "路段ID(关联路段表ID)，弹窗选择")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "路线ID，选择路段时带入")
    @TableField("ROUTE_ID_")
    private String routeId;

    @ApiModelProperty(value = "路线名称，选择路段时带入")
    @TableField("ROUTE_NAME_")
    private String routeName;

    @ApiModelProperty(value = "MQI平均数")
    @TableField("MQI_AVERAGE_")
    private BigDecimal mqiAverage;


}
