package com.artfess.yhxt.contract.vo;

import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.Contract;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.disease.model.Disease;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhx
 * @create 2021/9/4
 */
@Data
@ApiModel(value = "WorkOrderInformation vo对象", description = "工单信息Vo")
public class WorkOrderInformationVo {

    @ApiModelProperty(value = "工单信息实体")
    private WorkOrderInformation workOrderInformation;
    @ApiModelProperty(value = "合同内工程量清单")
    private List<BillOfQuantities> billOfQuantities;
    @ApiModelProperty(value = "合同外工程量清单")
    private List<BillOfQuantities> billOutOfQuantities;
    @ApiModelProperty(value = "病害")
    private List<Disease> diseases;
    @ApiModelProperty(value = "养护合同")
    private Contract contract;
    @ApiModelProperty(value = "工程图片-施工前")
    private List<Accessory> accessoriesPre;
    @ApiModelProperty(value = "工程图片-施工中")
    private List<Accessory> accessoriesUnd;
    @ApiModelProperty(value = "工程图片-施工后")
    private List<Accessory> accessoriesSuf;
    @ApiModelProperty(value = "派单附件")
    private List<Accessory> accessoriesWorkOrder;
}
