package com.artfess.yhxt.contract.manager;

import com.artfess.yhxt.contract.vo.WorkOrderParamVo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 工单导出
 * @author zhx
 * @create 2022/6/7
 */
public interface WorkOrderExportManager {
    /**
     * 工程(中期计量、完工结算)清单表
     * @param param
     * @param response
     */
    void exportWorkOrders(WorkOrderParamVo param, HttpServletResponse response) throws Exception;


    void exportWorkOrdersConstruction(WorkOrderParamVo param, HttpServletResponse response) throws Exception;

    /**
     * 工程量汇总表
     * @param param
     * @param response
     */
    void exportWorkOrdersQuantities(WorkOrderParamVo param, HttpServletResponse response) throws Exception;

    void exportWorkOrdersQuantitiesConstruction(WorkOrderParamVo param, HttpServletResponse response)throws Exception;
    /**
     * 工程收方记录表（施工类）
     * @param param
     * @param response
     */
    void exportWorkOrdersDebitRecord(WorkOrderParamVo param, HttpServletResponse response) throws Exception;



    void exportWorkOrdersDebitRecordConstruction(WorkOrderParamVo param, HttpServletResponse response)throws Exception;


}
