package com.artfess.yhxt.businessdata.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.businessdata.model.Company;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.businessdata.vo.CompanyVo;

import java.util.List;

/**
 * 养护单位 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-05
 */
public interface CompanyManager extends BaseManager<Company> {
    /**
     * @Description: 不分页查询涵洞
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<Company> queryCompany(QueryFilter<Company> queryFilter);

    /**
     * 根据id删除养护单位信息
     * @param code
     */
    void removeCompanyByIds(List<String> list,String code) throws Exception;


    void saveCompany(Company company) throws Exception;

    void updateCompany(Company company) throws Exception;

    List<CompanyVo> getTree(String demId, List<String> grades);



    List<Org> getCompany(QueryFilter queryFilter);

    /**
     * 获取公司树
     * @param demId
     * @return
     */
    List<CompanyVo> getTreeCompany(String demId);
    //List<Org> getCompany();

    /**
     * 统计报表下拉框
     * @param demId
     * @return
     */
    List<CompanyVo> getTreeNewCompany(String demId);
}
