package com.artfess.yhxt.budget.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 年度总预算表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
@ApiModel(value="BizYearBudget对象", description="年度总预算表")
@TableName("BIZ_YEAR_BUDGET")
@Data
public class YearBudget extends BizModel<YearBudget> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;


    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "预算总额")
    @TableField("BUDGET_SUM_")
    private BigDecimal budgetSum;

    @ApiModelProperty(value = "已用总额")
    @TableField("ALREADY_COUNT_")
    private BigDecimal alreadyCount;

    @ApiModelProperty(value = "所属年限")
    @TableField("ASCRIPTION_YEAR_")
    private Integer ascriptionYear;

    @ApiModelProperty(value = "开始时间")
    @TableField("START_TIME_")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("END_TIME_")
    private String endTime;

    @ApiModelProperty(value = "预算单状态，0：草稿，2：待审批，3：已审批")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;


}
