package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.CulvertCheckVo;
import com.artfess.yhxt.basedata.vo.CulvertRegularVo;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.statistics.vo.Org4culvertVO;

import java.text.ParseException;
import java.util.List;

/**
 * 涵洞信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-28
 */
public interface BizCulvertInformationManager extends BaseManager<BizCulvertInformation> {
    /**
     * @Description: 不分页查询涵洞
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<BizCulvertInformation> queryBizCulvertInformation(QueryFilter<BizCulvertInformation> queryFilter);

    /**
     * 逻辑删除
     * @param id
     */

    void updateBizCulvertInformation(String id);

    /**
     * 涵洞经常检查
     * @param queryFilter
     * @return
     */
    PageList<CulvertCheckVo> queryBizCulvert(QueryFilter<BizCulvertInformation> queryFilter) throws Exception;

    PageList<CulvertRegularVo> queryCulvertRegular(QueryFilter<BizCulvertInformation> queryFilter) throws Exception;

    //添加涵洞
    void saveCulvert(BizCulvertInformation bizCulvertInformation);

    //修改涵洞
    void updateCulvert(BizCulvertInformation bizCulvertInformation);

    //根据ID查询
    BizCulvertInformation getByCulvertId(String id);


    List<Org4culvertVO> getCulvertCount();
}
