package com.artfess.yhxt.assessment.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.assessment.vo.CuringAssessmentItemFlagVo;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.model.InspectionTaskConfig;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.assessment.model.CuringAssessmentItem;
import com.artfess.yhxt.assessment.manager.CuringAssessmentItemManager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 养护考核项目表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
@RestController
@Slf4j
@RequestMapping("/assessment/curingAssessmentItem/v1/")
@Api(tags = "养护考核项目接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CuringAssessmentItemController extends BaseController<CuringAssessmentItemManager, CuringAssessmentItem> {


    @RequestMapping(value = "/saveCuringAssessment", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改养护考核项目信息", httpMethod = "POST")
    public CommonResult<String> saveCuringAssessment(@ApiParam(name = "curingAssessmentItem", value = "养护考核项目对象")
                                                     @RequestBody CuringAssessmentItem curingAssessmentItem) throws Exception {

        if (StringUtils.isEmpty(curingAssessmentItem.getId())) {
            curingAssessmentItem.setIsDele("0");
            HashMap<String, Object> map = new HashMap<>();
            map.put("IS_DELE_", "0");
            curingAssessmentItem.setSn(baseService.getNextSequence(map));
            baseService.create(curingAssessmentItem);
        } else {
            baseService.updateById(curingAssessmentItem);
        }
        return new CommonResult<String>(true,"数据保存成功", curingAssessmentItem.getId());
    }


    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateStatus(@RequestBody CuringAssessmentItemFlagVo curingAssessmentItemFlagVo) throws Exception {
        String ids = curingAssessmentItemFlagVo.getIds();
        Integer flag = curingAssessmentItemFlagVo.getFlag();
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<CuringAssessmentItem> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("FLAG_",flag);
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "修改成功");
    }


    @ApiOperation(value = "修改排序号", httpMethod = "POST", notes = "key:功能id,value:排序号")
    @PostMapping(value = "/updateSequence")
    public CommonResult<String> updateShareCatalogSequence(@RequestBody HashMap<String, Integer> params) throws Exception{
        baseService.updateSequence(params);
        return new CommonResult<>(true, "修改成功");
    }
}
