package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.model.ProjectContractPayment;
import com.artfess.yhxt.specialproject.dao.ProjectContractPaymentDao;
import com.artfess.yhxt.specialproject.manager.ProjectContractPaymentManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.ProjectContractPaymentVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目合同支付表 服务实现类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-19
 */
@Service
public class ProjectContractPaymentManagerImpl extends BaseManagerImpl<ProjectContractPaymentDao, ProjectContractPayment> implements ProjectContractPaymentManager {

    @Resource
    private BizProjectContractManager bizProjectContractManager;

    @Override
    public PageList<ProjectContractPayment> queryProjectContractPayment(QueryFilter<ProjectContractPayment> queryFilter) {
        IPage<ProjectContractPayment> result = baseMapper.queryProjectContractPayment(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void createProjectContractPayment(List<ProjectContractPayment> paymentList, String contractId) {
        for (ProjectContractPayment payment : paymentList) {
            payment.setIsDele("0");
            payment.setContractId(contractId);
        }
        this.saveOrUpdateBatch(paymentList);
    }

    @Override
    public void importDatePay(MultipartFile file, String contractId) {
        List<Map<String, String>> mapList = ExcelUtil.ImportDate(file);
        ArrayList<ProjectContractPayment> payments = new ArrayList<>();
        for (Map<String, String> map : mapList) {
            ProjectContractPayment contractPayment = new ProjectContractPayment();
            String projectCode = map.get("项目编码");
            String subjectCode = map.get("子项目编码");
            String unit = map.get("单位");
            Double amount = Double.parseDouble(map.get("数量"));
            Double price = Double.parseDouble(map.get("单价"));
            Double totalPrice = Double.parseDouble(map.get("总价"));
            String date = map.get("支付日期");
            LocalDate payDate = LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            contractPayment.setProjectCode(projectCode);
            contractPayment.setSubjectCode(subjectCode);
            contractPayment.setUnit(unit);
            contractPayment.setAmount(amount);
            contractPayment.setPrice(price);
            contractPayment.setTotalPrice(totalPrice);
            contractPayment.setPayDate(payDate);
            //contractPayment.setContractId(contractId);
            contractPayment.setIsDele("0");
            payments.add(contractPayment);
        }
        this.createProjectContractPayment(payments,contractId);
    }

    @Override
    public ProjectContractPaymentVo getVo(String id) {
        if (StringUtils.isBlank(id))
            return null;
        BizProjectContract projectContract = this.bizProjectContractManager.get(id);
        ProjectContractPaymentVo vo = new ProjectContractPaymentVo();

        if (StringUtils.isNotBlank(id)) {
            QueryWrapper<ProjectContractPayment> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("CONTRACT_ID_", id);
            queryWrapper.eq("is_dele_", "0");
            List<ProjectContractPayment> paymentList = baseMapper.selectList(queryWrapper);

            vo.setPaymentList(paymentList);
        }
        vo.setBizProjectContract(projectContract);
        return vo;
    }

    @Override
    public void downTemplate(HttpServletResponse response) throws IOException {
        String filePath = "template";

        File path = new File("template");
        if (!path.exists()) {
            path.mkdirs();
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("合同支付明细");

        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < 7; i++) {
            XSSFCell cell = row.createCell(i);
            switch (i) {
                case 0:
                    cell.setCellValue("项目编码");
                    break;
                case 1:
                    cell.setCellValue("子项目编码");
                    break;
                case 2:
                    cell.setCellValue("单位");
                    break;
                case 3:
                    cell.setCellValue("数量");
                    break;
                case 4:
                    cell.setCellValue("单价");
                    break;
                case 5:
                    cell.setCellValue("总价");
                    break;
                case 6:
                    cell.setCellValue("支付日期");
                    break;

                default:
                    break;
            }
        }
        FileOutputStream out = new FileOutputStream(filePath+"/合同支付明细导入模板.xlsx");
        //保存Excel文件
        workbook.write(out);
        //关闭文件流
        out.close();
        HttpUtil.downLoadFile(response, "template/合同支付明细导入模板.xlsx", "合同支付明细导入模板.xlsx");
    }

    @Override
    public void exportDatePay(String ids,HttpServletResponse response) throws Exception {
        List<String> list = Arrays.asList(ids.split(","));
        if (list.size() > 0) {
            QueryWrapper<ProjectContractPayment> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("ID_", list);
            List<ProjectContractPayment> paymentList = this.baseMapper.selectList(queryWrapper);
            //文件路径
            String filePath = "pay/合同支付明细.xlsx";
            File path = new File("pay");
            if (!path.exists()) {
                path.mkdirs();
            }
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("合同支付明细");

            XSSFRow row = sheet.createRow(0);
            for (int i = 0; i < 7; i++) {
                XSSFCell cell = row.createCell(i);
                switch (i) {
                    case 0:
                        cell.setCellValue("项目编码");
                        break;
                    case 1:
                        cell.setCellValue("子项目编码");
                        break;
                    case 2:
                        cell.setCellValue("单位");
                        break;
                    case 3:
                        cell.setCellValue("数量");
                        break;
                    case 4:
                        cell.setCellValue("单价");
                        break;
                    case 5:
                        cell.setCellValue("总价");
                        break;
                    case 6:
                        cell.setCellValue("支付日期");
                        break;
                    default:
                        break;
                }
            }

            for (int i = 0; i < paymentList.size() ; i++) {
                ProjectContractPayment payment = paymentList.get(i);
                XSSFRow row1 = sheet.createRow(i+1);
                    for (int j = 0; j < 7; j++) {
                        XSSFCell cell = row1.createCell(j);
                        switch (j) {
                            case 0:
                                String projectCode = payment.getProjectCode();
                                cell.setCellValue(projectCode);
                                break;
                            case 1:
                                String subjectCode = payment.getSubjectCode();
                                cell.setCellValue(subjectCode);
                                break;
                            case 2:
                                String unit = payment.getUnit();
                                cell.setCellValue(unit);
                                break;
                            case 3:
                                String value = payment.getAmount().toString();
                                cell.setCellValue(value);
                                break;
                            case 4:
                                String value1 = payment.getPrice().toString();
                                cell.setCellValue(value1);
                                break;
                            case 5:
                                String value2 = payment.getTotalPrice().toString();
                                cell.setCellValue(value2);
                                break;
                            case 6:
                                cell.setCellValue(payment.getPayDate().toString());
                                break;
                            default:
                                break;
                        }
                    }


            }

            FileOutputStream out = new FileOutputStream(filePath);
            //保存Excel文件
            workbook.write(out);
            //关闭文件流
            out.close();
            HttpUtil.downLoadFile(response,filePath,filePath.substring(filePath.lastIndexOf("/")+1));
            FileUtil.deleteFile(filePath);
            System.out.println("OK!");


        }
    }

    /*public static void main(String[] args) throws IOException {
        //文件路径
        String filePath = "F:\\worksoft\\sample.xlsx";
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("合同支付明细");

        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < 7; i++) {
            XSSFCell cell = row.createCell(i);
            switch (i) {
                case 0:
                    cell.setCellValue("项目编码");
                    break;
                case 1:
                    cell.setCellValue("子项目编码");
                    break;
                case 2:
                    cell.setCellValue("单位");
                    break;
                case 3:
                    cell.setCellValue("数量");
                    break;
                case 4:
                    cell.setCellValue("单价");
                    break;
                case 5:
                    cell.setCellValue("总价");
                    break;
                case 6:
                    cell.setCellValue("支付日期");
                    break;

                default:
                    break;
            }
        }
        FileOutputStream out = new FileOutputStream(filePath);
        //保存Excel文件
        workbook.write(out);
        //关闭文件流
        out.close();

        System.out.println("OK!");
    }*/
}
