package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizInspectionRecordsOfSupervision;
import com.artfess.yhxt.specialproject.model.BizInspectionRecordsOfSupervision;
import com.artfess.yhxt.specialproject.dao.BizInspectionRecordsOfSupervisionDao;
import com.artfess.yhxt.specialproject.manager.BizInspectionRecordsOfSupervisionManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizInspectionRecordsOfSupervision;
import com.artfess.yhxt.specialproject.vo.BizInspectionRecordsOfSupervisionVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 监理巡查记录表 服务实现类
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-16
 */
@Service
public class BizInspectionRecordsOfSupervisionManagerImpl extends BaseManagerImpl<BizInspectionRecordsOfSupervisionDao, BizInspectionRecordsOfSupervision> implements BizInspectionRecordsOfSupervisionManager {
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizInspectionRecordsOfSupervision> queryBizInspectionRecordsOfSupervision(QueryFilter<BizInspectionRecordsOfSupervision> queryFilter) {
        IPage<BizInspectionRecordsOfSupervision> result = baseMapper.queryBizInspectionRecordsOfSupervision(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizInspectionRecordsOfSupervision getBizInspectionRecordsOfSupervisionById(String id) {
        BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision = baseMapper.selectById(id);
        return bizInspectionRecordsOfSupervision;
    }

    @Override
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper<BizInspectionRecordsOfSupervision> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("VALID_FLAG_", flag).in("ID_", idsList);
        this.baseMapper.update(null, updateWrapper);
    }

    @Override
    public void saveVo(BizInspectionRecordsOfSupervisionVo bizInspectionRecordsOfSupervisionVo) {
        //监理巡查记录
        BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision = bizInspectionRecordsOfSupervisionVo.getBizInspectionRecordsOfSupervision();
        this.create(bizInspectionRecordsOfSupervision);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizInspectionRecordsOfSupervisionVo.getBizEngineeringAccessoriesList();
        String sourceId = bizInspectionRecordsOfSupervision.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizInspectionRecordsOfSupervisionVo bizInspectionRecordsOfSupervisionVo) {
        //监理巡查记录
        BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision = bizInspectionRecordsOfSupervisionVo.getBizInspectionRecordsOfSupervision();
        this.update(bizInspectionRecordsOfSupervision);
        String sourceId = bizInspectionRecordsOfSupervision.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizInspectionRecordsOfSupervisionVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizInspectionRecordsOfSupervisionVo getVo(String id) {
        BizInspectionRecordsOfSupervisionVo bizProjectBeginApplyForEngineeringVo= new BizInspectionRecordsOfSupervisionVo();
        BizInspectionRecordsOfSupervision bizInspectionRecordsOfSupervision = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectBeginApplyForEngineeringVo.setBizInspectionRecordsOfSupervision(bizInspectionRecordsOfSupervision);
        bizProjectBeginApplyForEngineeringVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectBeginApplyForEngineeringVo;
    }
}
