package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.BizProjectBiddingVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 项目招投标信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-17
 */
public interface BizProjectBiddingManager extends BaseManager<BizProjectBidding> {

    PageList<BizProjectBidding> queryBizProjectBidding(QueryFilter<BizProjectBidding> queryFilter);

    BizProjectBidding getBizProjectBiddingById(String id);

    String minioUpload(MultipartFile file);

    /**
     *保存项目招投标、附件信息
     * @param bizProjectBiddingVo
     */
    void saveVo(BizProjectBiddingVo bizProjectBiddingVo);

    /**
     * 修改项目招投标、附件信息
     * @param bizProjectBiddingVo
     */
    void updateVo(BizProjectBiddingVo bizProjectBiddingVo);

    /**
     * 根据ID查询招投标、附件信息
     * @param id
     * @return
     */
    BizProjectBiddingVo getVo(String id);
}
