package com.artfess.yhxt.specialcheck.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialcheck.vo.*;

import java.util.Map;

/**
 * 巡检表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-12
 */
public interface SiteInspectionManager extends BaseManager<SiteInspection> {

    /**
     * 分页查询巡检接口
     * @param queryFilter
     * @return
     */
    PageList<SiteInspectionVo> querySiteInspection(QueryFilter<SiteInspection> queryFilter);

    SiteDiseaseVo getSiteInspectionById(String id);

    /**
     * 流程日志
     * @param queryFilter
     * @return
     */
    PageList<DefaultBpmCheckOpinionVo> getSiteInspectionStatus(QueryFilter queryFilter);


    /**
     * 状态
     * @param queryFilter
     * @return
     */
    PageList<SiteInspectionTaskVo> getSiteInspectionTask(QueryFilter queryFilter);

    /**
     *保存巡检信息和工单信息
     * @param vo
     */
    SiteInspectionDiseaseVo saveSiteDiseaseVo(SiteInspectionDiseaseVo vo);

    /**
     * 保存巡检
     * @param siteInspection
     * @return
     */
    SiteInspection saveSite(SiteInspection siteInspection);


    void updateSitestatus(SiteTaskVo siteTaskVo);

    PageList<SiteInspectionVo> queryTaskHistory(QueryFilter<SiteInspection> queryFilter);

    /**
     * 巡检工单导出
     * @param ids
     */
    void exportSite(String ids);
}
