package com.artfess.yhxt.disease.model;

import com.artfess.base.entity.BizNoModel;
import com.artfess.yhxt.basedata.model.Accessory;
import com.baomidou.mybatisplus.annotation.*;

import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 病害管理表
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-09
 */
@ApiModel(value = "Disease对象", description = "病害管理表")
@TableName("BIZ_DISEASE")
@Data
public class Disease extends BizNoModel<Disease> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "巡检编号，例如XJ_20210630003")
    @TableField("ORDER_ID_")
    private String orderId;

    @ApiModelProperty(value = "巡检类别，下拉选择，1：日巡检，2：夜巡检，3：桥梁经常检查，4：隧道经常检查，5：涵洞经常检查，6：边坡经常检查，7：桥梁定期检查，8：隧道定期检查，9：涵洞定期检查，10：边坡定期检查")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "巡检类别名称")
    @TableField("TYPE_NAME_")
    private String typeName;

    @ApiModelProperty(value = "方向编码，下拉选择，1：上行方向，2下行方向，3：上下双行")
    @TableField("DIRECTION_")
    private Integer direction;

    @ApiModelProperty(value = "方向名称")
    @TableField("DIRECTION_NAME_")
    private String directionName;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private String startPeg;

    @ApiModelProperty(value = "结束桩号")
    @TableField("END_PEG_")
    private String endPeg;

    @ApiModelProperty(value = "病害类别ID，下拉选择，参考成本科目管理")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "病害类别名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "病害类别细目ID，下拉选择，参考成本科目")
    @TableField("DETAILS_ID_")
    private String detailsId;

    @ApiModelProperty(value = "病害细目名称")
    @TableField("DSUBJECT_NAME_")
    private String dsubjectName;

    @ApiModelProperty(value = "病害部位编码，使用系统字典，每个结构物不一样")
    @TableField("POSITION_")
    private String position;

    @ApiModelProperty(value = "病害部位名称")
    @TableField("POSITION_NAME_")
    private String positionName;

    @ApiModelProperty(value = "处理情况，0：未处理，1：处理中，2：已处理，3：观察记录，4：已上报")
    @TableField("HANDLING_SITUATION_")
    private Integer handlingSituation;

    @ApiModelProperty(value = "病害描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "病害长")
    @TableField("PARAM_LENGTH_")
    private String paramLength;

    @ApiModelProperty(value = "病害宽")
    @TableField("PARAM_WIDTH_")
    private String paramWidth;

    @ApiModelProperty(value = "病害高")
    @TableField("PARAM_HEIGHT_")
    private String paramHeight;

    @ApiModelProperty(value = "路段ID")
    @TableField("ROAD_ID_")
    private String roadId;

    @ApiModelProperty(value = "路段名称")
    @TableField("ROAD_NAME_")
    private String roadName;

    @ApiModelProperty(value = "关联巡检类型,和type字段保持一致")
    @TableField("RELEVANCE_TYPE_")
    private Integer relevanceType;

    @ApiModelProperty(value = "是否暂存，0：否，1：是")
    @TableField("TEMPORARY_")
    private Integer temporary;

    @ApiModelProperty(value = "超时日期")
    @TableField("DEADLINE_")
    private LocalDateTime deadline;

    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime checkDate;

    @ApiModelProperty(value = "处理时间")
    @TableField("HANDLED_TIME_")
    private LocalDateTime handledTime;

    @ApiModelProperty(value = "处理工单编号")
    @TableField("JOB_NUMBER_")
    private String jobNumber;

    @ApiModelProperty(value = "处理开始日期")
    @TableField("HANDLED_TIME_START_")
    private LocalDateTime handledTimeStart;

    @ApiModelProperty(value = "处理结束日期")
    @TableField("HANDLED_TIME_END_")
    private LocalDateTime handledTimeEnd;

    @ApiModelProperty(value = "超时开始日期")
    @TableField("DEADLINE_START_")
    private LocalDateTime deadlineStart;

    @ApiModelProperty(value = "超时结束日期")
    @TableField("DEADLINE_END_")
    private LocalDateTime deadlineEnd;

    @ApiModelProperty(value = "审批状态")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "超时状态，0：未超时，1：已超时")
    @TableField("DEADLINE_STATUS_")
    private Integer deadlineStatus;

    @ApiModelProperty(value = "关联巡检ID")
    @TableField("RELEVANCE_ID_")
    private String relevanceId;

    @ApiModelProperty(value = "病害附件")
    @TableField(exist = false)
    private List<Accessory> accessories;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_ACCOUNT_")
    private String createAccount;
    @ApiModelProperty(value = "病害类别(1 路基 2 路面 3 桥梁 4 隧道 5 涵洞 6边坡 7绿化 8交安)")
    @TableField("DISEASE_CATEGORY_")
    private String diseaseCategory;
    @ApiModelProperty(value = "病害类型值")
    @TableField("DISEASE_CATEGORY_VALUE_")
    private String diseaseCategoryValue;


}
