package com.artfess.yhxt.contract.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 工程量清单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-18
 */
@ApiModel(value="BillOfQuantities对象", description="工程量清单表")
@TableName("BIZ_BILL_OF_QUANTITIES")
@Data
public class BillOfQuantities extends BizModel<BillOfQuantities> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "清单类型,1:工单分包合同清单(合同内)，2：工程量清单(合同外)")
    @TableField("BILL_TYPE_")
    private Integer billType;

    @ApiModelProperty(value = "工单信息表ID")
    @TableField("WORK_ORDER_INFORMATION_ID_")
    private String workOrderInformationId;

    @ApiModelProperty(value = "合同明细表Id")
    @TableField("CONTRACT_ITEM_ID_")
    private String contractItemId;

    @ApiModelProperty(value = "明细表序号")
    @TableField("SORT_")
    private Integer sort;

    @ApiModelProperty(value = "科目编码")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "科目名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "细科目编码")
    @TableField("FINE_SUBJECT_CODE_")
    private String fineSubjectCode;

    @ApiModelProperty(value = "细科目名称")
    @TableField("FINE_SUBJECT_NAME_")
    private String fineSubjectName;

    @ApiModelProperty(value = "子科目编码")
    @TableField("SON_SUBJECT_CODE_")
    private String sonSubjectCode;

    @ApiModelProperty(value = "子科目名称")
    @TableField("SON_SUBJECT_NAME_")
    private String sonSubjectName;

    @ApiModelProperty(value = "单位")
    @TableField("SPEC_")
    private String spec;

    @ApiModelProperty(value = "单价（元）")
    @TableField("PRICE_")
    private Float price;

    @ApiModelProperty(value = "数量")
    @TableField("AMOUNT_")
    private Float amount = 0f;

    @ApiModelProperty(value = "金额（元）")
    @TableField("MONEY_")
    private Float money;

    @ApiModelProperty(value = "收方单价（元）")
    @TableField("RECEIVER_PRICE_")
    private Float receiverPrice;

    @ApiModelProperty(value = "收方数量")
    @TableField("RECEIVER_AMOUNT_")
    private Float receiverAmount;

    @ApiModelProperty(value = "收方金额（元）")
    @TableField("RECEIVER_MONEY_")
    private Float receiverMoney;

    @ApiModelProperty(value = "审核单价（元）")
    @TableField("AUDIT_PRICE_")
    private Float auditPrice;

    @ApiModelProperty(value = "审核数量")
    @TableField("AUDIT_AMOUNT_")
    private Float auditAmount;

    @ApiModelProperty(value = "审核金额（元）")
    @TableField("AUDIT_MONEY_")
    private Float auditMoney;

    @ApiModelProperty(value = "含税金额（元）")
    @TableField("TAX_MONEY_")
    private Float taxMoney;

    @ApiModelProperty(value = "工单号")
    @TableField(exist = false)
    private String jobNumber;
    @ApiModelProperty(value = "工单号")
    @TableField(exist = false)
    private Date debitTime;
    @ApiModelProperty(value = "位置")
    @TableField(exist = false)
    private String position;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BillOfQuantities{" +
            "id=" + id +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", workOrderInformationId=" + workOrderInformationId +
            ", contractItemId=" + contractItemId +
            ", sort=" + sort +
            ", number=" + number +
            ", subjectName=" + subjectName +
            ", fineSubjectName=" + fineSubjectName +
            ", spec=" + spec +
            ", price=" + price +
            ", amount=" + amount +
            ", money=" + money +
            ", receiverPrice=" + receiverPrice +
            ", receiverAmount=" + receiverAmount +
            ", receiverMoney=" + receiverMoney +
            ", auditPrice=" + auditPrice +
            ", auditAmount=" + auditAmount +
            ", auditMoney=" + auditMoney +

        "}";
    }
}
