package com.artfess.yhxt.budget.manager;

import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.budget.vo.YearBudgetDetailedVo;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;

import java.util.List;

/**
 * 年度总预算明细表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-02
 */
public interface YearBudgetDetailedManager extends BaseManager<YearBudgetDetailed> {

    /**
     * 保存预算明细后计算总金额
     * @param ascriptionYear
     */
    void saveYearBudget(Integer ascriptionYear,String yearBudgetId);

    PageList<YearBudgetDetailedVo> queryVo(QueryFilter<YearBudgetDetailed> queryFilter);

    YearBudgetDetailed getYearBudgetDetailedById(String id);
}
