package com.artfess.yhxt.basedata.vo;

import com.artfess.yhxt.basedata.model.BizStructureVehicle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 救援点统计
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@ApiModel(value="BizEmergencyRescueManagement对象", description="救援点统计")

@Data
public class BizEmergencyRescueManagement4OpenVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")

    private String id;

    @ApiModelProperty(value = "救援点名称")

    private String name;

    @ApiModelProperty(value = "人员数量")

    private Integer personnelQuantity;

    @ApiModelProperty(value = "救援点所在位置")

    private String locationMaintenanceArea;

    @ApiModelProperty(value = "经度")

    private Double lng;

    @ApiModelProperty(value = "纬度")

    private Double lat;

    @ApiModelProperty(value = "主线桩号")

    private String centPegK;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")

    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")

    private String roadSegmentName;

    @ApiModelProperty(value = "公司ID")

    private String companyId;

    @ApiModelProperty(value = "所属公司名称")

    private String companyName;

    @ApiModelProperty(value = "救援车辆信息")
    private Integer number;


}
