package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.BizEngineeringDrawing;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.vo.BizEngineeringDrawingVo;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigDecimal;

/**
 * 工程图纸表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-02
 */
public interface BizEngineeringDrawingManager extends BaseManager<BizEngineeringDrawing> {
    /**
     * @Description: 不分页查询
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<BizEngineeringDrawing> queryBizEngineeringDrawing(QueryFilter<BizEngineeringDrawing> queryFilter);

    /**
     * 逻辑删除
     * @param id
     */

    void updateBizEngineeringDrawing(String id);

    String minioDrawingUpload(MultipartFile file);

    /**
     * 根据ID 修改坐标桥梁坐标
     * @param id
     * @param x
     * @param y
     */
    void updateByBridgeCoordinate(String id, String x, String y);

    void updateByTunnelCoordinate(String id, String x, String y);

    void updateBySideSlopeCoordinate(String id, String x, String y);

    void updateByCulvertCoordinate(String id, String x, String y);

    /**
     * 保存工程图纸和附件信息
     * @param bizEngineeringDrawingVo
     */
    void saveVo(BizEngineeringDrawingVo bizEngineeringDrawingVo);

    /**
     * 修改工程图纸信息和附件信息
     * @param bizEngineeringDrawingVo
     */
    void updateVo(BizEngineeringDrawingVo bizEngineeringDrawingVo);

    /**
     * 工程图纸根据ID查询 & 对应附件信息
     * @param id
     * @return
     */
    BizEngineeringDrawingVo getVo(String id);
}
