package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.vo.SideSlopCheckVo;
import com.artfess.yhxt.basedata.vo.SideSlopeRegularVo;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.statistics.vo.Org4sideSlopelVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 边坡信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-28
 */
@RestController
@RequestMapping("/bizSideSlopeInformation/v1/")
@Api(tags = "边坡管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class SideSlopeInformationController extends BaseController<SideSlopeInformationManager, SideSlopeInformation> {

    @RequestMapping(value = "/saveSideSlope", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改边坡信息", httpMethod = "POST")
    public CommonResult<String> saveSideSlope(@ApiParam(name = "sideSlopeInformation", value = "桥梁对象") @RequestBody SideSlopeInformation sideSlopeInformation) throws Exception {
        String msg = "添加成功";
        //this.baseService.checkNumber(sideSlopeInformation);
        if (StringUtils.isEmpty(sideSlopeInformation.getId())) {
            sideSlopeInformation.setIsDele("0");
            sideSlopeInformation.setSn(baseService.getSn());
            baseService.saveSideSlope(sideSlopeInformation);
        } else {
            baseService.updateSideSlope(sideSlopeInformation);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "getSideSlopeVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取边坡统计", httpMethod = "POST", notes = "获取边坡统计")
    public List<Org4sideSlopelVO> getSideSlopeVo() throws Exception {
        return baseService.getsideSlopelCount();
    }

//    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
//    @ApiOperation(value = "分页查询边坡信息",httpMethod = "POST")
//    public PageList<SideSlopeInformationVo> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<SideSlopeInformation> queryFilter) {
//        IPage<SideSlopeInformationVo> bridgeInformationVoIPage = baseService.querySideSlope(queryFilter);
//        return new PageList<SideSlopeInformationVo>(bridgeInformationVoIPage);
//    }


    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询边坡信息",httpMethod = "POST")
    public PageList<SideSlopeInformation> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<SideSlopeInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<SideSlopeInformation> pageList = baseService.querySideSlopeInformation(queryFilter);
        return pageList;
    }

    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询边坡信息",httpMethod = "GET",notes = "根据ID查询边坡信息")
    public SideSlopeInformation get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getSideSlopeById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除边坡信息", httpMethod = "DELETE", notes = "批量删边坡信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateBridge", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除边坡信息", httpMethod = "POST", notes = "逻辑删除边坡信息")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<SideSlopeInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }


    @RequestMapping(value="/getJsonVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询边坡经常检查信息",httpMethod = "POST")
    public PageList<SideSlopCheckVo> getJsonVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<SideSlopeInformation> queryFilter) throws Exception {

        PageList<SideSlopCheckVo> pageList = baseService.querySideSlope(queryFilter);
        return pageList;
    }
    @RequestMapping(value="/getJsonRegularVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询边坡定期检查信息",httpMethod = "POST")
    public PageList<SideSlopeRegularVo> getJsonRegularVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<SideSlopeInformation> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<SideSlopeRegularVo> pageList = baseService.queryRegularSideSlope(queryFilter);
        return pageList;
    }
}
