package com.artfess.yhxt.File;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.seata.core.exception.GlobalTransactionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.hasor.utils.CheckUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author naf
 * @date 2023/4/19 17:39
 * @version 1.0
 * @description 文件下载
 */

@RequestMapping("/yhxt/api/file")
@RestController
@Api(tags = "文件下载")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class FileDownController {
    private static final Logger log = LoggerFactory.getLogger(FileDownController.class);
    private static   Map<Integer, List<String>> fileMap = new HashMap<>(16);
    static {
        fileMap.put(1, Arrays.asList("file/应急物资明细导入模版.xlsx"));
        fileMap.put(2, Arrays.asList("file/MQI导入模版.xlsx"));

    }

    @ApiOperation("文件-根据类型下载")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", name = "fileType", value = "文件类型 1-应急物资明细导入模版", required = true)
    })
    @GetMapping("/download")
    public void download(Integer fileType, HttpServletResponse response) {
       if(null == fileType){
           throw new RuntimeException("请选择文件");
       }

        final String exMsg = "根据类型下载文件失败";
        List<String> list = fileMap.get(fileType);
        try{
            OutputStream os =null;


            for (String path : list) {
                Resource resource = new ClassPathResource(path);
                // 实现文件下载
                byte[] buffer = new byte[1024];
                InputStream fis =  resource.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(fis);
                int i = bis.read(buffer);
                // 下载文件能正常显示中文
                // 配置文件下载
                os= response.getOutputStream();
                response.setHeader("content-type", "application/octet-stream");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(resource.getFilename(), "UTF-8"));

                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
                bis.close();

            }
            if (null!=os){
                os.flush();
                os.close();
            }

        }catch (Exception e) {
            log.error(exMsg, e);
        }

    }

}
