/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.SideSlopeInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.SideSlopeInformation;
import com.artfess.yhxt.check.detail.dao.SideSlopeOftenCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.SideSlopeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.SideSlopeOftenCheckDetail;
import com.artfess.yhxt.check.regular.dao.SideSlopeOftenCheckDao;
import com.artfess.yhxt.check.regular.manager.SideSlopeOftenCheckManager;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.vo.SideSlopeOftenCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SideSlopeOftenCheckManagerImpl
extends BaseManagerImpl<SideSlopeOftenCheckDao, SideSlopeOftenCheck>
implements SideSlopeOftenCheckManager {
    @Resource
    private SideSlopeOftenCheckDetailManager sideSlopeOftenCheckDetailManager;
    @Resource
    private SideSlopeOftenCheckDetailDao sideSlopeOftenCheckDetailDao;
    @Resource
    private SideSlopeInformationManager slopeInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<SideSlopeOftenCheck> querySideSlopeOftenCheck(QueryFilter<SideSlopeOftenCheck> queryFilter) {
        List sorter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (null == (sorter = queryFilter.getSorter()) || sorter.isEmpty()) {
            sorter.add(new FieldSort("CHECK_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        IPage<SideSlopeOftenCheck> result = ((SideSlopeOftenCheckDao)this.baseMapper).querySideSlopeOftenCheck((IPage<SideSlopeOftenCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SideSlopeOftenCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveSideSlopeOftenCheck(SideSlopeOftenCheckVo vo) {
        SideSlopeOftenCheck sideSlopeOftenCheck = vo.getSideSlopeOftenCheck();
        sideSlopeOftenCheck.setIsDele("0");
        this.saveOrUpdate((Object)sideSlopeOftenCheck);
        vo.getSideSlopeOftenCheckDetailList().forEach(s -> {
            s.setId(null);
            s.setSideSlopeOftenCheckId(sideSlopeOftenCheck.getId());
            this.sideSlopeOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = sideSlopeOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateSideSlopeOftenCheck(SideSlopeOftenCheckVo vo) {
        SideSlopeOftenCheck sideSlopeOftenCheck = vo.getSideSlopeOftenCheck();
        this.update((Model)sideSlopeOftenCheck);
        vo.getSideSlopeOftenCheckDetailList().forEach(s -> {
            s.setSideSlopeOftenCheckId(sideSlopeOftenCheck.getId());
            this.sideSlopeOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = sideSlopeOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public SideSlopeOftenCheckVo getSideSlopeOftenCheck(String id) {
        SideSlopeOftenCheckVo checkVo = new SideSlopeOftenCheckVo();
        SideSlopeOftenCheck sideSlopeOftenCheck = (SideSlopeOftenCheck)((Object)this.getById((Serializable)((Object)id)));
        if (sideSlopeOftenCheck != null) {
            checkVo.setSideSlopeOftenCheck(sideSlopeOftenCheck);
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)sideSlopeOftenCheck.getId())) {
                queryWrapper.eq((Object)"SIDE_SLOPE_OFTEN_CHECK_ID_", (Object)sideSlopeOftenCheck.getId());
                List sideSlopeOftenCheckDetailList = this.sideSlopeOftenCheckDetailDao.selectList((Wrapper)queryWrapper);
                checkVo.setSideSlopeOftenCheckDetailList(sideSlopeOftenCheckDetailList);
            }
            List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
            checkVo.setAccessories(accessories);
        }
        return checkVo;
    }

    private void saveSiteStatistic(SideSlopeOftenCheck sideSlopeOftenCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String checkId = sideSlopeOftenCheck.getSideSlopeId();
        SideSlopeInformation sideSlopeInformation = (SideSlopeInformation)((Object)this.slopeInformationManager.getById((Serializable)((Object)checkId)));
        siteStatistic.setRoadSegmentId(sideSlopeInformation.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(sideSlopeInformation.getRoadSegmentName());
        siteStatistic.setCompanyId(sideSlopeInformation.getCompanyId());
        siteStatistic.setCompanyName(sideSlopeInformation.getCompanyName());
        siteStatistic.setSiteCode(6);
        siteStatistic.setSiteName("\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5");
        Date checkDate = sideSlopeOftenCheck.getCheckDate();
        String month = new SimpleDateFormat("yyyy-MM").format(checkDate);
        siteStatistic.setAccDateMonth(month);
        String year = new SimpleDateFormat("yyyy").format(checkDate);
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sideSlopeInformation.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)sideSlopeInformation.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)sideSlopeInformation.getCompanyId()), (Object)"COMPANY_ID_", (Object)sideSlopeInformation.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)6);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u8fb9\u5761\u7ecf\u5e38\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }

    @Override
    public void importExcelData(MultipartFile file, SideSlopeOftenCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, SideSlopeOftenCheckDetail.class, (ImportParams)new ImportParams());
            SideSlopeOftenCheckVo vo = new SideSlopeOftenCheckVo();
            vo.setSideSlopeOftenCheck(parseObject);
            vo.setSideSlopeOftenCheckDetailList(data);
            this.saveSideSlopeOftenCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

