/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.dao.BizMqiCheckDataDao;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDataManager;
import com.artfess.yhxt.specialcheck.manager.BizMqiCheckDetailManager;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckData;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizMqiCheckDataManagerImpl
extends BaseManagerImpl<BizMqiCheckDataDao, BizMqiCheckData>
implements BizMqiCheckDataManager {
    @Autowired
    private BizMqiCheckDetailManager bizMqiCheckDetailManager;
    @Autowired
    private AccessoryManager accessoryManager;

    @Override
    public PageList<BizMqiCheckData> queryBizMqiCheckData(QueryFilter<BizMqiCheckData> queryFilter) {
        IPage<BizMqiCheckData> result = ((BizMqiCheckDataDao)this.baseMapper).queryBizMqiCheckData((IPage<BizMqiCheckData>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizMqiCheckData>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizMqiCheckDataVo getBizBridgeSpecialById(String id) {
        BizMqiCheckData bizMqiCheckData = (BizMqiCheckData)((Object)((BizMqiCheckDataDao)this.baseMapper).selectById((Serializable)((Object)id)));
        BizMqiCheckDataVo bizMqiCheckDataVo = new BizMqiCheckDataVo();
        bizMqiCheckDataVo.setBizMqiCheckData(bizMqiCheckData);
        if (null != bizMqiCheckData && StringUtils.isNotBlank((CharSequence)bizMqiCheckData.getId())) {
            bizMqiCheckDataVo.setDetailList(this.bizMqiCheckDetailManager.selectListByMqiDataId(id));
        }
        return bizMqiCheckDataVo;
    }

    @Override
    public void saveBizMqiCheckDataVo(BizMqiCheckDataVo vo) {
        BizMqiCheckData bizMqiCheckData = vo.getBizMqiCheckData();
        if (BeanUtils.isNotEmpty((Object)((Object)bizMqiCheckData))) {
            if (StringUtils.isEmpty((CharSequence)bizMqiCheckData.getId())) {
                bizMqiCheckData.setIsDele("0");
                this.save((Object)bizMqiCheckData);
            } else {
                this.update((Model)bizMqiCheckData);
            }
            if (vo.getDetailList() != null && vo.getDetailList().size() > 0) {
                vo.getDetailList().forEach(s -> {
                    s.setMqiDataId(bizMqiCheckData.getId());
                    if (StringUtils.isEmpty((CharSequence)s.getId())) {
                        this.bizMqiCheckDetailManager.save(s);
                    } else {
                        this.bizMqiCheckDetailManager.update((Model)s);
                    }
                });
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVo(BizMqiCheckDataVo vo) {
        BizMqiCheckData bizMqiCheckData = vo.getBizMqiCheckData();
        List<Accessory> accessoryList = vo.getAccessoryList();
        if (BeanUtils.isNotEmpty((Object)((Object)bizMqiCheckData))) {
            String id;
            if (StringUtils.isEmpty((CharSequence)bizMqiCheckData.getId())) {
                bizMqiCheckData.setIsDele("0");
                this.save((Object)bizMqiCheckData);
                if (accessoryList != null && accessoryList.size() > 0) {
                    id = bizMqiCheckData.getId();
                    this.accessoryManager.delAccessoryBySourceId(id);
                    accessoryList.forEach(s -> s.setSourceId(id));
                    this.accessoryManager.saveOrUpdateBatch(accessoryList);
                }
            } else {
                if (accessoryList != null && accessoryList.size() > 0) {
                    id = bizMqiCheckData.getId();
                    this.accessoryManager.delAccessoryBySourceId(id);
                    accessoryList.forEach(s -> s.setSourceId(id));
                    this.accessoryManager.saveOrUpdateBatch(accessoryList);
                }
                this.update((Model)bizMqiCheckData);
            }
            List<BizMqiCheckDetail> detailList = vo.getDetailList();
            BigDecimal mqiAverage = new BigDecimal(0);
            if (null != vo.getDetailList() && vo.getDetailList().size() > 0) {
                for (BizMqiCheckDetail bizMqiCheckDetail : detailList) {
                    bizMqiCheckDetail.setMqiDataId(bizMqiCheckData.getId());
                    Float mqiAvg = bizMqiCheckDetail.getMqiAvg();
                    if (null == mqiAvg) continue;
                    BigDecimal a = new BigDecimal(String.valueOf(mqiAvg));
                    mqiAverage = mqiAverage.add(a);
                }
                this.bizMqiCheckDetailManager.saveOrUpdateBatch(detailList);
                if (null != mqiAverage && mqiAverage.compareTo(BigDecimal.ZERO) != 0) {
                    mqiAverage = mqiAverage.divide(new BigDecimal(vo.getDetailList().size()), 4, 4);
                }
            }
            bizMqiCheckData.setMqiAverage(mqiAverage);
            this.update((Model)bizMqiCheckData);
        }
    }

    @Override
    public BizMqiCheckDataVo getVo(String id) {
        List<Accessory> accessoryList;
        BizMqiCheckData bizMqiCheckData = (BizMqiCheckData)((Object)((BizMqiCheckDataDao)this.baseMapper).selectById((Serializable)((Object)id)));
        BizMqiCheckDataVo bizMqiCheckDataVo = new BizMqiCheckDataVo();
        bizMqiCheckDataVo.setBizMqiCheckData(bizMqiCheckData);
        if (null != bizMqiCheckData && StringUtils.isNotBlank((CharSequence)bizMqiCheckData.getId())) {
            bizMqiCheckDataVo.setDetailList(this.bizMqiCheckDetailManager.selectListByMqiDataId(id));
        }
        if ((accessoryList = this.accessoryManager.getAccessoryBySourceId(id)) != null && accessoryList.size() > 0) {
            bizMqiCheckDataVo.setAccessoryList(accessoryList);
        }
        return bizMqiCheckDataVo;
    }
}

